/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.student.service.impl;

import com.baijia.wedo.common.enums.BackLogStatus;
import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.common.util.DateUtil;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.student.po.Student;
import com.baijia.wedo.dal.system.dao.BackLogDao;
import com.baijia.wedo.dal.system.po.BackLog;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.sal.student.dto.task.FollowTaskListAllDto;
import com.baijia.wedo.sal.student.dto.task.FollowTaskListRespDto;
import com.baijia.wedo.sal.student.service.FollowTaskService;
import com.beust.jcommander.internal.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FollowTaskServiceImpl
implements FollowTaskService {
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private BackLogDao backLogDao;
    @Autowired
    private UserDao userDao;

    @Override
    @Transactional(readOnly=true)
    public FollowTaskListAllDto getFollowTasks(long id) {
        Student student = (Student)this.studentDao.getById((Serializable)Long.valueOf(id), new String[0]);
        if (student == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        List tasks = this.backLogDao.getNoticeBackLogByTarget(Integer.valueOf(1), id);
        FollowTaskListAllDto taskList = new FollowTaskListAllDto();
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return taskList;
        }
        Set principalIds = BaseUtils.getPropertiesList((Collection)tasks, (String)"id");
        Map<Long, User> principalMap = this.getUsersMap(principalIds);
        Date nowEnd = DateUtil.getEndOfDay((Date)new Date());
        Date now = DateUtil.getEndOfDay((Date)new Date());
        for (BackLog task : tasks) {
            FollowTaskListRespDto dto = new FollowTaskListRespDto();
            dto.setId(task.getId());
            dto.setTitle(task.getTitle());
            dto.setExpiration(task.getExpireTime().getTime());
            dto.setPrincipalId(task.getUserId());
            dto.setPrincipalName(principalMap.get(task.getUserId()) == null ? null : principalMap.get(task.getUserId()).getName());
            if (task.getStatus() == BackLogStatus.SUCC.getStatus()) {
                taskList.getCompletedList().add(dto);
                continue;
            }
            if (task.getExpireTime().after(nowEnd)) {
                taskList.getFutureList().add(dto);
                continue;
            }
            if (task.getExpireTime().before(now)) {
                taskList.getExpireList().add(dto);
                continue;
            }
            taskList.getTodayList().add(dto);
        }
        return taskList;
    }

    private Map<Long, User> getUsersMap(Collection<Long> userIds) {
        List users = this.userDao.getNoDelUsersByIds(userIds, new String[]{"id", "name"});
        if (CollectionUtils.isEmpty((Collection)users)) {
            return Maps.newHashMap();
        }
        return BaseUtils.listToMap((List)users, (String)"id");
    }
}

