/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.student.dto.teach;

import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.dal.student.po.StudentTeachEffect;
import java.util.Date;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class TeachEffectBase {
    private Long id;
    private Long studentId;
    private String name;
    private Integer testType;
    private Long testTime;
    private Double total;
    private Double listening;
    private Double reading;
    private Double writing;
    private Double speaking;

    public static void toTeachEffectDto(StudentTeachEffect teachEffect, TeachEffectBase dto) {
        dto.setId(teachEffect.getId());
        dto.setStudentId(teachEffect.getStudentId());
        dto.setName(teachEffect.getName());
        dto.setTestType(teachEffect.getTestType());
        dto.setTestTime(teachEffect.getTestTime() == null ? 0L : teachEffect.getTestTime().getTime());
        dto.setTotal(BaseUtils.divided((Long)teachEffect.getTotal(), (Integer)100, (int)2));
        if (teachEffect.getListening() != null) {
            dto.setListening(BaseUtils.divided((Long)teachEffect.getListening(), (Integer)100, (int)2));
        }
        if (teachEffect.getReading() != null) {
            dto.setReading(BaseUtils.divided((Long)teachEffect.getReading(), (Integer)100, (int)2));
        }
        if (teachEffect.getWriting() != null) {
            dto.setWriting(BaseUtils.divided((Long)teachEffect.getWriting(), (Integer)100, (int)2));
        }
        if (teachEffect.getReading() != null) {
            dto.setSpeaking(BaseUtils.divided((Long)teachEffect.getReading(), (Integer)100, (int)2));
        }
    }

    public static void toTeachEffect(StudentTeachEffect teachEffect, TeachEffectBase dto) {
        if (dto.getId() != null) {
            teachEffect.setId(dto.getId().longValue());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getName())) {
            teachEffect.setName(dto.getName());
        } else {
            teachEffect.setName("");
        }
        if (dto.getListening() != null) {
            teachEffect.setListening(BaseUtils.plus((Double)dto.getListening(), (int)100));
        }
        if (dto.getReading() != null) {
            teachEffect.setReading(BaseUtils.plus((Double)dto.getReading(), (int)100));
        }
        if (dto.getSpeaking() != null) {
            teachEffect.setSpeaking(BaseUtils.plus((Double)dto.getSpeaking(), (int)100));
        }
        if (dto.getTotal() != null) {
            teachEffect.setTotal(BaseUtils.plus((Double)dto.getTotal(), (int)100));
        } else {
            teachEffect.setTotal(NumberUtils.LONG_ZERO);
        }
        if (dto.getWriting() != null) {
            teachEffect.setWriting(BaseUtils.plus((Double)dto.getWriting(), (int)100));
        }
        if (dto.getStudentId() != null) {
            teachEffect.setStudentId(dto.getStudentId().longValue());
        } else {
            teachEffect.setStudentId(NumberUtils.LONG_ZERO.longValue());
        }
        if (dto.getTestTime() != null) {
            teachEffect.setTestTime(new Date(dto.getTestTime()));
        } else {
            teachEffect.setTestTime(new Date());
        }
        if (dto.getTestType() != null) {
            teachEffect.setTestType(dto.getTestType());
        } else {
            dto.setTestType(NumberUtils.INTEGER_ZERO);
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getStudentId() {
        return this.studentId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getTestType() {
        return this.testType;
    }

    public Long getTestTime() {
        return this.testTime;
    }

    public Double getTotal() {
        return this.total;
    }

    public Double getListening() {
        return this.listening;
    }

    public Double getReading() {
        return this.reading;
    }

    public Double getWriting() {
        return this.writing;
    }

    public Double getSpeaking() {
        return this.speaking;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setStudentId(Long studentId) {
        this.studentId = studentId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTestType(Integer testType) {
        this.testType = testType;
    }

    public void setTestTime(Long testTime) {
        this.testTime = testTime;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public void setListening(Double listening) {
        this.listening = listening;
    }

    public void setReading(Double reading) {
        this.reading = reading;
    }

    public void setWriting(Double writing) {
        this.writing = writing;
    }

    public void setSpeaking(Double speaking) {
        this.speaking = speaking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TeachEffectBase)) {
            return false;
        }
        TeachEffectBase other = (TeachEffectBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$studentId = this.getStudentId();
        Long other$studentId = other.getStudentId();
        if (this$studentId == null ? other$studentId != null : !((Object)this$studentId).equals(other$studentId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Integer this$testType = this.getTestType();
        Integer other$testType = other.getTestType();
        if (this$testType == null ? other$testType != null : !((Object)this$testType).equals(other$testType)) {
            return false;
        }
        Long this$testTime = this.getTestTime();
        Long other$testTime = other.getTestTime();
        if (this$testTime == null ? other$testTime != null : !((Object)this$testTime).equals(other$testTime)) {
            return false;
        }
        Double this$total = this.getTotal();
        Double other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Double this$listening = this.getListening();
        Double other$listening = other.getListening();
        if (this$listening == null ? other$listening != null : !((Object)this$listening).equals(other$listening)) {
            return false;
        }
        Double this$reading = this.getReading();
        Double other$reading = other.getReading();
        if (this$reading == null ? other$reading != null : !((Object)this$reading).equals(other$reading)) {
            return false;
        }
        Double this$writing = this.getWriting();
        Double other$writing = other.getWriting();
        if (this$writing == null ? other$writing != null : !((Object)this$writing).equals(other$writing)) {
            return false;
        }
        Double this$speaking = this.getSpeaking();
        Double other$speaking = other.getSpeaking();
        return !(this$speaking == null ? other$speaking != null : !((Object)this$speaking).equals(other$speaking));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TeachEffectBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $studentId = this.getStudentId();
        result = result * 59 + ($studentId == null ? 43 : ((Object)$studentId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Integer $testType = this.getTestType();
        result = result * 59 + ($testType == null ? 43 : ((Object)$testType).hashCode());
        Long $testTime = this.getTestTime();
        result = result * 59 + ($testTime == null ? 43 : ((Object)$testTime).hashCode());
        Double $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Double $listening = this.getListening();
        result = result * 59 + ($listening == null ? 43 : ((Object)$listening).hashCode());
        Double $reading = this.getReading();
        result = result * 59 + ($reading == null ? 43 : ((Object)$reading).hashCode());
        Double $writing = this.getWriting();
        result = result * 59 + ($writing == null ? 43 : ((Object)$writing).hashCode());
        Double $speaking = this.getSpeaking();
        result = result * 59 + ($speaking == null ? 43 : ((Object)$speaking).hashCode());
        return result;
    }

    public String toString() {
        return "TeachEffectBase(id=" + this.getId() + ", studentId=" + this.getStudentId() + ", name=" + this.getName() + ", testType=" + this.getTestType() + ", testTime=" + this.getTestTime() + ", total=" + this.getTotal() + ", listening=" + this.getListening() + ", reading=" + this.getReading() + ", writing=" + this.getWriting() + ", speaking=" + this.getSpeaking() + ")";
    }
}

