/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.student.dto.learning;

import com.baijia.wedo.common.constant.BizConf;
import com.baijia.wedo.common.enums.schedule.RepeatUnit;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.sal.student.dto.learning.LearningSubtaskAddDto;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LearningTaskAddReqDto {
    private Long studentId;
    private Long taskDate;
    private Long startTime;
    private Long endTime;
    private List<LearningSubtaskAddDto> subtasks;
    private int enableRepeat;
    private Integer repeatUnit;
    private String weekDays;
    private Integer repeatRange;
    private Integer repeatCount;
    private String calendarDays;

    public RepeatUnit getRepeatUnit() {
        RepeatUnit result = RepeatUnit.getByCode((Integer)this.repeatUnit);
        if (result == null) {
            result = RepeatUnit.NONE;
        }
        return result;
    }

    public void validate() {
        if (this.startTime == null || this.endTime == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.startTime > this.endTime) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        if (this.enableRepeat == BizConf.TRUE) {
            RepeatUnit unit = this.getRepeatUnit();
            if (unit == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u91cd\u590d\u7684\u65f6\u95f4\u7c92\u5ea6\u9519\u8bef");
            }
            if (unit == RepeatUnit.CalendarDIY && StringUtils.isEmpty((CharSequence)this.calendarDays)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u52fe\u9009\u65e5\u671f");
            }
            if (unit == RepeatUnit.WeekDIY && StringUtils.isEmpty((CharSequence)this.weekDays)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u9009\u62e9\u6bcf\u5468\u51e0\u91cd\u590d");
            }
            if ((this.repeatCount == null || this.repeatCount <= 0 || this.repeatCount > 99) && unit != RepeatUnit.CalendarDIY) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u91cd\u590d\u8bfe\u8282\u6570\u8303\u56f41-99");
            }
            if ((this.repeatRange == null || this.repeatRange <= 0) && unit != RepeatUnit.CalendarDIY) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u91cd\u590d\u8bfe\u8282\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u5c0f\u4e8e0");
            }
        }
    }

    public Long getStudentId() {
        return this.studentId;
    }

    public Long getTaskDate() {
        return this.taskDate;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public List<LearningSubtaskAddDto> getSubtasks() {
        return this.subtasks;
    }

    public int getEnableRepeat() {
        return this.enableRepeat;
    }

    public String getWeekDays() {
        return this.weekDays;
    }

    public Integer getRepeatRange() {
        return this.repeatRange;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public String getCalendarDays() {
        return this.calendarDays;
    }

    public void setStudentId(Long studentId) {
        this.studentId = studentId;
    }

    public void setTaskDate(Long taskDate) {
        this.taskDate = taskDate;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setSubtasks(List<LearningSubtaskAddDto> subtasks) {
        this.subtasks = subtasks;
    }

    public void setEnableRepeat(int enableRepeat) {
        this.enableRepeat = enableRepeat;
    }

    public void setRepeatUnit(Integer repeatUnit) {
        this.repeatUnit = repeatUnit;
    }

    public void setWeekDays(String weekDays) {
        this.weekDays = weekDays;
    }

    public void setRepeatRange(Integer repeatRange) {
        this.repeatRange = repeatRange;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setCalendarDays(String calendarDays) {
        this.calendarDays = calendarDays;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LearningTaskAddReqDto)) {
            return false;
        }
        LearningTaskAddReqDto other = (LearningTaskAddReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$studentId = this.getStudentId();
        Long other$studentId = other.getStudentId();
        if (this$studentId == null ? other$studentId != null : !((Object)this$studentId).equals(other$studentId)) {
            return false;
        }
        Long this$taskDate = this.getTaskDate();
        Long other$taskDate = other.getTaskDate();
        if (this$taskDate == null ? other$taskDate != null : !((Object)this$taskDate).equals(other$taskDate)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List<LearningSubtaskAddDto> this$subtasks = this.getSubtasks();
        List<LearningSubtaskAddDto> other$subtasks = other.getSubtasks();
        if (this$subtasks == null ? other$subtasks != null : !((Object)this$subtasks).equals(other$subtasks)) {
            return false;
        }
        if (this.getEnableRepeat() != other.getEnableRepeat()) {
            return false;
        }
        RepeatUnit this$repeatUnit = this.getRepeatUnit();
        RepeatUnit other$repeatUnit = other.getRepeatUnit();
        if (this$repeatUnit == null ? other$repeatUnit != null : !this$repeatUnit.equals(other$repeatUnit)) {
            return false;
        }
        String this$weekDays = this.getWeekDays();
        String other$weekDays = other.getWeekDays();
        if (this$weekDays == null ? other$weekDays != null : !this$weekDays.equals(other$weekDays)) {
            return false;
        }
        Integer this$repeatRange = this.getRepeatRange();
        Integer other$repeatRange = other.getRepeatRange();
        if (this$repeatRange == null ? other$repeatRange != null : !((Object)this$repeatRange).equals(other$repeatRange)) {
            return false;
        }
        Integer this$repeatCount = this.getRepeatCount();
        Integer other$repeatCount = other.getRepeatCount();
        if (this$repeatCount == null ? other$repeatCount != null : !((Object)this$repeatCount).equals(other$repeatCount)) {
            return false;
        }
        String this$calendarDays = this.getCalendarDays();
        String other$calendarDays = other.getCalendarDays();
        return !(this$calendarDays == null ? other$calendarDays != null : !this$calendarDays.equals(other$calendarDays));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LearningTaskAddReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $studentId = this.getStudentId();
        result = result * 59 + ($studentId == null ? 43 : ((Object)$studentId).hashCode());
        Long $taskDate = this.getTaskDate();
        result = result * 59 + ($taskDate == null ? 43 : ((Object)$taskDate).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List<LearningSubtaskAddDto> $subtasks = this.getSubtasks();
        result = result * 59 + ($subtasks == null ? 43 : ((Object)$subtasks).hashCode());
        result = result * 59 + this.getEnableRepeat();
        RepeatUnit $repeatUnit = this.getRepeatUnit();
        result = result * 59 + ($repeatUnit == null ? 43 : $repeatUnit.hashCode());
        String $weekDays = this.getWeekDays();
        result = result * 59 + ($weekDays == null ? 43 : $weekDays.hashCode());
        Integer $repeatRange = this.getRepeatRange();
        result = result * 59 + ($repeatRange == null ? 43 : ((Object)$repeatRange).hashCode());
        Integer $repeatCount = this.getRepeatCount();
        result = result * 59 + ($repeatCount == null ? 43 : ((Object)$repeatCount).hashCode());
        String $calendarDays = this.getCalendarDays();
        result = result * 59 + ($calendarDays == null ? 43 : $calendarDays.hashCode());
        return result;
    }

    public String toString() {
        return "LearningTaskAddReqDto(studentId=" + this.getStudentId() + ", taskDate=" + this.getTaskDate() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", subtasks=" + this.getSubtasks() + ", enableRepeat=" + this.getEnableRepeat() + ", repeatUnit=" + this.getRepeatUnit() + ", weekDays=" + this.getWeekDays() + ", repeatRange=" + this.getRepeatRange() + ", repeatCount=" + this.getRepeatCount() + ", calendarDays=" + this.getCalendarDays() + ")";
    }
}

