/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.student.dto;

import com.baijia.wedo.common.enums.ChannelType;
import com.baijia.wedo.common.enums.ConsultStatus;
import com.baijia.wedo.common.enums.GenderType;
import com.baijia.wedo.common.enums.RelationType;
import com.baijia.wedo.common.enums.StudyPhase;
import com.baijia.wedo.common.enums.YesOrNoType;
import com.baijia.wedo.dal.student.po.Student;
import com.baijia.wedo.sal.student.dto.StudentBaseDto;
import com.google.common.base.Preconditions;
import java.util.List;

public class ClueListResponseDto
extends StudentBaseDto {
    private String relationTypeStr;
    private String schoolName;
    private String channelTypeStr;
    private String genderStr;
    private String subjectName;
    private String contactsRelationTypeStr;
    private String contacts2RelationTypeStr;
    private String takeExamStr;
    private String hasIntermediaryStr;
    private String studyPhaseStr;
    private String consultStatusStr;
    private String canRecommendStr;
    private String hasDepositeStr;
    private Long creatorId;
    private String creatorName;
    private Long createTime;
    private Long tmkId;
    private String tmkName;
    private Long tmkAllocateTime;
    private Long adviserId;
    private String adviserName;
    private Long adviserAllocateTime;
    private Integer clueStatus;
    private Integer followedDate;
    private Integer leftFollowDate;
    private Long marketId;
    private String marketName;

    public static void toDto(Student student, ClueListResponseDto dto) {
        Preconditions.checkArgument((student != null ? 1 : 0) != 0, (Object)"student is null");
        StudentBaseDto.toDto(dto, student);
        dto.setRelationTypeStr(RelationType.getLableByType((Integer)student.getRelationType()));
        dto.setChannelTypeStr(ChannelType.getLabelByType((Integer)student.getChannelType()));
        dto.setGenderStr(GenderType.getLableByType((Integer)student.getGender()));
        dto.setContactsRelationTypeStr(RelationType.getLableByType((Integer)student.getContactsRelationType()));
        dto.setContacts2RelationTypeStr(RelationType.getLableByType((Integer)student.getContacts2RelationType()));
        dto.setTakeExamStr(YesOrNoType.getLableByType((Integer)student.getTakeExam()));
        dto.setHasDepositeStr(YesOrNoType.getLableByType((Integer)student.getHasDeposite()));
        dto.setStudyPhaseStr(StudyPhase.getLable((int)student.getStudyPhase()));
        dto.setConsultStatusStr(ConsultStatus.getLableByType((Integer)student.getConsultStatus()));
        dto.setCanRecommendStr(YesOrNoType.getLableByType((Integer)student.getCanRecommend()));
        dto.setHasDepositeStr(YesOrNoType.getLableByType((Integer)student.getHasDeposite()));
        dto.setCreatorId(student.getCreatorId());
        dto.setCreateTime(student.getCreateTime() == null ? 0L : student.getCreateTime().getTime());
        dto.setHasIntermediaryStr(YesOrNoType.getLableByType((Integer)student.getHasIntermediary()));
        dto.setTmkId(student.getTmkId());
        dto.setAdviserId(student.getAdviserId());
        if (student.getAdviserAllocateTime() != null) {
            dto.setAdviserAllocateTime(student.getAdviserAllocateTime().getTime());
        }
        if (student.getTmkAllocateTime() != null) {
            dto.setTmkAllocateTime(student.getTmkAllocateTime().getTime());
        }
        dto.setClueStatus(student.getStatus());
    }

    public static void generateTmkHeaderAndFileName(List<String> filedName, List<String> filedValue) {
        filedName.add("name");
        filedValue.add("\u59d3\u540d");
        filedName.add("relationTypeStr");
        filedValue.add("\u8eab\u4efd");
        filedName.add("mobile");
        filedValue.add("\u624b\u673a\u53f7");
        filedName.add("schoolName");
        filedValue.add("\u6821\u533a");
        filedName.add("channelTypeStr");
        filedValue.add("\u6765\u6e90\u6e20\u9053");
        filedName.add("sourceDetail");
        filedValue.add("\u6765\u6e90\u660e\u7ec6");
        filedName.add("agent");
        filedValue.add("\u4ee3\u7406\u4eba");
        filedName.add("genderStr");
        filedValue.add("\u5b66\u5458\u6027\u522b");
        filedName.add("subjectName");
        filedValue.add("\u9884\u671f\u8bfe\u7a0b");
        filedName.add("purposerCountry");
        filedValue.add("\u610f\u5411\u56fd\u5bb6");
        filedName.add("studySchool");
        filedValue.add("\u5b66\u6821");
        filedName.add("grade");
        filedValue.add("\u5e74\u7ea7");
        filedName.add("major");
        filedValue.add("\u4e13\u4e1a");
        filedName.add("mail");
        filedValue.add("\u90ae\u7bb1");
        filedName.add("qq");
        filedValue.add("QQ");
        filedName.add("wechat");
        filedValue.add("\u5fae\u4fe1\u53f7");
        filedName.add("address");
        filedValue.add("\u5bb6\u5ead\u4f4f\u5740");
        filedName.add("hasIntermediaryStr");
        filedValue.add("\u65e2\u5b9a\u4e2d\u4ecb");
        filedName.add("intermediaryName");
        filedValue.add("\u4e2d\u4ecb\u540d\u79f0");
        filedName.add("studyPhaseStr");
        filedValue.add("\u610f\u5411\u7ea7\u522b");
        filedName.add("consultStatusStr");
        filedValue.add("\u8ddf\u8fdb\u72b6\u6001");
        filedName.add("contactsName");
        filedValue.add("\u59d3\u540d");
        filedName.add("contactsRelationTypeStr");
        filedValue.add("\u8eab\u4efd");
        filedName.add("contactsMobile");
        filedValue.add("\u624b\u673a\u53f7");
        filedName.add("contactsEmail");
        filedValue.add("\u90ae\u7bb1");
        filedName.add("contacts2Name");
        filedValue.add("\u59d3\u540d");
        filedName.add("contacts2RelationTypeStr");
        filedValue.add("\u8eab\u4efd");
        filedName.add("contacts2Mobile");
        filedValue.add("\u624b\u673a\u53f7");
        filedName.add("contacts2Email");
        filedValue.add("\u90ae\u7bb1");
        filedName.add("takeExamStr");
        filedValue.add("\u662f\u5426\u53c2\u52a0\u8003\u8bd5");
        filedName.add("takeScore");
        filedValue.add("\u8003\u8bd5\u6210\u7ee9");
        filedName.add("remarks");
        filedValue.add("\u5907\u6ce8");
        filedName.add("creatorName");
        filedValue.add("\u521b\u5efa\u4eba");
        filedName.add("createTime");
        filedValue.add("\u521b\u5efa\u65f6\u95f4");
        filedName.add("tmkName");
        filedValue.add("\u7535\u9500\u5750\u5e2d");
    }

    public static void generateCCHeaderAndFileName(List<String> filedName, List<String> filedValue) {
        ClueListResponseDto.generateTmkHeaderAndFileName(filedName, filedValue);
        filedName.add("adviserName");
        filedValue.add("\u8bfe\u7a0b\u987e\u95ee");
        filedName.add("hasDepositeStr");
        filedValue.add("\u7f34\u7eb3\u5b9a\u91d1");
        filedName.add("deposite");
        filedValue.add("\u8ba2\u91d1\u91d1\u989d");
    }

    public String getRelationTypeStr() {
        return this.relationTypeStr;
    }

    public String getSchoolName() {
        return this.schoolName;
    }

    public String getChannelTypeStr() {
        return this.channelTypeStr;
    }

    public String getGenderStr() {
        return this.genderStr;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public String getContactsRelationTypeStr() {
        return this.contactsRelationTypeStr;
    }

    public String getContacts2RelationTypeStr() {
        return this.contacts2RelationTypeStr;
    }

    public String getTakeExamStr() {
        return this.takeExamStr;
    }

    public String getHasIntermediaryStr() {
        return this.hasIntermediaryStr;
    }

    public String getStudyPhaseStr() {
        return this.studyPhaseStr;
    }

    public String getConsultStatusStr() {
        return this.consultStatusStr;
    }

    public String getCanRecommendStr() {
        return this.canRecommendStr;
    }

    public String getHasDepositeStr() {
        return this.hasDepositeStr;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getTmkId() {
        return this.tmkId;
    }

    public String getTmkName() {
        return this.tmkName;
    }

    public Long getTmkAllocateTime() {
        return this.tmkAllocateTime;
    }

    public Long getAdviserId() {
        return this.adviserId;
    }

    public String getAdviserName() {
        return this.adviserName;
    }

    public Long getAdviserAllocateTime() {
        return this.adviserAllocateTime;
    }

    public Integer getClueStatus() {
        return this.clueStatus;
    }

    public Integer getFollowedDate() {
        return this.followedDate;
    }

    public Integer getLeftFollowDate() {
        return this.leftFollowDate;
    }

    public Long getMarketId() {
        return this.marketId;
    }

    public String getMarketName() {
        return this.marketName;
    }

    public void setRelationTypeStr(String relationTypeStr) {
        this.relationTypeStr = relationTypeStr;
    }

    public void setSchoolName(String schoolName) {
        this.schoolName = schoolName;
    }

    public void setChannelTypeStr(String channelTypeStr) {
        this.channelTypeStr = channelTypeStr;
    }

    public void setGenderStr(String genderStr) {
        this.genderStr = genderStr;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public void setContactsRelationTypeStr(String contactsRelationTypeStr) {
        this.contactsRelationTypeStr = contactsRelationTypeStr;
    }

    public void setContacts2RelationTypeStr(String contacts2RelationTypeStr) {
        this.contacts2RelationTypeStr = contacts2RelationTypeStr;
    }

    public void setTakeExamStr(String takeExamStr) {
        this.takeExamStr = takeExamStr;
    }

    public void setHasIntermediaryStr(String hasIntermediaryStr) {
        this.hasIntermediaryStr = hasIntermediaryStr;
    }

    public void setStudyPhaseStr(String studyPhaseStr) {
        this.studyPhaseStr = studyPhaseStr;
    }

    public void setConsultStatusStr(String consultStatusStr) {
        this.consultStatusStr = consultStatusStr;
    }

    public void setCanRecommendStr(String canRecommendStr) {
        this.canRecommendStr = canRecommendStr;
    }

    public void setHasDepositeStr(String hasDepositeStr) {
        this.hasDepositeStr = hasDepositeStr;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setTmkId(Long tmkId) {
        this.tmkId = tmkId;
    }

    public void setTmkName(String tmkName) {
        this.tmkName = tmkName;
    }

    public void setTmkAllocateTime(Long tmkAllocateTime) {
        this.tmkAllocateTime = tmkAllocateTime;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public void setAdviserName(String adviserName) {
        this.adviserName = adviserName;
    }

    public void setAdviserAllocateTime(Long adviserAllocateTime) {
        this.adviserAllocateTime = adviserAllocateTime;
    }

    public void setClueStatus(Integer clueStatus) {
        this.clueStatus = clueStatus;
    }

    public void setFollowedDate(Integer followedDate) {
        this.followedDate = followedDate;
    }

    public void setLeftFollowDate(Integer leftFollowDate) {
        this.leftFollowDate = leftFollowDate;
    }

    public void setMarketId(Long marketId) {
        this.marketId = marketId;
    }

    public void setMarketName(String marketName) {
        this.marketName = marketName;
    }

    @Override
    public String toString() {
        return "ClueListResponseDto(relationTypeStr=" + this.getRelationTypeStr() + ", schoolName=" + this.getSchoolName() + ", channelTypeStr=" + this.getChannelTypeStr() + ", genderStr=" + this.getGenderStr() + ", subjectName=" + this.getSubjectName() + ", contactsRelationTypeStr=" + this.getContactsRelationTypeStr() + ", contacts2RelationTypeStr=" + this.getContacts2RelationTypeStr() + ", takeExamStr=" + this.getTakeExamStr() + ", hasIntermediaryStr=" + this.getHasIntermediaryStr() + ", studyPhaseStr=" + this.getStudyPhaseStr() + ", consultStatusStr=" + this.getConsultStatusStr() + ", canRecommendStr=" + this.getCanRecommendStr() + ", hasDepositeStr=" + this.getHasDepositeStr() + ", creatorId=" + this.getCreatorId() + ", creatorName=" + this.getCreatorName() + ", createTime=" + this.getCreateTime() + ", tmkId=" + this.getTmkId() + ", tmkName=" + this.getTmkName() + ", tmkAllocateTime=" + this.getTmkAllocateTime() + ", adviserId=" + this.getAdviserId() + ", adviserName=" + this.getAdviserName() + ", adviserAllocateTime=" + this.getAdviserAllocateTime() + ", clueStatus=" + this.getClueStatus() + ", followedDate=" + this.getFollowedDate() + ", leftFollowDate=" + this.getLeftFollowDate() + ", marketId=" + this.getMarketId() + ", marketName=" + this.getMarketName() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClueListResponseDto)) {
            return false;
        }
        ClueListResponseDto other = (ClueListResponseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$relationTypeStr = this.getRelationTypeStr();
        String other$relationTypeStr = other.getRelationTypeStr();
        if (this$relationTypeStr == null ? other$relationTypeStr != null : !this$relationTypeStr.equals(other$relationTypeStr)) {
            return false;
        }
        String this$schoolName = this.getSchoolName();
        String other$schoolName = other.getSchoolName();
        if (this$schoolName == null ? other$schoolName != null : !this$schoolName.equals(other$schoolName)) {
            return false;
        }
        String this$channelTypeStr = this.getChannelTypeStr();
        String other$channelTypeStr = other.getChannelTypeStr();
        if (this$channelTypeStr == null ? other$channelTypeStr != null : !this$channelTypeStr.equals(other$channelTypeStr)) {
            return false;
        }
        String this$genderStr = this.getGenderStr();
        String other$genderStr = other.getGenderStr();
        if (this$genderStr == null ? other$genderStr != null : !this$genderStr.equals(other$genderStr)) {
            return false;
        }
        String this$subjectName = this.getSubjectName();
        String other$subjectName = other.getSubjectName();
        if (this$subjectName == null ? other$subjectName != null : !this$subjectName.equals(other$subjectName)) {
            return false;
        }
        String this$contactsRelationTypeStr = this.getContactsRelationTypeStr();
        String other$contactsRelationTypeStr = other.getContactsRelationTypeStr();
        if (this$contactsRelationTypeStr == null ? other$contactsRelationTypeStr != null : !this$contactsRelationTypeStr.equals(other$contactsRelationTypeStr)) {
            return false;
        }
        String this$contacts2RelationTypeStr = this.getContacts2RelationTypeStr();
        String other$contacts2RelationTypeStr = other.getContacts2RelationTypeStr();
        if (this$contacts2RelationTypeStr == null ? other$contacts2RelationTypeStr != null : !this$contacts2RelationTypeStr.equals(other$contacts2RelationTypeStr)) {
            return false;
        }
        String this$takeExamStr = this.getTakeExamStr();
        String other$takeExamStr = other.getTakeExamStr();
        if (this$takeExamStr == null ? other$takeExamStr != null : !this$takeExamStr.equals(other$takeExamStr)) {
            return false;
        }
        String this$hasIntermediaryStr = this.getHasIntermediaryStr();
        String other$hasIntermediaryStr = other.getHasIntermediaryStr();
        if (this$hasIntermediaryStr == null ? other$hasIntermediaryStr != null : !this$hasIntermediaryStr.equals(other$hasIntermediaryStr)) {
            return false;
        }
        String this$studyPhaseStr = this.getStudyPhaseStr();
        String other$studyPhaseStr = other.getStudyPhaseStr();
        if (this$studyPhaseStr == null ? other$studyPhaseStr != null : !this$studyPhaseStr.equals(other$studyPhaseStr)) {
            return false;
        }
        String this$consultStatusStr = this.getConsultStatusStr();
        String other$consultStatusStr = other.getConsultStatusStr();
        if (this$consultStatusStr == null ? other$consultStatusStr != null : !this$consultStatusStr.equals(other$consultStatusStr)) {
            return false;
        }
        String this$canRecommendStr = this.getCanRecommendStr();
        String other$canRecommendStr = other.getCanRecommendStr();
        if (this$canRecommendStr == null ? other$canRecommendStr != null : !this$canRecommendStr.equals(other$canRecommendStr)) {
            return false;
        }
        String this$hasDepositeStr = this.getHasDepositeStr();
        String other$hasDepositeStr = other.getHasDepositeStr();
        if (this$hasDepositeStr == null ? other$hasDepositeStr != null : !this$hasDepositeStr.equals(other$hasDepositeStr)) {
            return false;
        }
        Long this$creatorId = this.getCreatorId();
        Long other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Long this$tmkId = this.getTmkId();
        Long other$tmkId = other.getTmkId();
        if (this$tmkId == null ? other$tmkId != null : !((Object)this$tmkId).equals(other$tmkId)) {
            return false;
        }
        String this$tmkName = this.getTmkName();
        String other$tmkName = other.getTmkName();
        if (this$tmkName == null ? other$tmkName != null : !this$tmkName.equals(other$tmkName)) {
            return false;
        }
        Long this$tmkAllocateTime = this.getTmkAllocateTime();
        Long other$tmkAllocateTime = other.getTmkAllocateTime();
        if (this$tmkAllocateTime == null ? other$tmkAllocateTime != null : !((Object)this$tmkAllocateTime).equals(other$tmkAllocateTime)) {
            return false;
        }
        Long this$adviserId = this.getAdviserId();
        Long other$adviserId = other.getAdviserId();
        if (this$adviserId == null ? other$adviserId != null : !((Object)this$adviserId).equals(other$adviserId)) {
            return false;
        }
        String this$adviserName = this.getAdviserName();
        String other$adviserName = other.getAdviserName();
        if (this$adviserName == null ? other$adviserName != null : !this$adviserName.equals(other$adviserName)) {
            return false;
        }
        Long this$adviserAllocateTime = this.getAdviserAllocateTime();
        Long other$adviserAllocateTime = other.getAdviserAllocateTime();
        if (this$adviserAllocateTime == null ? other$adviserAllocateTime != null : !((Object)this$adviserAllocateTime).equals(other$adviserAllocateTime)) {
            return false;
        }
        Integer this$clueStatus = this.getClueStatus();
        Integer other$clueStatus = other.getClueStatus();
        if (this$clueStatus == null ? other$clueStatus != null : !((Object)this$clueStatus).equals(other$clueStatus)) {
            return false;
        }
        Integer this$followedDate = this.getFollowedDate();
        Integer other$followedDate = other.getFollowedDate();
        if (this$followedDate == null ? other$followedDate != null : !((Object)this$followedDate).equals(other$followedDate)) {
            return false;
        }
        Integer this$leftFollowDate = this.getLeftFollowDate();
        Integer other$leftFollowDate = other.getLeftFollowDate();
        if (this$leftFollowDate == null ? other$leftFollowDate != null : !((Object)this$leftFollowDate).equals(other$leftFollowDate)) {
            return false;
        }
        Long this$marketId = this.getMarketId();
        Long other$marketId = other.getMarketId();
        if (this$marketId == null ? other$marketId != null : !((Object)this$marketId).equals(other$marketId)) {
            return false;
        }
        String this$marketName = this.getMarketName();
        String other$marketName = other.getMarketName();
        return !(this$marketName == null ? other$marketName != null : !this$marketName.equals(other$marketName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClueListResponseDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $relationTypeStr = this.getRelationTypeStr();
        result = result * 59 + ($relationTypeStr == null ? 43 : $relationTypeStr.hashCode());
        String $schoolName = this.getSchoolName();
        result = result * 59 + ($schoolName == null ? 43 : $schoolName.hashCode());
        String $channelTypeStr = this.getChannelTypeStr();
        result = result * 59 + ($channelTypeStr == null ? 43 : $channelTypeStr.hashCode());
        String $genderStr = this.getGenderStr();
        result = result * 59 + ($genderStr == null ? 43 : $genderStr.hashCode());
        String $subjectName = this.getSubjectName();
        result = result * 59 + ($subjectName == null ? 43 : $subjectName.hashCode());
        String $contactsRelationTypeStr = this.getContactsRelationTypeStr();
        result = result * 59 + ($contactsRelationTypeStr == null ? 43 : $contactsRelationTypeStr.hashCode());
        String $contacts2RelationTypeStr = this.getContacts2RelationTypeStr();
        result = result * 59 + ($contacts2RelationTypeStr == null ? 43 : $contacts2RelationTypeStr.hashCode());
        String $takeExamStr = this.getTakeExamStr();
        result = result * 59 + ($takeExamStr == null ? 43 : $takeExamStr.hashCode());
        String $hasIntermediaryStr = this.getHasIntermediaryStr();
        result = result * 59 + ($hasIntermediaryStr == null ? 43 : $hasIntermediaryStr.hashCode());
        String $studyPhaseStr = this.getStudyPhaseStr();
        result = result * 59 + ($studyPhaseStr == null ? 43 : $studyPhaseStr.hashCode());
        String $consultStatusStr = this.getConsultStatusStr();
        result = result * 59 + ($consultStatusStr == null ? 43 : $consultStatusStr.hashCode());
        String $canRecommendStr = this.getCanRecommendStr();
        result = result * 59 + ($canRecommendStr == null ? 43 : $canRecommendStr.hashCode());
        String $hasDepositeStr = this.getHasDepositeStr();
        result = result * 59 + ($hasDepositeStr == null ? 43 : $hasDepositeStr.hashCode());
        Long $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Long $tmkId = this.getTmkId();
        result = result * 59 + ($tmkId == null ? 43 : ((Object)$tmkId).hashCode());
        String $tmkName = this.getTmkName();
        result = result * 59 + ($tmkName == null ? 43 : $tmkName.hashCode());
        Long $tmkAllocateTime = this.getTmkAllocateTime();
        result = result * 59 + ($tmkAllocateTime == null ? 43 : ((Object)$tmkAllocateTime).hashCode());
        Long $adviserId = this.getAdviserId();
        result = result * 59 + ($adviserId == null ? 43 : ((Object)$adviserId).hashCode());
        String $adviserName = this.getAdviserName();
        result = result * 59 + ($adviserName == null ? 43 : $adviserName.hashCode());
        Long $adviserAllocateTime = this.getAdviserAllocateTime();
        result = result * 59 + ($adviserAllocateTime == null ? 43 : ((Object)$adviserAllocateTime).hashCode());
        Integer $clueStatus = this.getClueStatus();
        result = result * 59 + ($clueStatus == null ? 43 : ((Object)$clueStatus).hashCode());
        Integer $followedDate = this.getFollowedDate();
        result = result * 59 + ($followedDate == null ? 43 : ((Object)$followedDate).hashCode());
        Integer $leftFollowDate = this.getLeftFollowDate();
        result = result * 59 + ($leftFollowDate == null ? 43 : ((Object)$leftFollowDate).hashCode());
        Long $marketId = this.getMarketId();
        result = result * 59 + ($marketId == null ? 43 : ((Object)$marketId).hashCode());
        String $marketName = this.getMarketName();
        result = result * 59 + ($marketName == null ? 43 : $marketName.hashCode());
        return result;
    }
}

