/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.service.impl.clazz;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.wedo.common.constant.BizConf;
import com.baijia.wedo.common.enums.ClassStatus;
import com.baijia.wedo.common.enums.ClassStudentRecordType;
import com.baijia.wedo.common.enums.ClueStatus;
import com.baijia.wedo.common.enums.CourseType;
import com.baijia.wedo.common.enums.EnrollStatus;
import com.baijia.wedo.common.enums.GenderType;
import com.baijia.wedo.common.enums.JoinLessonType;
import com.baijia.wedo.common.enums.PayType;
import com.baijia.wedo.common.enums.StudentBrowseType;
import com.baijia.wedo.common.enums.StudentLessonStatus;
import com.baijia.wedo.common.enums.StudentStatus;
import com.baijia.wedo.common.enums.schedule.LessonStatus;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.model.IdAndNameAndMobileDto;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.common.model.IdAndNameRemarkDto;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.common.util.JacksonUtil;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.dal.edu.dao.clazz.ClassCourseDao;
import com.baijia.wedo.dal.edu.dao.clazz.ClassCourseDetailDao;
import com.baijia.wedo.dal.edu.dao.clazz.ClassDao;
import com.baijia.wedo.dal.edu.dao.clazz.ClassSchoolDao;
import com.baijia.wedo.dal.edu.dao.clazz.ClassStudentRecordDao;
import com.baijia.wedo.dal.edu.dao.clazz.ClassTeacherDefaultDao;
import com.baijia.wedo.dal.edu.dao.course.CourseDao;
import com.baijia.wedo.dal.edu.dao.course.CourseDetailDao;
import com.baijia.wedo.dal.edu.dao.course.CourseSubTypeDao;
import com.baijia.wedo.dal.edu.dao.impl.course.ClassCourse;
import com.baijia.wedo.dal.edu.po.Class;
import com.baijia.wedo.dal.edu.po.ClassCourseDetail;
import com.baijia.wedo.dal.edu.po.ClassSchool;
import com.baijia.wedo.dal.edu.po.ClassStudentRecord;
import com.baijia.wedo.dal.edu.po.ClassTeacherDefault;
import com.baijia.wedo.dal.edu.po.Course;
import com.baijia.wedo.dal.edu.po.CourseDetail;
import com.baijia.wedo.dal.edu.po.CourseSubType;
import com.baijia.wedo.dal.finance.dao.EnrollCourseDao;
import com.baijia.wedo.dal.finance.dao.EnrollRecordDao;
import com.baijia.wedo.dal.finance.dao.EnrollStudentLessonDao;
import com.baijia.wedo.dal.finance.po.EnrollCourse;
import com.baijia.wedo.dal.finance.po.EnrollRecord;
import com.baijia.wedo.dal.finance.po.EnrollStudentLesson;
import com.baijia.wedo.dal.schedule.dao.OrgClassLessonDao;
import com.baijia.wedo.dal.schedule.dao.OrgTeacherLessonDao;
import com.baijia.wedo.dal.schedule.po.OrgClassLesson;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.student.po.Student;
import com.baijia.wedo.dal.system.dao.RoomDetailDao;
import com.baijia.wedo.dal.system.dao.SchoolDao;
import com.baijia.wedo.dal.system.po.RoomDetail;
import com.baijia.wedo.dal.system.po.School;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.sal.dto.clazz.ClassAddDto;
import com.baijia.wedo.sal.dto.clazz.ClassCourseListDto;
import com.baijia.wedo.sal.dto.clazz.ClassListDto;
import com.baijia.wedo.sal.dto.clazz.ClassScheduleRuleDto;
import com.baijia.wedo.sal.dto.clazz.ClassStudentListDto;
import com.baijia.wedo.sal.dto.clazz.CourseSubTypeDto;
import com.baijia.wedo.sal.dto.clazz.EnrollStudentLessonResp;
import com.baijia.wedo.sal.dto.clazz.JoinClassCourseResp;
import com.baijia.wedo.sal.dto.clazz.JoinClassDto;
import com.baijia.wedo.sal.dto.clazz.JoinClassEnrollLessonReq;
import com.baijia.wedo.sal.dto.clazz.JoinClassReq;
import com.baijia.wedo.sal.dto.clazz.JoinClassResp;
import com.baijia.wedo.sal.dto.clazz.JoinClassSubTypeResp;
import com.baijia.wedo.sal.service.clazz.ClassService;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClassServiceImpl
implements ClassService {
    private static final Logger log = LoggerFactory.getLogger(ClassServiceImpl.class);
    @Autowired
    private ClassDao classDao;
    @Autowired
    private ClassCourseDao classCourseDao;
    @Autowired
    private ClassSchoolDao classSchoolDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private SchoolDao schoolDao;
    @Autowired
    private CourseDao courseDao;
    @Autowired
    private CourseSubTypeDao courseSubTypeDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private CourseDetailDao courseDetailDao;
    @Autowired
    private ClassTeacherDefaultDao classTeacherDefaultDao;
    @Autowired
    private RoomDetailDao roomDetailDao;
    @Autowired
    private EnrollStudentLessonDao enrollStudentLessonDao;
    @Autowired
    private EnrollRecordDao enrollRecordDao;
    @Autowired
    private EnrollCourseDao enrollCourseDao;
    @Autowired
    private ClassStudentRecordDao classStudentRecordDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private ClassCourseDetailDao classCourseDetailDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Override
    public List<ClassListDto> searchClass(String query, Integer classType, Collection<Integer> status, Date startTime, Date endTime, PageDto pageDto) {
        List classes = this.classDao.searchClassByParams(query, classType, status, startTime, endTime, pageDto);
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)classes)) {
            Set classIds = BaseUtils.getPropertiesList((Collection)classes, (String)"id");
            Map cache = this.enrollCourseDao.batchQueryClassStudentCount((Collection)classIds);
            Map<Long, Collection<IdAndNameDto>> schoolCache = this.getAndCacheClassSchool(classIds);
            Map courseCache = this.classCourseDao.getClassCourses((Collection)classIds);
            for (Class clazz : classes) {
                Long classId = clazz.getId();
                ClassListDto item = this.extractAndPackage(clazz);
                int count = 0;
                if (cache.containsKey(clazz.getId())) {
                    count = (Integer)cache.get(clazz.getId());
                }
                if (schoolCache.containsKey(clazz.getId())) {
                    item.setSchools(schoolCache.get(classId));
                } else {
                    item.setSchools(Collections.emptyList());
                }
                if (courseCache.containsKey(classId)) {
                    item.setCourses((Collection)courseCache.get(classId));
                } else {
                    item.setCourses(Collections.emptyList());
                }
                item.setStudentCount(count);
                result.add(item);
            }
        }
        return result;
    }

    Map<Long, Collection<IdAndNameDto>> getAndCacheClassSchool(Collection<Long> classIds) {
        return this.classSchoolDao.getClassesSchools(classIds);
    }

    ClassListDto extractAndPackage(Class clazz) {
        ClassListDto dto = ClassListDto.convertToDto(clazz);
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(ClassAddDto params) {
        if (params.getId() != null && params.getId() > NumberUtils.LONG_ZERO) {
            this.edit(params);
        } else {
            this.add(params);
        }
    }

    void add(ClassAddDto params) {
        List<? extends IdAndNameDto> courses = params.getCourses();
        int classType = this.getClassType(courses);
        Class clazz = params.convertToPo();
        clazz.setClassType(classType);
        this.classDao.save((Object)clazz, new String[0]);
        this.saveClassSchool(clazz.getId(), params.getSchools());
        this.saveClassCourse(clazz.getId(), params.getCourses());
        this.saveClassCourseDetail(clazz.getId(), params.getCourses());
    }

    int getClassType(List<? extends IdAndNameDto> courses) {
        int classType = CourseType.ONEvOne.getType();
        Set courseIds = BaseUtils.getPropertiesList(courses, (String)"id");
        List classCourses = this.courseDao.getByIds((Collection)courseIds, new String[0]);
        if (courses.size() == NumberUtils.INTEGER_ONE.intValue()) {
            classType = ((Course)classCourses.get(0)).getCourseType();
        } else {
            Set courseTypes = BaseUtils.getPropertiesList((Collection)classCourses, (String)"courseType");
            if (courseTypes.contains(CourseType.ONEvOne.getType())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u4e2d\u4e0d\u80fd\u624b\u52a8\u6dfb\u52a01v1\u7684\u8bfe\u7a0b");
            }
            if (courseTypes.contains(CourseType.ONEvN.getType())) {
                classType = CourseType.ONEvN.getType();
            } else if (courseTypes.contains(CourseType.ONEvG.getType())) {
                classType = CourseType.ONEvG.getType();
            } else {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u652f\u6301\u7684\u8bfe\u7a0b\u7c7b\u578b");
            }
        }
        return classType;
    }

    void delClassCourseDetail(Long classId) {
        HashMap delCondition = Maps.newHashMap();
        delCondition.put("classId", classId);
        this.classCourseDetailDao.delByCondition((Map)delCondition);
    }

    void saveClassCourseDetail(Long classId, List<? extends IdAndNameDto> courses) {
        if (CollectionUtils.isNotEmpty(courses)) {
            ArrayList classCourseDetails = Lists.newArrayList();
            Set courseIds = BaseUtils.getPropertiesList(courses, (String)"id");
            Map resultMap = this.courseDetailDao.getCourseDetailByCourseId((Collection)courseIds);
            if (!resultMap.isEmpty()) {
                ClassCourseDetail classCourseDetail = null;
                for (IdAndNameDto idAndNameDto : courses) {
                    Long courseId = idAndNameDto.getId();
                    String courseName = idAndNameDto.getName();
                    List details = (List)resultMap.get(courseId);
                    if (!CollectionUtils.isNotEmpty((Collection)details)) continue;
                    for (CourseDetail detail : details) {
                        if (detail.getCourseType() == CourseType.ONEvOne.getType()) {
                            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65b0\u589e\u73ed\u7ea7\u4e2d\u4e0d\u80fd\u6dfb\u52a01v1\u7684\u8bfe\u7a0b");
                        }
                        for (int index = 1; index <= detail.getAmount(); ++index) {
                            classCourseDetail = new ClassCourseDetail();
                            classCourseDetail.setClassId(classId);
                            classCourseDetail.setCourseId(courseId);
                            classCourseDetail.setCourseName(courseName);
                            classCourseDetail.setNumber(index);
                            classCourseDetail.setLessonId(NumberUtils.LONG_ZERO);
                            classCourseDetail.setLessonStatus(LessonStatus.UN_SCHEDULE.getStatus());
                            classCourseDetail.setSubTypeId(detail.getSubTypeId());
                            classCourseDetail.setSubTypeName(detail.getSubTypeName());
                            classCourseDetails.add(classCourseDetail);
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)classCourseDetails)) {
                this.classCourseDetailDao.saveAll((List)classCourseDetails, new String[0]);
            }
        }
    }

    void saveClassSchool(Long classId, List<? extends IdAndNameDto> schools) {
        if (CollectionUtils.isNotEmpty(schools)) {
            ArrayList classSchools = Lists.newArrayList();
            ClassSchool classSchool = null;
            for (IdAndNameDto idAndNameDto : schools) {
                classSchool = new ClassSchool();
                classSchool.setClassId(classId);
                classSchool.setSchoolId(idAndNameDto.getId());
                classSchool.setSchoolName(idAndNameDto.getName());
                classSchools.add(classSchool);
            }
            this.classSchoolDao.saveAll((List)classSchools, new String[0]);
        }
    }

    void saveClassCourse(Long classId, List<? extends IdAndNameDto> courses) {
        if (CollectionUtils.isNotEmpty(courses)) {
            ArrayList classCourses = Lists.newArrayList();
            ClassCourse classCourse = null;
            for (IdAndNameDto idAndNameDto : courses) {
                classCourse = new ClassCourse();
                classCourse.setClassId(classId);
                classCourse.setCourseId(idAndNameDto.getId());
                classCourse.setCourseName(idAndNameDto.getName());
                classCourses.add(classCourse);
            }
            this.classCourseDao.saveAll((List)classCourses, new String[0]);
        }
    }

    void edit(ClassAddDto params) {
        Long classId = params.getId();
        Class clazz = (Class)this.classDao.getById((Serializable)params.getId(), new String[0]);
        if (clazz != null) {
            this.editBefore(clazz, params);
            clazz.setClassType(params.getClassType());
            clazz.setCountLimit(params.getCountLimit());
            clazz.setName(params.getName());
            clazz.setRemark(params.getRemark());
            clazz.setStartTime(params.getStartTime() == null ? null : new Date(params.getStartTime()));
            clazz.setEndTime(params.getEndTime() == null ? null : new Date(params.getEndTime()));
            clazz.setUpdateTime(new Date());
            this.classDao.update((Object)clazz, new String[]{"classType", "countLimit", "name", "remark", "startTime", "endTime", "updateTime"});
            this.delClassSchool(classId, params.getSchools());
            this.delClassCourse(classId, params.getCourses());
            this.saveClassSchool(clazz.getId(), params.getSchools());
            this.saveClassCourse(clazz.getId(), params.getCourses());
            this.delClassCourseDetail(classId);
            this.saveClassCourseDetail(classId, params.getCourses());
        }
    }

    void editBefore(Class clazz, ClassAddDto params) {
        int status = clazz.getStatus();
        if (clazz.getClassType() == CourseType.ONEvOne.getType()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u578b\u4e3a1v1\u7684\u73ed\u7ea7\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        switch (ClassStatus.get((int)status)) {
            case UN_SCHEDULE: {
                int classStudentCount = this.enrollStudentLessonDao.getStudentCountByClassId(clazz.getId(), null);
                if (classStudentCount <= 0) break;
                this.codeAndClassTypeAndCourseCheck(clazz, params);
                break;
            }
            case READY_SCHEDULE: {
                this.codeAndClassTypeAndCourseCheck(clazz, params);
                break;
            }
            case SCHDULEING: {
                this.codeAndClassTypeAndCourseCheck(clazz, params);
                break;
            }
            case FINISHED: {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u7ed3\u8bfe\u7684\u73ed\u7ea7\u4e0d\u5141\u8bb8\u4fee\u6539\u4efb\u4f55\u4fe1\u606f");
            }
            default: {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u8bc6\u522b\u7684\u73ed\u7ea7\u72b6\u6001");
            }
        }
    }

    void editPropCheck(Class clazz, ClassAddDto params) {
    }

    void codeAndClassTypeAndCourseCheck(Class clazz, ClassAddDto params) {
        if (clazz.getClassType() != params.getClassType()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u7533\u8bf7\u6392\u8bfe\u3001\u6392\u8bfe\u4e2d\u6216\u8005\u6709\u5b66\u5458\u8fdb\u5165\u7684\u73ed\u7ea7\u4e0d\u80fd\u4fee\u6539\u73ed\u578b");
        }
        if (CollectionUtils.isNotEmpty(params.getCourses())) {
            List<? extends IdAndNameDto> newCourses = params.getCourses();
            List oldCourses = this.classCourseDao.getClassCourseByClassId(clazz.getId());
            if (CollectionUtils.isNotEmpty((Collection)oldCourses) && oldCourses.size() == newCourses.size()) {
                Set oldCourseIds = BaseUtils.getPropertiesList((Collection)oldCourses, (String)"id");
                Set newCourseIds = BaseUtils.getPropertiesList(newCourses, (String)"id");
                oldCourseIds.addAll(newCourseIds);
                if (oldCourseIds.size() != newCourseIds.size()) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u7533\u8bf7\u6392\u8bfe\u3001\u6392\u8bfe\u4e2d\u6216\u8005\u6709\u5b66\u5458\u8fdb\u5165\u7684\u73ed\u7ea7\u4e0d\u80fd\u4fee\u6539\u73ed\u7ea7\u8bfe\u7a0b");
                }
            } else if (clazz.getCountLimit() != params.getCountLimit()) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u7533\u8bf7\u6392\u8bfe\u3001\u6392\u8bfe\u4e2d\u6216\u8005\u6709\u5b66\u5458\u8fdb\u5165\u7684\u73ed\u7ea7\u4e0d\u80fd\u4fee\u6539\u73ed\u7ea7\u4eba\u6570\u9650\u5236");
            }
        }
    }

    void delClassSchool(Long classId, List<? extends IdAndNameDto> schools) {
        if (CollectionUtils.isNotEmpty(schools)) {
            HashMap params = Maps.newHashMap();
            params.put("classId", classId);
            this.classSchoolDao.delByCondition((Map)params);
        }
    }

    void delClassCourse(Long classId, List<? extends IdAndNameDto> courses) {
        if (CollectionUtils.isNotEmpty(courses)) {
            HashMap params = Maps.newHashMap();
            params.put("classId", classId);
            this.classCourseDao.delByCondition((Map)params);
        }
    }

    @Override
    public JoinClassResp joinClass(JoinClassDto params) throws JsonParseException, JsonMappingException, IOException {
        IdAndNameDto student = params.getStudent();
        Class clazz = (Class)this.classDao.getById((Serializable)params.getId(), new String[0]);
        this.joinBefore(clazz, student);
        JoinClassResp result = this.doJoin(clazz, student);
        return result;
    }

    void joinBefore(Class clazz, IdAndNameDto student) {
        if (clazz == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED, "\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        if (clazz.getClassType() == CourseType.ONEvOne.getType()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "1v1\u7684\u73ed\u7ea7\u4e0d\u80fd\u6dfb\u52a0\u5b66\u5458");
        }
        Long classId = clazz.getId();
        int enrollStudentCount = this.enrollStudentLessonDao.getStudentCountByClassId(classId, (Collection)Sets.newHashSet((Object[])new Integer[]{JoinLessonType.NORMAL.getStatus(), JoinLessonType.INSERT.getStatus()}));
        if (enrollStudentCount + 1 > clazz.getCountLimit()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u5df2\u6709\u4eba\u6570\u3010" + enrollStudentCount + "\u3011,\u5373\u5c06\u8fdb\u73ed\u4eba\u6570\u3010" + 1 + "\u3011\uff0c\u8d85\u8fc7\u73ed\u7ea7\u9650\u5236\u4eba\u6570\u3010" + clazz.getCountLimit() + "\u3011");
        }
        int consumLessonCount = this.classCourseDetailDao.getClassDetailLessonCount(classId, null, Integer.valueOf(LessonStatus.CONSUMED.getStatus()));
        if (consumLessonCount > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u5df2\u8bfe\u6d88\u3010" + consumLessonCount + "\u3011\u8282\u8bfe\uff0c\u4e0d\u80fd\u6b63\u5e38\u8fdb\u73ed\uff0c\u8bf7\u4f7f\u7528\u63d2\u73ed\u529f\u80fd");
        }
    }

    Map<Long, Map<Long, List<EnrollStudentLesson>>> getAndCacheEnrollStudentLesson(Long studentId, Collection<Long> courseIds) {
        HashMap resultCache = Maps.newHashMap();
        List records = this.enrollRecordDao.searchEnrollRecordByStudentIds((Collection)Sets.newHashSet((Object[])new Long[]{studentId}));
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            Set enrollIds = BaseUtils.getPropertiesList((Collection)records, (String)"id");
            List enrollCourses = this.enrollCourseDao.searchEnrollCourseByCourseId((Collection)enrollIds, courseIds, BizConf.FALSE);
            if (CollectionUtils.isNotEmpty((Collection)enrollCourses)) {
                List enrollLessons = this.enrollStudentLessonDao.getStudentLessonsByParams((Collection)enrollIds, courseIds, BizConf.FALSE);
                if (CollectionUtils.isNotEmpty((Collection)enrollLessons)) {
                    for (EnrollStudentLesson enrollLesson : enrollLessons) {
                        ArrayList subTypeList;
                        Map<Long, ArrayList> subTypeCache;
                        Long courseId = enrollLesson.getCourseId();
                        Long subTypeId = enrollLesson.getSubTypeId();
                        if (resultCache.containsKey(courseId)) {
                            subTypeCache = (Map)resultCache.get(courseId);
                            if (subTypeCache.containsKey(subTypeId)) {
                                ((List)subTypeCache.get(subTypeId)).add(enrollLesson);
                            } else {
                                subTypeList = Lists.newArrayList();
                                subTypeList.add(enrollLesson);
                                subTypeCache.put(subTypeId, subTypeList);
                            }
                            resultCache.put(courseId, subTypeCache);
                            continue;
                        }
                        subTypeCache = Maps.newHashMap();
                        subTypeList = Lists.newArrayList((Object[])new EnrollStudentLesson[]{enrollLesson});
                        subTypeCache.put(subTypeId, subTypeList);
                        resultCache.put(courseId, subTypeCache);
                    }
                }
            } else {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u751f\u6ca1\u6709\u5df2\u62a5\u540d\u672a\u9501\u5b9a\u7684\u8bfe\u7a0b\u53ef\u4ee5\u8fdb\u5165\u73ed\u7ea7");
            }
        }
        return resultCache;
    }

    Map<Long, OrgClassLesson> getAndCacheClassCourseDetailLesson(Collection<Long> lessonIds) {
        List lessons = this.orgClassLessonDao.getByIds(lessonIds, new String[0]);
        Map cache = Maps.newHashMap();
        cache = BaseUtils.listToMap((List)lessons, (String)"id");
        return cache;
    }

    JoinClassResp doJoin(Class clazz, IdAndNameDto student) throws JsonParseException, JsonMappingException, IOException {
        Long classId = clazz.getId();
        JoinClassResp result = new JoinClassResp();
        result.setClazz(this.getClazz(clazz));
        result.setStudent(this.getStudent(student.getId()));
        ArrayList courseResps = Lists.newArrayList();
        ArrayList classCourseResps = Lists.newArrayList();
        List classCourses = this.classCourseDao.getClassCourseByClassId(classId);
        Set courseIds = BaseUtils.getPropertiesList((Collection)classCourses, (String)"courseId");
        Map<Long, Map<Long, Integer>> classCourseCache = this.getAndCacheCourseDetail(courseIds);
        Map<Long, Map<Long, List<EnrollStudentLesson>>> enrollCourseCache = this.getAndCacheEnrollStudentLesson(student.getId(), courseIds);
        if (!enrollCourseCache.isEmpty() && !classCourseCache.isEmpty() && classCourseCache.keySet().size() > 0 && enrollCourseCache.keySet().size() > 0 && classCourseCache.keySet().containsAll(enrollCourseCache.keySet())) {
            Date now = new Date();
            for (ClassCourse classCourse : classCourses) {
                Long courseId = classCourse.getCourseId();
                JoinClassCourseResp classCourseResp = null;
                List classCourseDetails = this.classCourseDetailDao.getClassCourseDetailByClassId(classId, courseId);
                if (!CollectionUtils.isNotEmpty((Collection)classCourseDetails)) continue;
                Set lessonIds = BaseUtils.getPropertiesList((Collection)classCourseDetails, (String)"lessonId");
                Map<Long, OrgClassLesson> lessonCache = this.getAndCacheClassCourseDetailLesson(lessonIds);
                classCourseResp = new JoinClassCourseResp();
                classCourseResp.setCourseId(courseId);
                classCourseResp.setCourseName(classCourse.getCourseName());
                ArrayList detailLessons = Lists.newArrayList();
                EnrollStudentLessonResp detailLesson = null;
                for (ClassCourseDetail clssCourseDetail : classCourseDetails) {
                    Long lessonId = clssCourseDetail.getLessonId();
                    detailLesson = new EnrollStudentLessonResp();
                    BeanUtils.copyProperties((Object)clssCourseDetail, (Object)detailLesson);
                    detailLesson.setIndex(clssCourseDetail.getNumber());
                    int lessonStatus = LessonStatus.UN_SCHEDULE.getStatus();
                    if (lessonId != null && lessonId > 0L && lessonCache.containsKey(lessonId) && lessonCache.containsKey(lessonId)) {
                        OrgClassLesson classLesson = lessonCache.get(lessonId);
                        Date startTime = classLesson.getStartTime();
                        Date endTime = classLesson.getEndTime();
                        if (now.after(endTime)) {
                            lessonStatus = LessonStatus.FINISHED.getStatus();
                        } else if (now.before(startTime)) {
                            lessonStatus = LessonStatus.UN_START.getStatus();
                        } else if (now.after(startTime) && now.before(endTime)) {
                            lessonStatus = LessonStatus.ONGOING.getStatus();
                        }
                    }
                    detailLesson.setLessonStatus(lessonStatus);
                    detailLessons.add(detailLesson);
                }
                classCourseResp.setLessons(detailLessons);
                classCourseResp.setSubTypes(Lists.newArrayList());
                classCourseResps.add(classCourseResp);
            }
            JoinClassCourseResp courseResp = null;
            for (Long courseId : enrollCourseCache.keySet()) {
                courseResp = new JoinClassCourseResp();
                courseResp.setCourseId(courseId);
                Map<Long, List<EnrollStudentLesson>> subCache = enrollCourseCache.get(courseId);
                ArrayList subTypes = Lists.newArrayList();
                JoinClassSubTypeResp subTypeResp = null;
                for (Long subTypeId : subCache.keySet()) {
                    List<EnrollStudentLesson> lessons = subCache.get(subTypeId);
                    EnrollStudentLesson lesson = lessons.get(0);
                    if (StringUtils.isBlank((CharSequence)courseResp.getCourseName())) {
                        courseResp.setCourseName(lesson.getCourseName());
                    }
                    subTypeResp = new JoinClassSubTypeResp();
                    subTypeResp.setLeftLessons(lessons.size());
                    subTypeResp.setSubTypeId(lessons.get(0).getSubTypeId());
                    subTypeResp.setSubTypeName(lessons.get(0).getSubTypeName());
                    subTypes.add(subTypeResp);
                }
                courseResp.setLessons(Lists.newArrayList());
                courseResp.setSubTypes(subTypes);
                courseResps.add(courseResp);
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u62a5\u540d\u8bfe\u7a0b\u4e0e\u73ed\u7ea7\u8bfe\u7a0b\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u8fdb\u5165\u73ed\u7ea7");
        }
        result.setClassCourses(classCourseResps);
        result.setEnrollCoruses(courseResps);
        return result;
    }

    Map<Long, OrgClassLesson> getAndCacheLesson(Collection<Long> lessonIds) {
        List lessons = this.orgClassLessonDao.getByIds(lessonIds, new String[0]);
        Map cache = Maps.newHashMap();
        cache = BaseUtils.listToMap((List)lessons, (String)"id");
        return cache;
    }

    IdAndNameRemarkDto getClazz(Class clazz) {
        return new IdAndNameRemarkDto(clazz.getId(), clazz.getName(), clazz.getCode());
    }

    IdAndNameAndMobileDto getStudent(Long studentId) {
        Student student = (Student)this.studentDao.getById((Serializable)studentId, new String[]{"id", "name", "mobile"});
        IdAndNameAndMobileDto info = new IdAndNameAndMobileDto(student.getId(), student.getName(), student.getMobile());
        info.setGender(student.getGender());
        return info;
    }

    Map<Long, Map<Long, Integer>> getAndCacheCourseDetail(Set<Long> courseIds) {
        Map map = this.courseDetailDao.getCourseDetailByCourseId(courseIds);
        HashMap cache = Maps.newHashMap();
        if (!map.isEmpty()) {
            for (Long courseId : map.keySet()) {
                List details = (List)map.get(courseId);
                HashMap subCache = Maps.newHashMap();
                for (CourseDetail detail : details) {
                    subCache.put(detail.getSubTypeId(), detail.getAmount());
                }
                cache.put(courseId, subCache);
            }
        }
        return cache;
    }

    String sortCourseIds(Collection<Long> courseIds) {
        ArrayList ids = Lists.newArrayList(courseIds);
        Collections.sort(ids);
        return BaseUtils.listToStr((Collection)ids, (String)",");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void applySchdule(Long id) {
        Class clazz = (Class)this.classDao.getById((Serializable)id, new String[0]);
        Date now = new Date();
        if (clazz == null) return;
        if (clazz.getClassType() == CourseType.ONEvN.getType() || clazz.getClassType() == CourseType.ONEvG.getType()) {
            int count = this.enrollStudentLessonDao.getStudentCountByClassId(id, (Collection)Sets.newHashSet((Object[])new Integer[]{JoinLessonType.NORMAL.getStatus(), JoinLessonType.INSERT.getStatus()}));
            if (count < 3) throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u8bfe\u7533\u8bf7\u6392\u8bfe\u6761\u4ef6\uff1a\u73ed\u7ea7\u4e2d\u5b66\u5458\u4eba\u6570\u4e0d\u80fd\u5c11\u4e8e\u30103\u3011\u4eba");
            String code = this.generateClassNum(clazz.getClassType());
            clazz.setStatus(ClassStatus.READY_SCHEDULE.getStatus());
            clazz.setApplyScheduleTime(now);
            clazz.setUpdateTime(now);
            clazz.setCode(code);
            this.classDao.update((Object)clazz, new String[]{"status", "applyScheduleTime", "updateTime", "code"});
            return;
        } else {
            clazz.setStatus(ClassStatus.READY_SCHEDULE.getStatus());
            this.classDao.update((Object)clazz, new String[]{"status", "applyScheduleTime", "updateTime", "code"});
        }
    }

    String generateClassNum(int classType) {
        Date firstDayOfYear = BaseUtils.getStartOfYear();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String year = sdf.format(firstDayOfYear);
        Date now = new Date();
        int count = this.classDao.getClassIndex(classType, firstDayOfYear, now);
        String suffix = this.autoComplete(count + "");
        StringBuffer code = new StringBuffer(year);
        switch (CourseType.get((int)classType)) {
            case ONEvOne: {
                code.append(CourseType.ONEvOne.getLabel()).append(suffix);
                break;
            }
            case ONEvN: {
                code.append(CourseType.ONEvN.getLabel()).append(suffix);
                break;
            }
            case ONEvG: {
                code.append(CourseType.ONEvG.getLabel()).append(suffix);
                break;
            }
            default: {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u652f\u6301\u7684\u73ed\u578b");
            }
        }
        code.append(suffix);
        return code.toString();
    }

    String autoComplete(String suffix) {
        int finalLen = 4;
        int currLen = suffix.length();
        if (finalLen - currLen > 0) {
            for (int i = 0; i < finalLen - currLen; ++i) {
                suffix = "0" + suffix;
            }
        }
        return suffix;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delClass(Long id) {
        Class clazz = (Class)this.classDao.getById((Serializable)id, new String[0]);
        if (clazz != null) {
            int count = this.enrollStudentLessonDao.getStudentCountByClassId(id, null);
            if (count > 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u6709\u5b66\u5458\u62a5\u540d\u7684\u73ed\u7ea7\u4e0d\u80fd\u5220\u9664");
            }
            this.classDao.delById((Serializable)id);
            HashMap delCondition = Maps.newHashMap();
            delCondition.put("classId", id);
            this.classCourseDao.delByCondition((Map)delCondition);
            this.classSchoolDao.delByCondition((Map)delCondition);
            this.classCourseDetailDao.delByCondition((Map)delCondition);
        }
    }

    @Override
    public List<IdAndNameRemarkDto> fuzzyQuery(String className, Collection<Integer> status) {
        ArrayList result;
        block5: {
            List classes = this.classDao.fuzzyQuery(className, status);
            result = Lists.newArrayList();
            if (!CollectionUtils.isNotEmpty((Collection)classes)) break block5;
            IdAndNameRemarkDto item = null;
            if (CollectionUtils.isNotEmpty(status)) {
                Set classIds = BaseUtils.getPropertiesList((Collection)classes, (String)"id");
                Map cache = this.enrollCourseDao.batchQueryClassStudentCount((Collection)classIds);
                for (Class clazz : classes) {
                    long classId = clazz.getId();
                    if (clazz.getClassType() == CourseType.ONEvOne.getType()) {
                        int studentCount;
                        if (!cache.containsKey(classId) || (studentCount = ((Integer)cache.get(classId)).intValue()) == NumberUtils.INTEGER_ZERO) continue;
                        item = new IdAndNameRemarkDto(clazz.getId(), clazz.getName(), clazz.getCode());
                        result.add(item);
                        continue;
                    }
                    item = new IdAndNameRemarkDto(clazz.getId(), clazz.getName(), clazz.getCode());
                    result.add(item);
                }
            } else {
                for (Class clazz : classes) {
                    item = new IdAndNameRemarkDto(clazz.getId(), clazz.getName(), clazz.getCode());
                    result.add(item);
                }
            }
        }
        return result;
    }

    @Override
    public List<ClassStudentListDto> getClassStudentList(Long classId, String query, PageDto pageDto) {
        ArrayList result = Lists.newArrayList();
        List enrollCourses = this.enrollCourseDao.getEnrollCourseByClassId(classId, BizConf.TRUE.intValue(), BizConf.FALSE);
        if (CollectionUtils.isNotEmpty((Collection)enrollCourses)) {
            Set enrollIds = BaseUtils.getPropertiesList((Collection)enrollCourses, (String)"enrollId");
            List records = this.enrollRecordDao.getByIds((Collection)enrollIds, new String[0]);
            HashSet studentIds = Sets.newHashSet();
            for (EnrollRecord record : records) {
                if (record.getPayType() == PayType.FINAL_PAY.getType() || record.getStatus() == EnrollStatus.INVALID.getStatus()) continue;
                studentIds.add(record.getStudentId());
            }
            if (CollectionUtils.isNotEmpty((Collection)studentIds)) {
                List students = this.studentDao.getByIds((Collection)studentIds, new String[0]);
                Map cache = BaseUtils.listToMap((List)students, (String)"id");
                Set schoolIds = BaseUtils.getPropertiesList((Collection)students, (String)"schoolId");
                List schools = this.schoolDao.getByIds((Collection)schoolIds, new String[]{"id", "name"});
                Map schoolCache = BaseUtils.listToMap((List)schools, (String)"id");
                for (Long studentId : studentIds) {
                    ClassStudentListDto dto = this.extractAndPackageStudent(studentId, cache, schoolCache);
                    result.add(dto);
                }
            }
        }
        return result;
    }

    int getClassStudentCount(Long classId) {
        int count = 0;
        List enrollCourses = this.enrollCourseDao.getEnrollCourseByClassId(classId, BizConf.TRUE.intValue(), BizConf.FALSE);
        if (CollectionUtils.isNotEmpty((Collection)enrollCourses)) {
            Set enrollIds = BaseUtils.getPropertiesList((Collection)enrollCourses, (String)"enrollId");
            List records = this.enrollRecordDao.getByIds((Collection)enrollIds, new String[0]);
            HashSet studentIds = Sets.newHashSet();
            for (EnrollRecord record : records) {
                if (record.getPayType() == PayType.FINAL_PAY.getType() || record.getStatus() == EnrollStatus.INVALID.getStatus()) continue;
                studentIds.add(record.getStudentId());
            }
            count = studentIds.size();
        }
        return count;
    }

    ClassStudentListDto extractAndPackageStudent(Long studentId, Map<Long, Student> cache, Map<Long, School> schoolCache) {
        ClassStudentListDto dto = null;
        if (cache.containsKey(studentId)) {
            dto = new ClassStudentListDto();
            Student student = cache.get(studentId);
            int gender = student.getGender();
            if (GenderType.contains((int)gender)) {
                dto.setGender(GenderType.get((int)gender).getLabel());
            } else {
                dto.setGender("\u672a\u77e5");
            }
            dto.setGrade(student.getGrade());
            dto.setId(student.getId());
            dto.setMobile(student.getMobile());
            dto.setName(student.getName());
            dto.setPurposerCountry(student.getPurposerCountry());
            Long schoolId = student.getSchoolId();
            if (schoolCache.containsKey(schoolId)) {
                dto.setSchoolName(schoolCache.get(schoolId).getName());
            } else {
                dto.setSchoolName("");
            }
            dto.setStudySchool(student.getStudySchool());
        }
        return dto;
    }

    @Override
    public ClassScheduleRuleDto getClassTeacherScheduleRule(Long classId) throws JsonParseException, JsonMappingException, IOException {
        Class clazz = (Class)this.classDao.getById((Serializable)classId, new String[0]);
        ClassScheduleRuleDto result = null;
        if (clazz != null) {
            ArrayList dtos = Lists.newArrayList();
            ClassCourseListDto dto = null;
            List defaultTeachers = this.classTeacherDefaultDao.getClassTeacherDefaultList(classId);
            if (CollectionUtils.isNotEmpty((Collection)defaultTeachers)) {
                result = new ClassScheduleRuleDto();
                result.setRoomId(clazz.getDefaultRoomId());
                RoomDetail detail = (RoomDetail)this.roomDetailDao.getById((Serializable)clazz.getDefaultRoomId(), new String[0]);
                result.setSchoolId(detail.getSchoolId());
                result.setRemark(clazz.getRemark());
                for (ClassTeacherDefault defaultTeacher : defaultTeachers) {
                    Long courseId = defaultTeacher.getCourseId();
                    dto = new ClassCourseListDto();
                    dto.setId(defaultTeacher.getId());
                    dto.setCourseId(courseId);
                    dto.setCourseName(defaultTeacher.getCourseName());
                    String content = defaultTeacher.getContent();
                    List items = Lists.newArrayList();
                    if (StringUtils.isNotBlank((CharSequence)content)) {
                        items = JacksonUtil.str2List((String)content, CourseSubTypeDto.class);
                    }
                    dto.setItems(items);
                    dtos.add(dto);
                }
                result.setDefaultTeachers(dtos);
            } else {
                List courses = this.classCourseDao.getClassCourseByClassId(classId);
                ArrayList subList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)courses)) {
                    result = new ClassScheduleRuleDto();
                    result.setRoomId(clazz.getDefaultRoomId());
                    Long defaultRoomId = clazz.getDefaultRoomId();
                    if (defaultRoomId != null) {
                        RoomDetail detail = (RoomDetail)this.roomDetailDao.getById((Serializable)clazz.getDefaultRoomId(), new String[0]);
                        result.setSchoolId(detail.getSchoolId());
                    } else {
                        result.setSchoolId(null);
                    }
                    Set courseIds = BaseUtils.getPropertiesList((Collection)courses, (String)"courseId");
                    Map<Long, Course> courseCache = this.getAndCacheCourse(courseIds);
                    Map detailCache = this.courseDetailDao.getCourseDetailByCourseId((Collection)courseIds);
                    for (ClassCourse classCourse : courses) {
                        Long courseId = classCourse.getCourseId();
                        if (courseCache.containsKey(courseId) && detailCache.containsKey(courseId)) {
                            dto = new ClassCourseListDto();
                            Course course = courseCache.get(courseId);
                            dto.setCourseId(courseId);
                            dto.setCourseName(course.getName());
                        }
                        ArrayList items = Lists.newArrayList();
                        List details = (List)detailCache.get(courseId);
                        for (CourseDetail dt : details) {
                            CourseSubTypeDto item = new CourseSubTypeDto();
                            item.setSubTypeId(dt.getSubTypeId());
                            item.setSubTypeName(dt.getSubTypeName());
                            item.setTeacherId(null);
                            items.add(item);
                        }
                        dto.setItems(items);
                        subList.add(dto);
                    }
                    result.setDefaultTeachers(subList);
                }
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED, "\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        result.setClassName(clazz.getName());
        result.setClassId(clazz.getId());
        return result;
    }

    CourseSubTypeDto getSubTypeDto(Long subTypeId, Long teacherId, Map<Long, CourseSubType> subTypeCache) {
        if (subTypeCache.containsKey(subTypeId)) {
            CourseSubTypeDto item = new CourseSubTypeDto();
            CourseSubType subType = subTypeCache.get(subTypeId);
            item.setSubTypeId(subType.getId());
            item.setSubTypeName(subType.getName());
            item.setTeacherId(teacherId);
            return item;
        }
        return null;
    }

    Map<Long, Course> getAndCacheCourse(Collection<Long> courseIds) {
        List courses = this.courseDao.getByIds(courseIds, new String[]{"id", "name"});
        Map cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)courses)) {
            cache = BaseUtils.listToMap((List)courses, (String)"id");
        }
        return cache;
    }

    Map<Long, CourseSubType> getAndCacheSubType(Collection<Long> subTypeIds) {
        List subTypes = this.courseSubTypeDao.getByIds(subTypeIds, new String[]{"id", "name"});
        Map cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)subTypes)) {
            cache = BaseUtils.listToMap((List)subTypes, (String)"id");
        }
        return cache;
    }

    Map<Long, User> getAndCacheTeacher(Collection<Long> teacherIds) {
        List users = this.userDao.getByIds(teacherIds, new String[]{"id", "name"});
        Map cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            cache = BaseUtils.listToMap((List)users, (String)"id");
        }
        return cache;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void quitClass(Long studentId, Long classId) {
        List result;
        log.info("quitClass.studentId:{}, classId:{}", (Object)studentId, (Object)classId);
        Map studentCountCache = this.enrollCourseDao.batchQueryClassStudentCount((Collection)Sets.newHashSet((Object[])new Long[]{classId}));
        int studentCount = 0;
        if (studentCountCache.containsKey(classId) && (Integer)studentCountCache.get(classId) > 0) {
            studentCount = (Integer)studentCountCache.get(classId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = this.enrollRecordDao.getStudentLockedEnrollCourse(studentId, classId)))) {
            List studentLessons = this.enrollStudentLessonDao.getClassStudentLesson(studentId, classId, (Collection)Sets.newHashSet((Object[])new Integer[]{StudentLessonStatus.LOCK.getStatus(), StudentLessonStatus.UN_LOCK.getStatus()}));
            log.info("quit class lessons:{}", (Object)studentLessons);
            int quitLessons = this.enrollStudentLessonDao.quitClass(classId, studentId);
            if (quitLessons != studentLessons.size()) {
                log.warn("expected quit expected lesson:{}, actually lesson:{}", (Object)quitLessons, (Object)studentLessons.size());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9884\u671f\u9000\u51fa\u8bfe\u6b21\u3010" + studentLessons.size() + "\u3011\uff0c\u5b9e\u9645\u53ea\u6709\u3010" + quitLessons + "\u3011\u8bfe\u6b21\u53ef\u9000\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458:15110248515");
            }
            Set enrollIds = BaseUtils.getPropertiesList((Collection)studentLessons, (String)"enrollId");
            List courses = this.enrollCourseDao.getEnrollCourseByPagination((Collection)enrollIds, null);
            if (CollectionUtils.isNotEmpty((Collection)courses)) {
                Set enrollCourseIds = BaseUtils.getPropertiesList((Collection)courses, (String)"id");
                HashMap params = Maps.newHashMap();
                params.put("id", enrollCourseIds);
                params.put("isLock", BizConf.FALSE);
                params.put("lockClassId", Integer.valueOf(NumberUtils.INTEGER_ZERO));
                this.enrollCourseDao.update((Map)params, new String[]{"isLock", "lockClassId"});
                this.saveQuitClassRecord(courses, studentId);
            }
            if (studentCount == NumberUtils.INTEGER_ONE) {
                this.quitAfter(studentLessons);
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u8fd8\u672a\u8fdb\u5165\u73ed\u7ea7\uff0c\u4e0d\u80fd\u9000\u73ed");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void quitClass(Long studentId, Long classId, Long enrollId, Long courseId) {
        List result;
        log.info("quitClass.studentId:{}, classId:{}, enrollId:{}, courseId:{}", new Object[]{studentId, classId, enrollId, courseId});
        Map studentCountCache = this.enrollCourseDao.batchQueryClassStudentCount((Collection)Sets.newHashSet((Object[])new Long[]{classId}));
        int studentCount = 0;
        if (studentCountCache.containsKey(classId) && (Integer)studentCountCache.get(classId) > 0) {
            studentCount = (Integer)studentCountCache.get(classId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = this.enrollRecordDao.getStudentLockedEnrollCourse(studentId, classId)))) {
            List studentLessons = this.enrollStudentLessonDao.getClassStudentLesson(studentId, classId, enrollId, courseId, (Collection)Sets.newHashSet((Object[])new Integer[]{StudentLessonStatus.LOCK.getStatus(), StudentLessonStatus.UN_LOCK.getStatus()}));
            if (CollectionUtils.isNotEmpty((Collection)studentLessons)) {
                log.info("quit class lessons:{}", (Object)studentLessons);
                int quitLessons = this.enrollStudentLessonDao.quitClass(classId, studentId);
                if (quitLessons != studentLessons.size()) {
                    log.warn("expected quit expected lesson:{}, actually lesson:{}", (Object)quitLessons, (Object)studentLessons.size());
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9884\u671f\u9000\u51fa\u8bfe\u6b21\u3010" + studentLessons.size() + "\u3011\uff0c\u5b9e\u9645\u53ea\u6709\u3010" + quitLessons + "\u3011\u8bfe\u6b21\u53ef\u9000\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458:15110248515");
                }
                Set enrollIds = BaseUtils.getPropertiesList((Collection)studentLessons, (String)"enrollId");
                List courses = this.enrollCourseDao.getEnrollCourseByPagination((Collection)enrollIds, null);
                if (CollectionUtils.isNotEmpty((Collection)courses)) {
                    Set enrollCourseIds = BaseUtils.getPropertiesList((Collection)courses, (String)"id");
                    HashMap params = Maps.newHashMap();
                    params.put("id", enrollCourseIds);
                    params.put("isLock", BizConf.FALSE);
                    params.put("lockClassId", Integer.valueOf(NumberUtils.INTEGER_ZERO));
                    this.enrollCourseDao.update((Map)params, new String[]{"isLock", "lockClassId"});
                    this.saveQuitClassRecord(courses, studentId);
                }
                if (studentCount == NumberUtils.INTEGER_ONE) {
                    this.quitAfter(studentLessons);
                }
            } else {
                Set enrollCourseIds = BaseUtils.getPropertiesList((Collection)result, (String)"enrollCourseId");
                List courses = this.enrollCourseDao.getByIds((Collection)enrollCourseIds, new String[0]);
                HashMap params = Maps.newHashMap();
                params.put("id", enrollCourseIds);
                params.put("isLock", BizConf.FALSE);
                params.put("lockClassId", Integer.valueOf(NumberUtils.INTEGER_ZERO));
                this.enrollCourseDao.update((Map)params, new String[]{"isLock", "lockClassId"});
                this.saveQuitClassRecord(courses, studentId);
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u8fd8\u672a\u8fdb\u5165\u73ed\u7ea7\uff0c\u4e0d\u80fd\u9000\u73ed");
        }
    }

    void quitAfter(List<EnrollStudentLesson> studentLessons) {
        Set lessonIds;
        List details;
        Set classCourseDetailIds = BaseUtils.getPropertiesList(studentLessons, (String)"classCourseDetailId");
        if (CollectionUtils.isNotEmpty((Collection)classCourseDetailIds) && CollectionUtils.isNotEmpty((Collection)(details = this.classCourseDetailDao.getByIds((Collection)classCourseDetailIds, new String[0]))) && CollectionUtils.isNotEmpty((Collection)(lessonIds = BaseUtils.getPropertiesList((Collection)details, (String)"lessonId")))) {
            this.orgClassLessonDao.delByIds((Collection)lessonIds);
            HashMap delCondition = Maps.newHashMap();
            delCondition.put("lessonId", lessonIds);
            this.orgTeacherLessonDao.delByCondition((Map)delCondition);
            this.classCourseDetailDao.clearRelateFromLesson(details);
        }
    }

    @Override
    public ClassListDto getClassDetail(Long id) {
        Class clazz = (Class)this.classDao.getById((Serializable)id, new String[0]);
        if (clazz != null) {
            ClassListDto result = ClassListDto.convertToDto(clazz);
            List<IdAndNameDto> courses = this.getClassCourse(id);
            Map cache = this.classSchoolDao.getClassesSchools((Collection)Sets.newHashSet((Object[])new Long[]{id}));
            if (cache.containsKey(id)) {
                result.setSchools((Collection)cache.get(id));
            } else {
                result.setSchools(Collections.emptyList());
            }
            int studentCount = this.getClassStudentCount(id);
            result.setStudentCount(studentCount);
            result.setCourses(courses);
            return result;
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED, "\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
    }

    List<IdAndNameDto> getClassCourse(Long classId) {
        List classCourses = this.classCourseDao.getClassCourseByClassId(classId);
        ArrayList courses = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)classCourses)) {
            for (ClassCourse course : classCourses) {
                IdAndNameDto item = new IdAndNameDto(course.getCourseId(), course.getCourseName());
                courses.add(item);
            }
        }
        return courses;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveScheduleRule(ClassScheduleRuleDto params) {
        Long classId = params.getClassId();
        Class clazz = (Class)this.classDao.getById((Serializable)classId, new String[0]);
        if (clazz != null) {
            clazz.setUpdateTime(new Date());
            clazz.setDefaultRoomId(params.getRoomId());
            this.classDao.update((Object)clazz, new String[]{"defaultRoomId", "updateTime"});
            List<ClassCourseListDto> details = params.getDefaultTeachers();
            if (CollectionUtils.isNotEmpty(details)) {
                this.delAndSave(classId, details);
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
    }

    void delAndSave(Long classId, List<ClassCourseListDto> details) {
        HashMap params = Maps.newHashMap();
        params.put("classId", classId);
        this.classTeacherDefaultDao.delByCondition((Map)params);
        ArrayList teacherDefaults = Lists.newArrayList();
        ClassTeacherDefault teacherDefault = null;
        Date now = new Date();
        for (ClassCourseListDto detail : details) {
            teacherDefault = new ClassTeacherDefault();
            teacherDefault.setClassId(classId);
            teacherDefault.setCourseId(detail.getCourseId());
            teacherDefault.setCourseName(detail.getCourseName());
            teacherDefault.setCreateTime(now);
            teacherDefault.setUpdateTime(now);
            List<CourseSubTypeDto> items = detail.getItems();
            if (CollectionUtils.isNotEmpty(items)) {
                Set teacherIds = BaseUtils.getPropertiesList(items, (String)"teacherId");
                if (CollectionUtils.isNotEmpty((Collection)teacherIds)) {
                    List teachers = this.userDao.getByIds((Collection)teacherIds, new String[]{"id", "name"});
                    Map cache = BaseUtils.listToMap((List)teachers, (String)"id");
                    for (CourseSubTypeDto item : items) {
                        Long teacherId = item.getTeacherId();
                        if (teacherId != null && cache.containsKey(teacherId)) {
                            item.setTeacherName(((User)cache.get(teacherId)).getName());
                            continue;
                        }
                        item.setTeacherName("");
                    }
                    teacherDefault.setContent(JacksonUtil.obj2Str(items));
                }
            } else {
                teacherDefault.setContent("");
            }
            teacherDefaults.add(teacherDefault);
        }
        this.classTeacherDefaultDao.saveAll((List)teacherDefaults, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void joinConfirm(JoinClassReq params) {
        Class clazz = (Class)this.classDao.getById((Serializable)params.getClassId(), new String[0]);
        Date now = new Date();
        ArrayList updateLessons = Lists.newArrayList();
        HashMap enrollCourseCache = Maps.newHashMap();
        Student student = (Student)this.studentDao.getById((Serializable)params.getStudentId(), new String[0]);
        IdAndNameDto info = new IdAndNameDto(student.getId(), student.getName());
        this.joinBefore(clazz, info);
        for (JoinClassEnrollLessonReq course : params.getCourseLessons()) {
            Collection<Long> classCourseDetailsIds = course.getClassCourseDetailIds();
            List classCourseDetails = this.classCourseDetailDao.getByIds(classCourseDetailsIds, new String[0]);
            if (!CollectionUtils.isNotEmpty((Collection)classCourseDetails)) continue;
            HashMap cache = Maps.newHashMap();
            for (ClassCourseDetail lesson : classCourseDetails) {
                Long subTypeId = lesson.getSubTypeId();
                if (lesson.getLessonStatus() == LessonStatus.CONSUMED.getStatus()) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u3010" + lesson.getCourseName() + "\u3011\u5355\u9879\u3010" + lesson.getSubTypeName() + "\u3011\u7b2c\u3010" + lesson.getNumber() + "\u3011\u8282\u8bfe\u5df2\u7ecf\u8bfe\u6d88,\u4e0d\u80fd\u9009\u62e9");
                }
                if (cache.containsKey(subTypeId)) {
                    ((List)cache.get(subTypeId)).add(lesson);
                    continue;
                }
                ArrayList subList = Lists.newArrayList((Object[])new ClassCourseDetail[]{lesson});
                cache.put(subTypeId, subList);
            }
            PageDto pageDto = null;
            for (Long subTypeId : cache.keySet()) {
                List details = (List)cache.get(subTypeId);
                pageDto = new PageDto();
                pageDto.setPageSize(Integer.valueOf(1));
                pageDto.setPageSize(Integer.valueOf(details.size()));
                List studentLessons = this.enrollStudentLessonDao.getStudentLessonsByParams(params.getStudentId(), course.getCourseId(), subTypeId, BizConf.FALSE, pageDto);
                if (!CollectionUtils.isNotEmpty((Collection)studentLessons)) continue;
                if (studentLessons.size() == details.size()) {
                    int index = 0;
                    for (EnrollStudentLesson studentLesson : studentLessons) {
                        ClassCourseDetail detail = (ClassCourseDetail)details.get(index);
                        studentLesson.setClassCourseDetailId(detail.getId());
                        studentLesson.setStatus(StudentLessonStatus.LOCK.getStatus());
                        studentLesson.setClassId(clazz.getId());
                        studentLesson.setClassName(clazz.getName());
                        studentLesson.setJoinTime(now);
                        studentLesson.setJoinType(JoinLessonType.NORMAL.getStatus());
                        updateLessons.add(studentLesson);
                        long enrollId = studentLesson.getEnrollId();
                        long courseId = studentLesson.getCourseId();
                        if (enrollCourseCache.containsKey(enrollId)) {
                            ((Set)enrollCourseCache.get(enrollId)).add(courseId);
                        } else {
                            enrollCourseCache.put(enrollId, Sets.newHashSet((Object[])new Long[]{courseId}));
                        }
                        ++index;
                    }
                    continue;
                }
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5355\u9879\u3010" + ((ClassCourseDetail)details.get(0)).getSubTypeName() + "\u3011\u9884\u671f\u6709\u3010" + details.size() + "\u3011\u8282\u8bfe\u8fdb\u5165\u73ed\u7ea7\uff0c\u5b66\u751f\u5269\u4f59\u8bfe\u8282\u3010" + studentLessons.size() + "\u3011,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        }
        if (!CollectionUtils.isNotEmpty((Collection)updateLessons)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u8bfe\u8282\u8fdb\u5165\u73ed\u7ea7");
        }
        this.enrollStudentLessonDao.lockEnrollStudentLessons((List)updateLessons);
        this.lockEnrollCourse(enrollCourseCache, params.getClassId(), params.getStudentId());
    }

    void lockEnrollCourse(Map<Long, Set<Long>> enrollCourseCache, Long classId, long studentId) {
        if (!enrollCourseCache.isEmpty()) {
            HashMap params = null;
            for (long enrollId : enrollCourseCache.keySet()) {
                Set<Long> courseIds = enrollCourseCache.get(enrollId);
                params = Maps.newHashMap();
                params.put("enrollId", enrollId);
                params.put("courseId", courseIds);
                params.put("lockClassId", classId);
                params.put("isLock", BizConf.TRUE);
                for (Long courseId : courseIds) {
                    EnrollCourse enrollCourse = this.enrollCourseDao.getEnrollCourse(Long.valueOf(enrollId), courseId);
                    this.saveClassStudentRecord(classId, Sets.newHashSet((Object[])new Long[]{studentId}), 0, ClassStudentRecordType.JOIN_CLASS.getType(), enrollCourse.getId());
                }
                this.enrollCourseDao.update((Map)params, new String[]{"lockClassId", "isLock"});
            }
        }
    }

    @Override
    public List<EnrollStudentLessonResp> getClassLessons(Long classId, Long courseId, Long subTypeId) {
        ArrayList result = Lists.newArrayList();
        Class clazz = (Class)this.classDao.getById((Serializable)classId, new String[0]);
        if (clazz != null) {
            List details;
            EnrollStudentLessonResp item = null;
            if (subTypeId != null && subTypeId > 0L) {
                EnrollStudentLesson studentLesson = (EnrollStudentLesson)this.enrollStudentLessonDao.getById((Serializable)subTypeId, new String[0]);
                subTypeId = studentLesson.getSubTypeId();
            }
            if (CollectionUtils.isNotEmpty((Collection)(details = this.classCourseDetailDao.getClassCourseDetailBySubTypeId(classId, courseId, subTypeId, (Collection)Sets.newHashSet((Object[])new Integer[]{LessonStatus.UN_SCHEDULE.getStatus(), LessonStatus.UN_START.getStatus()}))))) {
                Set classCourseDetailIds = BaseUtils.getPropertiesList((Collection)details, (String)"id");
                Map<Long, Integer> cache = this.getAndCacheClassCourseDetail(classCourseDetailIds);
                for (ClassCourseDetail detail : details) {
                    Long id = detail.getId();
                    int studentCount = 0;
                    if (cache.containsKey(id)) {
                        studentCount = cache.get(id);
                    }
                    if (studentCount + 1 > clazz.getCountLimit()) continue;
                    item = new EnrollStudentLessonResp();
                    BeanUtils.copyProperties((Object)detail, (Object)item);
                    item.setIndex(detail.getNumber());
                    result.add(item);
                }
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        return result;
    }

    @Override
    public List<IdAndNameDto> getCoursesForOption(Long courseId, String query) {
        ArrayList result = Lists.newArrayList();
        List details = Lists.newArrayList();
        if (courseId == null) {
            details = this.classCourseDetailDao.getClassIdsByStatuses((Collection)Sets.newHashSet((Object[])new Integer[]{LessonStatus.UN_SCHEDULE.getStatus(), LessonStatus.UN_START.getStatus()}));
        } else {
            Course course = (Course)this.courseDao.getById((Serializable)courseId, new String[0]);
            if (course == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            details = this.classCourseDetailDao.getClassCourseDetailByCourseId(courseId, (Collection)Sets.newHashSet((Object[])new Integer[]{LessonStatus.UN_SCHEDULE.getStatus(), LessonStatus.UN_START.getStatus()}));
        }
        if (CollectionUtils.isEmpty((Collection)details)) {
            return result;
        }
        Set classIds = BaseUtils.getPropertiesList((Collection)details, (String)"classId");
        List classList = this.classDao.getClassInfosByName(query, (Collection)classIds);
        if (CollectionUtils.isEmpty((Collection)classList)) {
            return result;
        }
        for (Class clazz : classList) {
            if (clazz.getClassType() == CourseType.ONEvOne.getType() || clazz.getStatus() == ClassStatus.LOCKED.getStatus() || clazz.getStatus() == ClassStatus.UN_SCHEDULE.getStatus()) continue;
            IdAndNameDto dto = new IdAndNameDto();
            dto.setId(clazz.getId());
            dto.setName(clazz.getName());
            result.add(dto);
        }
        return result;
    }

    Map<Long, Integer> getAndCacheClassCourseDetail(Collection<Long> classCourseDetailIds) {
        Map cache = this.enrollStudentLessonDao.getEnrollStudentCount(classCourseDetailIds);
        return cache;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertClass(Long enrollLessonId, Long classCourseDetailId) {
        EnrollStudentLesson studentLesson = (EnrollStudentLesson)this.enrollStudentLessonDao.getById((Serializable)enrollLessonId, new String[0]);
        ClassCourseDetail classCourseDetail = (ClassCourseDetail)this.classCourseDetailDao.getById((Serializable)classCourseDetailId, new String[0]);
        if (studentLesson != null && classCourseDetail != null) {
            int status = classCourseDetail.getLessonStatus();
            Class clazz = (Class)this.classDao.getById((Serializable)classCourseDetail.getClassId(), new String[0]);
            this.insertBefore(clazz, classCourseDetailId);
            if (status == LessonStatus.UN_START.getStatus() || status == LessonStatus.UN_SCHEDULE.getStatus()) {
                EnrollCourse enrollCourse = this.enrollCourseDao.getEnrollCourse(studentLesson.getEnrollId(), studentLesson.getCourseId());
                if (enrollCourse == null || enrollCourse.getIsRefund() == BizConf.TRUE.intValue()) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u672a\u62a5\u540d\u8fd9\u95e8\u8bfe\u7a0b\u6216\u8bfe\u7a0b\u5df2\u9000\u8d39");
                }
                studentLesson.setClassId(classCourseDetail.getClassId());
                studentLesson.setClassName(clazz.getName());
                studentLesson.setClassCourseDetailId(classCourseDetail.getId());
                studentLesson.setStatus(StudentLessonStatus.LOCK.getStatus());
                int type = ClassStudentRecordType.INSERT_CLASS.getType();
                if (enrollCourse.getLockClassId() != null && enrollCourse.getLockClassId() > 0L) {
                    studentLesson.setJoinType(JoinLessonType.MAKE_UP.getStatus());
                    type = ClassStudentRecordType.INSERT_LESSON.getType();
                } else {
                    studentLesson.setJoinType(JoinLessonType.INSERT.getStatus());
                }
                studentLesson.setJoinTime(new Date());
                this.enrollStudentLessonDao.update((Object)studentLesson, new String[]{"classId", "className", "classCourseDetailId", "status", "joinType", "joinTime"});
                this.checkAndLockEnrollCourse(clazz.getId(), enrollCourse, type, studentLesson.getStudentId());
            } else {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8fdb\u884c\u4e2d\u3001\u5df2\u4e0a\u5b8c\u6216\u5df2\u7ed3\u8bfe\u7684\u8bfe\u6b21\u4e0d\u53ef\u4ee5\u63d2\u5165\u73ed\u7ea7");
            }
        }
    }

    void insertBefore(Class clazz, long classCourseDetailId) {
        int countLimit = clazz.getCountLimit();
        int count = this.enrollStudentLessonDao.getClassLessonStuentCount(Long.valueOf(classCourseDetailId), (Collection)Sets.newHashSet((Object[])new Integer[]{JoinLessonType.NORMAL.getStatus(), JoinLessonType.INSERT.getStatus()}));
        if (count >= countLimit) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\uff1a\u3010" + clazz.getName() + "\u3011\u5f53\u524d\u8bfe\u8282\u5df2\u6709\u5b66\u751f\u3010" + count + "\u3011\u540d, \u73ed\u7ea7\u6700\u5927\u5bb9\u7eb3\u5b66\u751f\u3010" + countLimit + "\u3011\uff0c\u5b66\u751f\u63d2\u73ed\u540e\u5927\u4e8e\u73ed\u7ea7\u6700\u5927\u5bb9\u91cf");
        }
    }

    void checkAndLockEnrollCourse(long classId, EnrollCourse enrollCourse, int type, long studentId) {
        if (type == ClassStudentRecordType.INSERT_CLASS.getType()) {
            enrollCourse.setLockClassId(Long.valueOf(classId));
            enrollCourse.setIsLock(BizConf.TRUE.intValue());
            enrollCourse.setUpdateTime(new Date());
            this.enrollCourseDao.update((Object)enrollCourse, new String[]{"lockClassId", "isLock", "updateTime"});
        }
        this.saveClassStudentRecord(classId, Sets.newHashSet((Object[])new Long[]{studentId}), 0, type, enrollCourse.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void preJoin(Long studentId, Long classCourseDetailId) {
        ClassCourseDetail detail = (ClassCourseDetail)this.classCourseDetailDao.getById((Serializable)classCourseDetailId, new String[0]);
        Date now = new Date();
        if (detail != null) {
            this.preJoinBefore(studentId, detail.getClassId(), classCourseDetailId);
            Long lessonId = detail.getLessonId();
            if (lessonId != null && lessonId > 0L) {
                OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
                if (lesson != null) {
                    String start = BaseUtils.getFormatTime((Date)lesson.getStartTime(), (String)"yyyy-MM-dd HH:mm");
                    String end = BaseUtils.getFormatTime((Date)lesson.getEndTime(), (String)"yyyy-MM-dd HH:mm");
                    if (now.after(lesson.getEndTime())) {
                        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u8bfe\u7a0b\u3010" + detail.getCourseName() + "\u3011-\u3010" + detail.getSubTypeName() + "\u3011-\u3010" + detail.getNumber() + "\u3011\u8282\u8bfe\u5df2\u4e0a\u5b8c\uff0c\u4e0a\u8bfe\u65f6\u95f4\u3010" + start + "~" + end + "\u3011");
                    }
                    if (now.after(lesson.getStartTime()) && now.before(lesson.getEndTime())) {
                        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u8bfe\u7a0b\u3010" + detail.getCourseName() + "\u3011-\u3010" + detail.getSubTypeName() + "\u3011-\u3010" + detail.getNumber() + "\u3011\u6b63\u5728\u4e0a\u8bfe\uff0c\u4e0a\u8bfe\u65f6\u95f4\u3010" + start + "~" + end + "\u3011");
                    }
                } else {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u8bfe\u7a0b\u3010" + detail.getCourseName() + "\u3011-\u3010" + detail.getSubTypeName() + "\u3011-\u3010" + detail.getNumber() + "\u3011\u8282\u8bfe \u5bf9\u5e94\u7684\u6392\u8bfe\u8bb0\u5f55\u4e0d\u5b58\u5728");
                }
            }
            Student student = (Student)this.studentDao.getById((Serializable)studentId, new String[]{"id", "name"});
            EnrollStudentLesson studentLesson = new EnrollStudentLesson();
            BeanUtils.copyProperties((Object)detail, (Object)studentLesson);
            studentLesson.setJoinTime(now);
            studentLesson.setEnrollId(NumberUtils.LONG_MINUS_ONE);
            studentLesson.setClassCourseDetailId(classCourseDetailId);
            studentLesson.setStudentId(studentId);
            studentLesson.setStudentName(student.getName());
            studentLesson.setJoinType(JoinLessonType.PRE_AUDITION.getStatus());
            this.enrollStudentLessonDao.save((Object)studentLesson, new String[0]);
        }
    }

    void preJoinBefore(Long studentId, Long classId, Long classCourseId) {
        int count = this.enrollStudentLessonDao.getStudentClassLessonCount(studentId, classId, classCourseId, Integer.valueOf(JoinLessonType.PRE_AUDITION.getStatus()));
        if (count > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u751f\u5df2\u7ecf\u8bd5\u542c\u8be5\u8bfe\u6b21\uff0c\u4e0d\u80fd\u91cd\u590d\u8bd5\u542c");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reset(Long studentId, Integer status) {
        Student student = (Student)this.studentDao.getById((Serializable)studentId, new String[0]);
        if (student == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728");
        }
        if (student.getStatus() != ClueStatus.STUDENT.getStatus()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53ea\u6709\u5b66\u5458\u624d\u53ef\u4ee5\u6062\u590d/\u505c\u8bfe");
        }
        Date now = new Date();
        if (status.intValue() == StudentStatus.FROZEN.getStatus()) {
            Set enrollIds;
            List courses;
            List studentLessons = this.enrollStudentLessonDao.getClassStudentLesson(studentId, null, (Collection)Sets.newHashSet((Object[])new Integer[]{StudentLessonStatus.UN_LOCK.getStatus(), StudentLessonStatus.LOCK.getStatus()}));
            if (CollectionUtils.isNotEmpty((Collection)studentLessons) && CollectionUtils.isNotEmpty((Collection)(courses = this.enrollCourseDao.getEnrollCourseByPagination((Collection)(enrollIds = BaseUtils.getPropertiesList((Collection)studentLessons, (String)"enrollId")), null)))) {
                Collection classIds = this.enrollRecordDao.getStudentLockedClassIds(studentId);
                List classes = this.classDao.getByIds(classIds, new String[0]);
                Map cache = BaseUtils.listToMap((List)classes, (String)"id");
                for (EnrollCourse course : courses) {
                    Class clazz;
                    long lockClassId;
                    if (course.getIsRefund() == BizConf.TRUE.intValue() || (lockClassId = course.getLockClassId().longValue()) == 0L || !cache.containsKey(lockClassId) || (clazz = (Class)cache.get(lockClassId)).getStatus() == ClassStatus.LOCKED.getStatus()) continue;
                    if (clazz.getClassType() == CourseType.ONEvOne.getType()) {
                        studentLessons = this.enrollStudentLessonDao.getClassStudentLesson(studentId, Long.valueOf(lockClassId), (Collection)Sets.newHashSet((Object[])new Integer[]{StudentLessonStatus.UN_LOCK.getStatus(), StudentLessonStatus.LOCK.getStatus()}));
                        this.quitAfter(studentLessons);
                        clazz.setStatus(ClassStatus.LOCKED.getStatus());
                        clazz.setUpdateTime(new Date());
                        this.classDao.update((Object)clazz, new String[]{"status", "updateTime"});
                        continue;
                    }
                    HashMap params = Maps.newHashMap();
                    params.put("id", course.getId());
                    params.put("isLock", BizConf.FALSE);
                    params.put("lockClassId", Integer.valueOf(NumberUtils.INTEGER_ZERO));
                    this.enrollCourseDao.update((Map)params, new String[]{"isLock", "lockClassId"});
                    this.saveQuitClassRecord(courses, studentId);
                    if (!CollectionUtils.isNotEmpty((Collection)classIds)) continue;
                    for (Long classId : classIds) {
                        this.enrollStudentLessonDao.quitClass(classId, studentId);
                        int classStudents = this.enrollStudentLessonDao.getUnconsumLessonCount(classId, studentId);
                        if (classStudents != NumberUtils.INTEGER_ONE) continue;
                        studentLessons = this.enrollStudentLessonDao.getClassStudentLesson(studentId, classId, (Collection)Sets.newHashSet((Object[])new Integer[]{StudentLessonStatus.UN_LOCK.getStatus(), StudentLessonStatus.LOCK.getStatus()}));
                        this.quitAfter(studentLessons);
                    }
                }
            }
            student.setStudentStatus(StudentStatus.FROZEN.getStatus());
            student.setBrowseType(StudentBrowseType.FROZEN.getType());
        } else {
            student.setStudentStatus(StudentStatus.NORMARL.getStatus());
            student.setBrowseType(StudentBrowseType.STUDYING.getType());
        }
        student.setUpdateTime(now);
        this.studentDao.update((Object)student, new String[]{"studentStatus", "updateTime", "browseType"});
    }

    void saveQuitClassRecord(List<EnrollCourse> enrollCourses, Long studentId) {
        for (EnrollCourse course : enrollCourses) {
            if (course.getLockClassId() == null || course.getLockClassId() <= 0L) continue;
            this.saveClassStudentRecord(course.getLockClassId(), Sets.newHashSet((Object[])new Long[]{studentId}), 0, ClassStudentRecordType.QUIT_CLASS.getType(), course.getId());
        }
    }

    void saveClassStudentRecord(Long classId, Collection<Long> studentIds, int lessonCount, int type, long enrollCourseId) {
        ArrayList records = Lists.newArrayList();
        List students = this.studentDao.getByIds(studentIds, new String[]{"id", "name"});
        if (CollectionUtils.isNotEmpty((Collection)students)) {
            Class clazz = (Class)this.classDao.getById((Serializable)classId, new String[]{"id", "name"});
            BaseLoginUser currentUser = LoginUtil.getCurrentUser();
            Date now = new Date();
            for (Student student : students) {
                ClassStudentRecord record = new ClassStudentRecord();
                record.setClassId(classId);
                record.setClassName(clazz.getName());
                record.setCreateTime(now);
                record.setCreatorId(currentUser.getUserId());
                record.setCreatorName(currentUser.getUserName());
                record.setLessonCount(lessonCount);
                record.setStudentId(student.getId());
                record.setStudentName(student.getName());
                record.setType(type);
                record.setEnrollCourseId(Long.valueOf(enrollCourseId));
                records.add(record);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            log.info("saveClassStudentRecord.records:{}", (Object)records);
            this.classStudentRecordDao.saveAll((List)records, new String[0]);
        }
    }
}

