/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.service.impl;

import com.baijia.component.permission.util.BaseUtils;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.common.model.IdAndNameRemarkDto;
import com.baijia.wedo.dal.edu.dao.course.CourseDetailDao;
import com.baijia.wedo.dal.edu.dao.course.CourseSubTypeDao;
import com.baijia.wedo.dal.edu.dao.course.SubjectDao;
import com.baijia.wedo.dal.edu.po.CourseSubType;
import com.baijia.wedo.dal.edu.po.Subject;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.sal.dto.SubjectListDto;
import com.baijia.wedo.sal.dto.SubjectSearchResp;
import com.baijia.wedo.sal.service.SubjectService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubjectServiceImpl
implements SubjectService {
    @Autowired
    private SubjectDao subjectDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private CourseSubTypeDao courseSubTypeDao;
    @Autowired
    private CourseDetailDao courseDetailDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSubject(long userId, String subjectName, String code) {
        Subject subject = this.subjectDao.getSubjectByName(subjectName, null);
        if (subject != null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u3010" + subjectName + "\u3011\u5bf9\u5e94\u7684\u5206\u7c7b\u5df2\u5b58\u5728");
        }
        List subjects = this.subjectDao.getSubjectByCode(code, null);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subjects)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7c7b\u7f16\u7801\u3010" + code + "\u3011\u5bf9\u5e94\u7684\u5206\u7c7b\u5df2\u5b58\u5728");
        }
        User user = (User)this.userDao.getById((Serializable)Long.valueOf(userId), new String[0]);
        if (user != null) {
            subject = new Subject();
            subject.setCreateTime(new Date());
            subject.setName(subjectName);
            subject.setUpdateTime(new Date());
            subject.setCode(code);
            this.subjectDao.save((Object)subject, new String[0]);
        }
    }

    @Override
    public List<SubjectSearchResp> search(Long subjectId, Long courseSubTypeId, PageDto pageDto) {
        List result = Lists.newArrayList();
        if (subjectId == null && courseSubTypeId == null) {
            result = this.courseSubTypeDao.getSubType(pageDto);
            return this.extractAndWrap(result);
        }
        if (subjectId != null && courseSubTypeId == null) {
            Subject subject = (Subject)this.subjectDao.getById((Serializable)subjectId, new String[0]);
            if (subject != null) {
                result = this.courseSubTypeDao.getSubTypeBySubjectId(subjectId.longValue(), pageDto);
                return this.extractAndWrap(result);
            }
        } else {
            CourseSubType subType;
            Subject subject = (Subject)this.subjectDao.getById((Serializable)subjectId, new String[0]);
            if (subject != null && (subType = (CourseSubType)this.courseSubTypeDao.getById((Serializable)courseSubTypeId, new String[0])) != null && subType.getSubjectId() == subjectId.longValue()) {
                return this.extractAndWrap(subject, subType);
            }
        }
        return Collections.emptyList();
    }

    List<SubjectSearchResp> extractAndWrap(List<CourseSubType> result) {
        ArrayList data = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(result)) {
            HashMap cache = Maps.newHashMap();
            for (CourseSubType item : result) {
                long subjectId = item.getSubjectId();
                Subject subject = null;
                subject = cache.containsKey(subjectId) ? (Subject)cache.get(subjectId) : (Subject)this.subjectDao.getById((Serializable)Long.valueOf(item.getSubjectId()), new String[0]);
                if (subject == null) continue;
                SubjectSearchResp resp = this.wrapSearchResult(subject, item);
                data.add(resp);
            }
        }
        return data;
    }

    List<SubjectSearchResp> extractAndWrap(Subject subject, CourseSubType ... result) {
        ArrayList data = Lists.newArrayList();
        if (result != null && result.length > 0) {
            for (CourseSubType item : result) {
                SubjectSearchResp resp = this.wrapSearchResult(subject, item);
                data.add(resp);
            }
        }
        return data;
    }

    SubjectSearchResp wrapSearchResult(Subject subject, CourseSubType item) {
        SubjectSearchResp resp = new SubjectSearchResp();
        resp.setCreateTime(item.getCreateTime().getTime());
        resp.setName(subject.getName());
        resp.setSubjectId(subject.getId());
        IdAndNameDto detail = new IdAndNameDto();
        detail.setId(Long.valueOf(item.getId()));
        detail.setName(item.getName());
        resp.setDetails(detail);
        return resp;
    }

    @Override
    public void delSubject(long subjectId) {
        Subject subject = (Subject)this.subjectDao.getById((Serializable)Long.valueOf(subjectId), new String[0]);
        if (subject != null) {
            int count = this.courseSubTypeDao.getSubTypeCountBySubjectId(Long.valueOf(subjectId));
            if (count > 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u5173\u8054\u5355\u9879\u7684\u8bfe\u7a0b\u5206\u7c7b\u4e0d\u80fd\u5220\u9664");
            }
            this.subjectDao.delById((Serializable)Long.valueOf(subjectId));
        }
    }

    @Override
    public void editSubType(Long id, String name, Long subjectId) {
        Subject subject = (Subject)this.subjectDao.getById((Serializable)subjectId, new String[0]);
        if (subject != null) {
            this.editBefore(id);
            CourseSubType subType = (CourseSubType)this.courseSubTypeDao.getById((Serializable)id, new String[0]);
            if (!subType.getName().equals(name) || !subject.equals((Object)subjectId)) {
                subType.setUpdateTime(new Date());
                subType.setName(name);
                subType.setSubjectId(subjectId.longValue());
                this.courseSubTypeDao.update((Object)subType, new String[]{"updateTime", "name", "subjectId"});
            }
        }
    }

    @Override
    public void editSubject(Long id, String subjectName, String code) {
        Subject subject = (Subject)this.subjectDao.getById((Serializable)id, new String[0]);
        if (!(subject == null || subjectName.equals(subject.getName()) && code.equals(subject.getCode()))) {
            this.editSubjectBefore(subjectName, code, Sets.newHashSet((Object[])new Long[]{id}));
            subject.setName(subjectName);
            subject.setCode(code);
            subject.setUpdateTime(new Date());
            this.subjectDao.update((Object)subject, new String[]{"name", "updateTime", "code"});
        }
    }

    void editSubjectBefore(String subjectName, String code, Collection<Long> excludeIds) {
        Subject subject = this.subjectDao.getSubjectByName(subjectName, excludeIds);
        if (subject != null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7c7b\u540d\u79f0\u3010" + subjectName + "\u3011\u5df2\u7ecf\u5b58\u5728");
        }
        List subjects = this.subjectDao.getSubjectByCode(code, excludeIds);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subjects)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7c7b\u7f16\u53f7\u3010" + code + "\u3011\u5df2\u7ecf\u5b58\u5728");
        }
    }

    void editBefore(long subTypeId) {
        int count = this.courseDetailDao.getCourseCountBySubTypeId(Long.valueOf(subTypeId));
        if (count > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u5173\u8054\u73ed\u7ea7\u7684\u8bfe\u7a0b\u5206\u7c7b\u4e0d\u80fd\u4fee\u6539");
        }
    }

    @Override
    public List<IdAndNameDto> getAllSubjects() {
        List subjects = this.subjectDao.getAllSubjects();
        ArrayList data = Lists.newArrayList();
        IdAndNameDto item = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subjects)) {
            for (Subject subject : subjects) {
                item = new IdAndNameDto();
                item.setId(Long.valueOf(subject.getId()));
                item.setName(subject.getName());
                data.add(item);
            }
        }
        return data;
    }

    @Override
    public List<IdAndNameDto> getIdAndNames() {
        List subjects = this.subjectDao.getAllSubjects();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subjects)) {
            ArrayList dtos = Lists.newArrayList();
            for (Subject subject : subjects) {
                IdAndNameDto dto = new IdAndNameDto();
                dto.setId(Long.valueOf(subject.getId()));
                dto.setName(subject.getName());
                dtos.add(dto);
            }
            return dtos;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<SubjectListDto> querySubject(String name, PageDto pageDto) {
        List subjects = this.subjectDao.querySubjectByNameOrCode(name, pageDto);
        ArrayList result = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subjects)) {
            Set subjectIds = BaseUtils.getPropertiesList((List)subjects, (String)"id");
            Map cache = this.courseSubTypeDao.getSubTypeCountBySubjectIds((Collection)subjectIds);
            for (Subject subject : subjects) {
                SubjectListDto item = SubjectListDto.convertToDto(subject);
                if (cache.containsKey(subject.getId())) {
                    item.setSubTypeCount((Integer)cache.get(subject.getId()));
                } else {
                    item.setSubTypeCount(0);
                }
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public Collection<IdAndNameDto> fuzzyQuery(String query, PageDto pageDto) {
        List subjects = this.subjectDao.querySubjectByNameOrCode(query, pageDto);
        Collection result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)subjects)) {
            result = CollectionUtils.collect((Iterable)subjects, (Transformer)new Transformer<Subject, IdAndNameDto>(){

                public IdAndNameDto transform(Subject input) {
                    IdAndNameDto output = new IdAndNameDto(Long.valueOf(input.getId()), input.getName());
                    return output;
                }
            });
        }
        return result;
    }

    @Override
    public IdAndNameRemarkDto getSubjectDetail(Long id) {
        Subject subject = (Subject)this.subjectDao.getById((Serializable)id, new String[0]);
        if (subject != null) {
            IdAndNameRemarkDto result = new IdAndNameRemarkDto();
            result.setId(Long.valueOf(subject.getId()));
            result.setName(subject.getName());
            result.setRemark(subject.getCode());
            return result;
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED, "\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
    }
}

