/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.service.impl;

import com.baijia.component.permission.util.BaseUtils;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.common.model.SubjectAndSubTypeDto;
import com.baijia.wedo.dal.edu.dao.clazz.ClassCourseDao;
import com.baijia.wedo.dal.edu.dao.course.CourseDetailDao;
import com.baijia.wedo.dal.edu.dao.course.CourseSubTypeDao;
import com.baijia.wedo.dal.edu.dao.course.SubjectDao;
import com.baijia.wedo.dal.edu.po.CourseSubType;
import com.baijia.wedo.dal.edu.po.Subject;
import com.baijia.wedo.sal.dto.CourseSubTypeListDto;
import com.baijia.wedo.sal.dto.SubTypeDetailResp;
import com.baijia.wedo.sal.service.CourseSubTypeService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CourseSubTypeServiceImpl
implements CourseSubTypeService {
    @Autowired
    private SubjectDao subjectDao;
    @Autowired
    private CourseSubTypeDao courseSubTypeDao;
    @Autowired
    private CourseDetailDao courseDetailDao;
    @Autowired
    private ClassCourseDao classCourseDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(long subjectId, String name) {
        CourseSubType courseSubType;
        Subject subject = (Subject)this.subjectDao.getById((Serializable)Long.valueOf(subjectId), new String[0]);
        if (subject != null) {
            courseSubType = this.courseSubTypeDao.getSubTypeByName(subjectId, name);
            if (courseSubType != null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED);
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED);
        }
        courseSubType = new CourseSubType();
        courseSubType.setCreateTime(new Date());
        courseSubType.setName(name);
        courseSubType.setSubjectId(subjectId);
        courseSubType.setUpdateTime(new Date());
        this.courseSubTypeDao.save((Object)courseSubType, new String[0]);
    }

    @Override
    public List<IdAndNameDto> getSubTypeList(Long subjectId) {
        List subTypeList = this.courseSubTypeDao.getSubTypeBySubjectId(subjectId.longValue(), null);
        ArrayList data = Lists.newArrayList();
        IdAndNameDto item = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subTypeList)) {
            for (CourseSubType rs : subTypeList) {
                item = new IdAndNameDto();
                item.setId(Long.valueOf(rs.getId()));
                item.setName(rs.getName());
                data.add(item);
            }
        }
        return data;
    }

    @Override
    public List<CourseSubTypeListDto> searchSubType(Long subjectId, PageDto pageDto) {
        List subTypes;
        ArrayList result = Lists.newArrayList();
        Set subjectIds = Sets.newHashSet();
        if (subjectId != null && subjectId > 0L) {
            subjectIds.add(subjectId);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(subTypes = this.courseSubTypeDao.querySubTypeBySubjectIds((Collection)subjectIds, pageDto)))) {
            subjectIds = BaseUtils.getPropertiesList((List)subTypes, (String)"subjectId");
            List subjects = Lists.newArrayList();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subjectIds)) {
                subjects = this.subjectDao.getByIds((Collection)subjectIds, new String[0]);
            }
            Map cache = BaseUtils.listToMap((List)subjects, (String)"id");
            CourseSubTypeListDto item = null;
            for (CourseSubType subType : subTypes) {
                item = new CourseSubTypeListDto();
                if (!cache.containsKey(subType.getSubjectId())) continue;
                Subject subject = (Subject)cache.get(subType.getSubjectId());
                item.setCode(subject.getCode());
                item.setCreateTime(subType.getCreateTime().getTime());
                item.setId(subType.getId());
                item.setName(subType.getName());
                item.setSubjectId(subject.getId());
                item.setSubjectName(subject.getName());
                result.add(item);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(Long id, String name, Long subjectId) {
        if (id != null && id > 0L) {
            this.edit(id, name, subjectId);
        } else {
            this.add(name, subjectId);
        }
    }

    void edit(Long id, String name, Long subjectId) {
        CourseSubType subType = (CourseSubType)this.courseSubTypeDao.getById((Serializable)id, new String[0]);
        if (subType != null) {
            CourseSubType newSubType = this.courseSubTypeDao.getSubTypeByName(subjectId.longValue(), name);
            if (newSubType != null && subType.getId() != newSubType.getId()) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u5206\u7c7b\u4e0b\u5df2\u7ecf\u5b58\u5728\u3010" + name + "\u3011\u5355\u9879");
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        subType.setName(name);
        subType.setSubjectId(subjectId.longValue());
        subType.setUpdateTime(new Date());
        this.courseSubTypeDao.update((Object)subType, new String[]{"name", "subjectId", "updateTime"});
    }

    void add(String name, Long subjectId) {
        CourseSubType newSubType = this.courseSubTypeDao.getSubTypeByName(subjectId.longValue(), name);
        if (newSubType != null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u5206\u7c7b\u4e0b\u5df2\u7ecf\u5b58\u5728\u3010" + name + "\u3011\u5355\u9879");
        }
        Date now = new Date();
        newSubType = new CourseSubType();
        newSubType.setCreateTime(now);
        newSubType.setName(name);
        newSubType.setSubjectId(subjectId.longValue());
        newSubType.setUpdateTime(now);
        this.courseSubTypeDao.save((Object)newSubType, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delSubType(Long id) {
        CourseSubType subType = (CourseSubType)this.courseSubTypeDao.getById((Serializable)id, new String[0]);
        if (subType != null) {
            this.delBefore(id);
            this.courseSubTypeDao.delById((Serializable)id);
        }
    }

    void delBefore(Long id) {
        List courses = this.courseDetailDao.getCourseBySubTypeId(id);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)courses)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5355\u9879\u5df2\u5173\u8054\u8bfe\u7a0b\uff0c\u4e0d\u80fd\u88ab\u5220\u9664");
        }
    }

    @Override
    public List<SubjectAndSubTypeDto> getSubjects(String query) {
        List subjects = this.subjectDao.querySubjectByNameOrCode(query, null);
        ArrayList result = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subjects)) {
            SubjectAndSubTypeDto item = null;
            for (Subject subject : subjects) {
                item = new SubjectAndSubTypeDto();
                item.setId(Long.valueOf(subject.getId()));
                item.setName(subject.getName());
                List subTypes = this.courseSubTypeDao.getSubTypeBySubjectId(subject.getId(), null);
                Collection subList = CollectionUtils.collect((Iterable)subTypes, (Transformer)new Transformer<CourseSubType, IdAndNameDto>(){

                    public IdAndNameDto transform(CourseSubType input) {
                        IdAndNameDto output = new IdAndNameDto();
                        output.setId(Long.valueOf(input.getId()));
                        output.setName(input.getName());
                        return output;
                    }
                });
                item.setSubTypes(subList);
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public SubTypeDetailResp getSubTypeDetail(Long id) {
        CourseSubType subType = (CourseSubType)this.courseSubTypeDao.getById((Serializable)id, new String[0]);
        if (subType != null) {
            SubTypeDetailResp result = new SubTypeDetailResp();
            result.setId(subType.getId());
            result.setName(subType.getName());
            result.setSubjectId(subType.getSubjectId());
            Subject subject = (Subject)this.subjectDao.getById((Serializable)Long.valueOf(subType.getSubjectId()), new String[0]);
            if (subject != null) {
                result.setSubjectName(subject.getName());
                result.setCode(subject.getCode());
            }
            return result;
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED, "\u5355\u9879\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
    }
}

