/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.service.impl;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.wedo.common.enums.CourseStatus;
import com.baijia.wedo.common.enums.CourseType;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.dal.edu.dao.course.CourseDao;
import com.baijia.wedo.dal.edu.dao.course.CourseDetailDao;
import com.baijia.wedo.dal.edu.dao.course.SubjectDao;
import com.baijia.wedo.dal.edu.po.Course;
import com.baijia.wedo.dal.edu.po.CourseDetail;
import com.baijia.wedo.dal.edu.po.Subject;
import com.baijia.wedo.sal.dto.CourseAddReq;
import com.baijia.wedo.sal.dto.CourseDetailDto;
import com.baijia.wedo.sal.dto.CourseListResp;
import com.baijia.wedo.sal.dto.IdAndNumDto;
import com.baijia.wedo.sal.dto.SearchCourseResp;
import com.baijia.wedo.sal.dto.clazz.CourseDetailResp;
import com.baijia.wedo.sal.service.CourseService;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CourseServiceImpl
implements CourseService {
    @Autowired
    private CourseDao courseDao;
    @Autowired
    private CourseDetailDao courseDetailDao;
    @Autowired
    private SubjectDao subjectDao;

    @Override
    public List<CourseListResp> searchCourseByParams(String query, Long subjectId, Integer courseLevel, Integer courseType, Integer status, PageDto pageDto) {
        List courses = this.courseDao.queryCourseByParams(query, subjectId, courseLevel, courseType, status, pageDto);
        List result = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)courses)) {
            Set courseIds = BaseUtils.getPropertiesList((Collection)courses, (String)"id");
            Set subjectIds = BaseUtils.getPropertiesList((Collection)courses, (String)"subjectId");
            Map cache = this.courseDetailDao.getCourseDetailByCourseId((Collection)courseIds);
            Map<Long, Subject> subjectCache = this.getAndCacheSubject(subjectIds);
            for (Course course : courses) {
                CourseListResp item = CourseListResp.convertToDto(course);
                if (cache.containsKey(course.getId())) {
                    List details = (List)cache.get(course.getId());
                    String content = this.getContent(details, course.getCourseType());
                    item.setContent(content);
                }
                if (subjectCache.containsKey(course.getSubjectId())) {
                    Subject subject = subjectCache.get(course.getSubjectId());
                    item.setSubjectId(subject.getId());
                    item.setSubjectName(subject.getName());
                }
                result.add(item);
            }
        }
        return result;
    }

    Map<Long, Subject> getAndCacheSubject(Collection<Long> subjectIds) {
        Map cache = Maps.newHashMap();
        List subjects = this.subjectDao.getByIds(subjectIds, new String[]{"id", "name"});
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subjects)) {
            cache = BaseUtils.listToMap((List)subjects, (String)"id");
        }
        return cache;
    }

    String getContent(List<CourseDetail> details, int courseType) {
        StringBuffer sb = new StringBuffer();
        for (CourseDetail detail : details) {
            String subTypeName = detail.getSubTypeName();
            int amount = detail.getAmount();
            Long price = detail.getPrice();
            if (courseType == CourseType.ONEvN.getType() || courseType == CourseType.ONEvG.getType()) {
                if (StringUtils.isNotBlank((CharSequence)sb)) {
                    sb.append("\u3001").append(subTypeName).append("*").append(amount);
                    continue;
                }
                sb.append(subTypeName).append("*").append(amount);
                continue;
            }
            Double newPrice = BaseUtils.divided((Long)Long.parseLong(price + ""), (Integer)100, (int)2);
            if (StringUtils.isNotBlank((CharSequence)sb)) {
                sb.append("\u3001").append(subTypeName).append(" \uffe5").append(newPrice).append("/\u8282");
                continue;
            }
            sb.append(subTypeName).append(" \uffe5").append(newPrice).append("/\u8282");
        }
        return sb.toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(CourseAddReq params) {
        Long courseId = params.getId();
        if (courseId != null && courseId > 0L) {
            this.edit(params);
        } else {
            BaseLoginUser creator = LoginUtil.getCurrentUser();
            this.add(params, creator);
        }
    }

    void dobefore(String courseName) {
        int count = this.courseDao.getCourseCountByName(courseName);
        if (count > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a\u3010" + courseName + "\u3011\u7684\u8bfe\u7a0b\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
    }

    private void edit(CourseAddReq params) {
        Long courseId = params.getId();
        Course course = (Course)this.courseDao.getById((Serializable)courseId, new String[0]);
        if (course != null) {
            if (!course.getName().equals(params.getName())) {
                this.dobefore(params.getName());
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED);
        }
        params.copy(course);
        course.setUpdateTime(new Date());
        this.courseDao.update((Object)course, new String[]{"subjectId", "courseLevel", "courseType", "tagName", "status", "price", "updateTime"});
        this.delCourseDetail(courseId);
        this.addCourseDetail(params.getIndividual(), courseId, params.getCourseType(), params.getSubjectId());
    }

    void delCourseDetail(Long courseId) {
        Map params = Maps.newHashMap();
        params.put("courseId", courseId);
        this.courseDetailDao.delByCondition(params);
    }

    void addCourseDetail(Collection<IdAndNumDto> individual, Long courseId, int courseType, Long subjectId) {
        List details = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(individual)) {
            CourseDetail detail = null;
            for (IdAndNumDto dto : individual) {
                detail = new CourseDetail();
                if (courseType == CourseType.ONEvN.getType() || courseType == CourseType.ONEvG.getType()) {
                    detail.setAmount(Integer.parseInt(dto.getNumber()));
                } else {
                    detail.setPrice(Long.valueOf(Long.parseLong(BaseUtils.plus((Double)Double.parseDouble(dto.getNumber()), (int)100) + "")));
                }
                detail.setCourseId(courseId);
                detail.setCourseType(courseType);
                detail.setSubjectId(subjectId);
                detail.setSubTypeId(dto.getId());
                detail.setSubTypeName(dto.getName());
                details.add(detail);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)details)) {
            this.courseDetailDao.saveAll(details, new String[0]);
        }
    }

    private void add(CourseAddReq params, BaseLoginUser creator) {
        this.dobefore(params.getName());
        Date now = new Date();
        Course course = new Course();
        params.copy(course);
        course.setCreateTime(now);
        course.setCreatorId(creator.getUserId());
        course.setCreatorName(creator.getUserName());
        course.setUpdateTime(now);
        this.courseDao.save((Object)course, new String[0]);
        this.addCourseDetail(params.getIndividual(), course.getId(), course.getCourseType(), course.getSubjectId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableCourse(Long id, Integer status) {
        Course course = (Course)this.courseDao.getById((Serializable)id, new String[0]);
        if (course != null) {
            course.setStatus(status.intValue());
            course.setUpdateTime(new Date());
            this.courseDao.update((Object)course, new String[]{"status", "updateTime"});
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delCourse(Long id) {
        this.courseDao.delById((Serializable)id);
    }

    @Override
    public CourseDetailResp getCourseDetail(Long id) {
        Course course = (Course)this.courseDao.getById((Serializable)id, new String[0]);
        if (course != null) {
            CourseDetailResp result = CourseDetailResp.convertPoToDto(course);
            Collection<IdAndNumDto> individual = this.courseDetail(id);
            Subject subject = (Subject)this.subjectDao.getById((Serializable)course.getSubjectId(), new String[0]);
            if (subject != null) {
                result.setSubjectName(subject.getName());
            } else {
                result.setSubjectName("");
            }
            result.setIndividual(individual);
            return result;
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED, "\u8bfe\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
    }

    private Collection<IdAndNumDto> courseDetail(Long courseId) {
        List details = this.courseDetailDao.queryCourseDetailByCourseId(courseId);
        Collection individual = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)details)) {
            individual = CollectionUtils.collect((Iterable)details, (Transformer)new Transformer<CourseDetail, IdAndNumDto>(){

                public IdAndNumDto transform(CourseDetail input) {
                    IdAndNumDto output = new IdAndNumDto();
                    output.setId(input.getSubTypeId());
                    output.setName(input.getSubTypeName());
                    if (input.getCourseType() == CourseType.ONEvOne.getType()) {
                        output.setNumber(BaseUtils.divided((Long)input.getPrice(), (Integer)100, (int)2) + "");
                    } else {
                        output.setNumber(input.getAmount() + "");
                    }
                    return output;
                }
            });
        }
        return individual;
    }

    @Override
    public Collection<IdAndNameDto> fuzzyQuery(String query, Integer excludeCourseType, PageDto pageDto) {
        List courses = this.courseDao.fuzzyQuery(query, null, pageDto);
        Collection result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)courses)) {
            result = CollectionUtils.collect((Iterable)courses, (Transformer)new Transformer<Course, IdAndNameDto>(){

                public IdAndNameDto transform(Course input) {
                    IdAndNameDto dto = new IdAndNameDto(input.getId(), input.getName());
                    return dto;
                }
            });
        }
        return result;
    }

    @Override
    public List<SearchCourseResp> searchCourseByParams(String query, Integer courseType, PageDto pageDto) {
        List courses = this.courseDao.queryCourseByParams(query, null, null, courseType, Integer.valueOf(CourseStatus.INABLE.getStauts()), pageDto);
        List result = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)courses)) {
            Set courseIds = BaseUtils.getPropertiesList((Collection)courses, (String)"id");
            Set subjectIds = BaseUtils.getPropertiesList((Collection)courses, (String)"subjectId");
            Map cache = this.courseDetailDao.getCourseDetailByCourseId((Collection)courseIds);
            Map<Long, Subject> subjectCache = this.getAndCacheSubject(subjectIds);
            for (Course course : courses) {
                SearchCourseResp item = SearchCourseResp.convertToDto(course);
                if (cache.containsKey(course.getId())) {
                    List details = (List)cache.get(course.getId());
                    List dtos = Lists.newArrayList();
                    for (CourseDetail detail : details) {
                        CourseDetailDto dto = new CourseDetailDto();
                        BeanUtils.copyProperties((Object)detail, (Object)dto, (String[])new String[]{"price"});
                        if (detail.getPrice() > 0L) {
                            dto.setPrice(BaseUtils.divided((Long)detail.getPrice(), (Integer)100, (int)2));
                        } else {
                            dto.setPrice((double)NumberUtils.DOUBLE_ZERO);
                        }
                        dtos.add(dto);
                    }
                    item.setDetails(dtos);
                } else {
                    item.setDetails(Lists.newArrayList());
                }
                if (subjectCache.containsKey(course.getSubjectId())) {
                    Subject subject = subjectCache.get(course.getSubjectId());
                    item.setSubjectId(subject.getId());
                    item.setSubjectName(subject.getName());
                }
                result.add(item);
            }
        }
        return result;
    }
}

