/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.dto.clazz;

import com.baijia.wedo.common.enums.ClassStatus;
import com.baijia.wedo.common.enums.CourseType;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.dal.edu.po.Class;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ClassAddDto
extends IdAndNameDto {
    private Integer countLimit;
    private Long startTime;
    private int classType = CourseType.ONEvN.getType();
    private Long endTime;
    private String remark;
    private List<? extends IdAndNameDto> courses;
    private List<? extends IdAndNameDto> schools;

    public Class convertToPo() {
        Date now = new Date();
        Class clazz = new Class();
        clazz.setCode("");
        clazz.setClassType(this.classType);
        clazz.setCountLimit(this.countLimit);
        clazz.setCreateTime(now);
        clazz.setUpdateTime(now);
        clazz.setEndTime(this.endTime == null ? null : new Date(this.endTime));
        clazz.setStartTime(this.startTime == null ? null : new Date(this.startTime));
        clazz.setName(this.getName());
        clazz.setRemark(this.remark);
        clazz.setStatus(ClassStatus.UN_SCHEDULE.getStatus());
        return clazz;
    }

    public void validate() {
        Preconditions.checkArgument((this.countLimit != null && this.countLimit > 0 ? 1 : 0) != 0, (Object)"\u73ed\u7ea7\u4eba\u6570\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.getName()) && this.getName().length() <= 20 ? 1 : 0) != 0, (Object)"\u73ed\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u301020\u3011");
        Preconditions.checkArgument((this.countLimit > 0 && this.countLimit <= 1000 ? 1 : 0) != 0, (Object)"\u73ed\u7ea7\u4eba\u6570\u9650\u52360~1000");
        if (this.startTime != null && this.endTime != null) {
            Preconditions.checkArgument((this.endTime > this.startTime ? 1 : 0) != 0, (Object)"\u5f00\u73ed\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u65e5\u671f");
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            Preconditions.checkArgument((this.remark.length() < 100 ? 1 : 0) != 0, (Object)"\u5907\u6ce8\u4fe1\u606f\u957f\u5ea6\u3010100\u3011\u5b57\u7b26\u4ee5\u5185");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.schools), (Object)"\u8bf7\u9009\u62e9\u6821\u533a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.courses), (Object)"\u8bf7\u9009\u62e9\u8bfe\u7a0b");
    }

    public Integer getCountLimit() {
        return this.countLimit;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public int getClassType() {
        return this.classType;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public List<? extends IdAndNameDto> getCourses() {
        return this.courses;
    }

    public List<? extends IdAndNameDto> getSchools() {
        return this.schools;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setClassType(int classType) {
        this.classType = classType;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setCourses(List<? extends IdAndNameDto> courses) {
        this.courses = courses;
    }

    public void setSchools(List<? extends IdAndNameDto> schools) {
        this.schools = schools;
    }

    public String toString() {
        return "ClassAddDto(countLimit=" + this.getCountLimit() + ", startTime=" + this.getStartTime() + ", classType=" + this.getClassType() + ", endTime=" + this.getEndTime() + ", remark=" + this.getRemark() + ", courses=" + this.getCourses() + ", schools=" + this.getSchools() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassAddDto)) {
            return false;
        }
        ClassAddDto other = (ClassAddDto)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$countLimit = this.getCountLimit();
        Integer other$countLimit = other.getCountLimit();
        if (this$countLimit == null ? other$countLimit != null : !((Object)this$countLimit).equals(other$countLimit)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        if (this.getClassType() != other.getClassType()) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        List<? extends IdAndNameDto> this$courses = this.getCourses();
        List<? extends IdAndNameDto> other$courses = other.getCourses();
        if (this$courses == null ? other$courses != null : !((Object)this$courses).equals(other$courses)) {
            return false;
        }
        List<? extends IdAndNameDto> this$schools = this.getSchools();
        List<? extends IdAndNameDto> other$schools = other.getSchools();
        return !(this$schools == null ? other$schools != null : !((Object)this$schools).equals(other$schools));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassAddDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $countLimit = this.getCountLimit();
        result = result * 59 + ($countLimit == null ? 43 : ((Object)$countLimit).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        result = result * 59 + this.getClassType();
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        List<? extends IdAndNameDto> $courses = this.getCourses();
        result = result * 59 + ($courses == null ? 43 : ((Object)$courses).hashCode());
        List<? extends IdAndNameDto> $schools = this.getSchools();
        result = result * 59 + ($schools == null ? 43 : ((Object)$schools).hashCode());
        return result;
    }
}

