/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.dto;

import com.baijia.wedo.common.enums.CourseStatus;
import com.baijia.wedo.common.enums.CourseType;
import com.baijia.wedo.common.enums.PhaseType;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.dal.edu.po.Course;
import com.baijia.wedo.sal.dto.CourseDetailDto;
import java.util.List;
import org.springframework.beans.BeanUtils;

public class SearchCourseResp {
    private Long courseId;
    private String courseName;
    private Long subjectId;
    private String subjectName;
    private int courseLevel;
    private String courseLevelStr;
    private String tagName;
    private int courseType;
    private String courseTypeStr;
    private List<CourseDetailDto> details;
    private Double coursePrice;
    private int status;
    private String statusStr;

    public static SearchCourseResp convertToDto(Course source) {
        SearchCourseResp target = new SearchCourseResp();
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])new String[]{"price"});
        target.setCourseId(source.getId());
        target.setCourseName(source.getName());
        target.setCourseLevelStr(PhaseType.get((int)source.getCourseLevel()).getLabel());
        target.setCourseTypeStr(CourseType.get((int)source.getCourseType()).getLabel());
        target.setStatusStr(CourseStatus.get((int)source.getStatus()).getLabel());
        if (source.getCourseType() == CourseType.ONEvN.getType() || source.getCourseType() == CourseType.ONEvG.getType()) {
            Long sourcePrice = source.getPrice();
            Double newPrice = BaseUtils.divided((Long)Long.parseLong(sourcePrice + ""), (Integer)100, (int)2);
            target.setCoursePrice(newPrice);
        }
        return target;
    }

    public Long getCourseId() {
        return this.courseId;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public Long getSubjectId() {
        return this.subjectId;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public int getCourseLevel() {
        return this.courseLevel;
    }

    public String getCourseLevelStr() {
        return this.courseLevelStr;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getCourseType() {
        return this.courseType;
    }

    public String getCourseTypeStr() {
        return this.courseTypeStr;
    }

    public List<CourseDetailDto> getDetails() {
        return this.details;
    }

    public Double getCoursePrice() {
        return this.coursePrice;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusStr() {
        return this.statusStr;
    }

    public void setCourseId(Long courseId) {
        this.courseId = courseId;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public void setCourseLevel(int courseLevel) {
        this.courseLevel = courseLevel;
    }

    public void setCourseLevelStr(String courseLevelStr) {
        this.courseLevelStr = courseLevelStr;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setCourseType(int courseType) {
        this.courseType = courseType;
    }

    public void setCourseTypeStr(String courseTypeStr) {
        this.courseTypeStr = courseTypeStr;
    }

    public void setDetails(List<CourseDetailDto> details) {
        this.details = details;
    }

    public void setCoursePrice(Double coursePrice) {
        this.coursePrice = coursePrice;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatusStr(String statusStr) {
        this.statusStr = statusStr;
    }

    public String toString() {
        return "SearchCourseResp(courseId=" + this.getCourseId() + ", courseName=" + this.getCourseName() + ", subjectId=" + this.getSubjectId() + ", subjectName=" + this.getSubjectName() + ", courseLevel=" + this.getCourseLevel() + ", courseLevelStr=" + this.getCourseLevelStr() + ", tagName=" + this.getTagName() + ", courseType=" + this.getCourseType() + ", courseTypeStr=" + this.getCourseTypeStr() + ", details=" + this.getDetails() + ", coursePrice=" + this.getCoursePrice() + ", status=" + this.getStatus() + ", statusStr=" + this.getStatusStr() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchCourseResp)) {
            return false;
        }
        SearchCourseResp other = (SearchCourseResp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$courseId = this.getCourseId();
        Long other$courseId = other.getCourseId();
        if (this$courseId == null ? other$courseId != null : !((Object)this$courseId).equals(other$courseId)) {
            return false;
        }
        String this$courseName = this.getCourseName();
        String other$courseName = other.getCourseName();
        if (this$courseName == null ? other$courseName != null : !this$courseName.equals(other$courseName)) {
            return false;
        }
        Long this$subjectId = this.getSubjectId();
        Long other$subjectId = other.getSubjectId();
        if (this$subjectId == null ? other$subjectId != null : !((Object)this$subjectId).equals(other$subjectId)) {
            return false;
        }
        String this$subjectName = this.getSubjectName();
        String other$subjectName = other.getSubjectName();
        if (this$subjectName == null ? other$subjectName != null : !this$subjectName.equals(other$subjectName)) {
            return false;
        }
        if (this.getCourseLevel() != other.getCourseLevel()) {
            return false;
        }
        String this$courseLevelStr = this.getCourseLevelStr();
        String other$courseLevelStr = other.getCourseLevelStr();
        if (this$courseLevelStr == null ? other$courseLevelStr != null : !this$courseLevelStr.equals(other$courseLevelStr)) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        if (this.getCourseType() != other.getCourseType()) {
            return false;
        }
        String this$courseTypeStr = this.getCourseTypeStr();
        String other$courseTypeStr = other.getCourseTypeStr();
        if (this$courseTypeStr == null ? other$courseTypeStr != null : !this$courseTypeStr.equals(other$courseTypeStr)) {
            return false;
        }
        List<CourseDetailDto> this$details = this.getDetails();
        List<CourseDetailDto> other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        Double this$coursePrice = this.getCoursePrice();
        Double other$coursePrice = other.getCoursePrice();
        if (this$coursePrice == null ? other$coursePrice != null : !((Object)this$coursePrice).equals(other$coursePrice)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$statusStr = this.getStatusStr();
        String other$statusStr = other.getStatusStr();
        return !(this$statusStr == null ? other$statusStr != null : !this$statusStr.equals(other$statusStr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchCourseResp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $courseId = this.getCourseId();
        result = result * 59 + ($courseId == null ? 43 : ((Object)$courseId).hashCode());
        String $courseName = this.getCourseName();
        result = result * 59 + ($courseName == null ? 43 : $courseName.hashCode());
        Long $subjectId = this.getSubjectId();
        result = result * 59 + ($subjectId == null ? 43 : ((Object)$subjectId).hashCode());
        String $subjectName = this.getSubjectName();
        result = result * 59 + ($subjectName == null ? 43 : $subjectName.hashCode());
        result = result * 59 + this.getCourseLevel();
        String $courseLevelStr = this.getCourseLevelStr();
        result = result * 59 + ($courseLevelStr == null ? 43 : $courseLevelStr.hashCode());
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        result = result * 59 + this.getCourseType();
        String $courseTypeStr = this.getCourseTypeStr();
        result = result * 59 + ($courseTypeStr == null ? 43 : $courseTypeStr.hashCode());
        List<CourseDetailDto> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        Double $coursePrice = this.getCoursePrice();
        result = result * 59 + ($coursePrice == null ? 43 : ((Object)$coursePrice).hashCode());
        result = result * 59 + this.getStatus();
        String $statusStr = this.getStatusStr();
        result = result * 59 + ($statusStr == null ? 43 : $statusStr.hashCode());
        return result;
    }
}

