/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.dto;

import com.baijia.wedo.common.enums.CourseStatus;
import com.baijia.wedo.common.enums.CourseType;
import com.baijia.wedo.common.enums.PhaseType;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.dal.edu.po.Course;
import org.springframework.beans.BeanUtils;

public class CourseListResp
extends IdAndNameDto {
    private Long subjectId;
    private String subjectName;
    private int courseLevel;
    private String courseLevelStr;
    private String tagName;
    private int courseType;
    private String courseTypeStr;
    private String content;
    private Double price;
    private int status;
    private String statusStr;

    public static CourseListResp convertToDto(Course source) {
        CourseListResp target = new CourseListResp();
        BeanUtils.copyProperties((Object)source, (Object)((Object)target), (String[])new String[]{"price"});
        target.setCourseLevelStr(PhaseType.get((int)source.getCourseLevel()).getLabel());
        target.setCourseTypeStr(CourseType.get((int)source.getCourseType()).getLabel());
        target.setStatusStr(CourseStatus.get((int)source.getStatus()).getLabel());
        if (source.getCourseType() == CourseType.ONEvN.getType() || source.getCourseType() == CourseType.ONEvG.getType()) {
            Long sourcePrice = source.getPrice();
            Double newPrice = BaseUtils.divided((Long)Long.parseLong(sourcePrice + ""), (Integer)100, (int)2);
            target.setPrice(newPrice);
        }
        return target;
    }

    public Long getSubjectId() {
        return this.subjectId;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public int getCourseLevel() {
        return this.courseLevel;
    }

    public String getCourseLevelStr() {
        return this.courseLevelStr;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getCourseType() {
        return this.courseType;
    }

    public String getCourseTypeStr() {
        return this.courseTypeStr;
    }

    public String getContent() {
        return this.content;
    }

    public Double getPrice() {
        return this.price;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusStr() {
        return this.statusStr;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public void setCourseLevel(int courseLevel) {
        this.courseLevel = courseLevel;
    }

    public void setCourseLevelStr(String courseLevelStr) {
        this.courseLevelStr = courseLevelStr;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setCourseType(int courseType) {
        this.courseType = courseType;
    }

    public void setCourseTypeStr(String courseTypeStr) {
        this.courseTypeStr = courseTypeStr;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatusStr(String statusStr) {
        this.statusStr = statusStr;
    }

    public String toString() {
        return "CourseListResp(subjectId=" + this.getSubjectId() + ", subjectName=" + this.getSubjectName() + ", courseLevel=" + this.getCourseLevel() + ", courseLevelStr=" + this.getCourseLevelStr() + ", tagName=" + this.getTagName() + ", courseType=" + this.getCourseType() + ", courseTypeStr=" + this.getCourseTypeStr() + ", content=" + this.getContent() + ", price=" + this.getPrice() + ", status=" + this.getStatus() + ", statusStr=" + this.getStatusStr() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CourseListResp)) {
            return false;
        }
        CourseListResp other = (CourseListResp)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$subjectId = this.getSubjectId();
        Long other$subjectId = other.getSubjectId();
        if (this$subjectId == null ? other$subjectId != null : !((Object)this$subjectId).equals(other$subjectId)) {
            return false;
        }
        String this$subjectName = this.getSubjectName();
        String other$subjectName = other.getSubjectName();
        if (this$subjectName == null ? other$subjectName != null : !this$subjectName.equals(other$subjectName)) {
            return false;
        }
        if (this.getCourseLevel() != other.getCourseLevel()) {
            return false;
        }
        String this$courseLevelStr = this.getCourseLevelStr();
        String other$courseLevelStr = other.getCourseLevelStr();
        if (this$courseLevelStr == null ? other$courseLevelStr != null : !this$courseLevelStr.equals(other$courseLevelStr)) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        if (this.getCourseType() != other.getCourseType()) {
            return false;
        }
        String this$courseTypeStr = this.getCourseTypeStr();
        String other$courseTypeStr = other.getCourseTypeStr();
        if (this$courseTypeStr == null ? other$courseTypeStr != null : !this$courseTypeStr.equals(other$courseTypeStr)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$statusStr = this.getStatusStr();
        String other$statusStr = other.getStatusStr();
        return !(this$statusStr == null ? other$statusStr != null : !this$statusStr.equals(other$statusStr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CourseListResp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $subjectId = this.getSubjectId();
        result = result * 59 + ($subjectId == null ? 43 : ((Object)$subjectId).hashCode());
        String $subjectName = this.getSubjectName();
        result = result * 59 + ($subjectName == null ? 43 : $subjectName.hashCode());
        result = result * 59 + this.getCourseLevel();
        String $courseLevelStr = this.getCourseLevelStr();
        result = result * 59 + ($courseLevelStr == null ? 43 : $courseLevelStr.hashCode());
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        result = result * 59 + this.getCourseType();
        String $courseTypeStr = this.getCourseTypeStr();
        result = result * 59 + ($courseTypeStr == null ? 43 : $courseTypeStr.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        result = result * 59 + this.getStatus();
        String $statusStr = this.getStatusStr();
        result = result * 59 + ($statusStr == null ? 43 : $statusStr.hashCode());
        return result;
    }
}

