/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.dto;

import com.baijia.wedo.common.enums.CourseType;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.dal.edu.po.Course;
import com.baijia.wedo.sal.dto.IdAndNumDto;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class CourseAddReq
extends IdAndNameDto {
    private Long subjectId;
    private int courseLevel;
    private String tagName = "";
    private int courseType;
    private int status;
    private Double price;
    private Collection<IdAndNumDto> individual;

    public void copy(Course course) {
        course.setId(super.getId());
        course.setName(super.getName());
        course.setSubjectId(this.subjectId);
        course.setCourseLevel(this.courseLevel);
        course.setTagName(this.tagName);
        course.setCourseType(this.courseType);
        course.setStatus(this.status);
        if (this.courseType == CourseType.ONEvN.getType() || this.courseType == CourseType.ONEvG.getType()) {
            course.setPrice(Long.valueOf(Long.parseLong(BaseUtils.plus((Double)this.price, (int)100) + "")));
        } else {
            course.setPrice(Long.valueOf(0L));
        }
    }

    public void validate() {
        if (CollectionUtils.isEmpty(this.individual)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u8bbe\u7f6e\u8bfe\u7a0b\u5355\u9879");
        }
        Set subTypeIds = BaseUtils.getPropertiesList(this.individual, (String)"id");
        if (subTypeIds.size() < this.individual.size()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u80fd\u91cd\u590d\u9009\u62e9\u5355\u9879");
        }
    }

    public Long getSubjectId() {
        return this.subjectId;
    }

    public int getCourseLevel() {
        return this.courseLevel;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getCourseType() {
        return this.courseType;
    }

    public int getStatus() {
        return this.status;
    }

    public Double getPrice() {
        return this.price;
    }

    public Collection<IdAndNumDto> getIndividual() {
        return this.individual;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public void setCourseLevel(int courseLevel) {
        this.courseLevel = courseLevel;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setCourseType(int courseType) {
        this.courseType = courseType;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setIndividual(Collection<IdAndNumDto> individual) {
        this.individual = individual;
    }

    public String toString() {
        return "CourseAddReq(subjectId=" + this.getSubjectId() + ", courseLevel=" + this.getCourseLevel() + ", tagName=" + this.getTagName() + ", courseType=" + this.getCourseType() + ", status=" + this.getStatus() + ", price=" + this.getPrice() + ", individual=" + this.getIndividual() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CourseAddReq)) {
            return false;
        }
        CourseAddReq other = (CourseAddReq)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$subjectId = this.getSubjectId();
        Long other$subjectId = other.getSubjectId();
        if (this$subjectId == null ? other$subjectId != null : !((Object)this$subjectId).equals(other$subjectId)) {
            return false;
        }
        if (this.getCourseLevel() != other.getCourseLevel()) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        if (this.getCourseType() != other.getCourseType()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Collection<IdAndNumDto> this$individual = this.getIndividual();
        Collection<IdAndNumDto> other$individual = other.getIndividual();
        return !(this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CourseAddReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $subjectId = this.getSubjectId();
        result = result * 59 + ($subjectId == null ? 43 : ((Object)$subjectId).hashCode());
        result = result * 59 + this.getCourseLevel();
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        result = result * 59 + this.getCourseType();
        result = result * 59 + this.getStatus();
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Collection<IdAndNumDto> $individual = this.getIndividual();
        result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
        return result;
    }
}

