/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.system.dao.impl;

import com.baijia.component.permission.enums.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.wedo.dal.system.dao.SchoolDao;
import com.baijia.wedo.dal.system.po.School;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class SchoolDaoImpl
extends JdbcTemplateDaoSupport<School>
implements SchoolDao {
    @Override
    public List<School> querySchoolByName(String name, PageDto pageDto, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.like("name", (Serializable)((Object)name), MatchMode.ANYWHERE);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public School querySchoolById(long id, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("id", (Serializable)Long.valueOf(id));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (School)this.uniqueResult(builder);
    }

    @Override
    public List<School> querySchoolByIds(Collection<Long> ids, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.in("id", ids);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<School> querySchoolByNameAndExcludeId(String name, Collection<Long> excludeIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("name", (Serializable)((Object)name));
        if (CollectionUtils.isNotEmpty(excludeIds)) {
            builder.notin("id", excludeIds);
        }
        return this.queryList(builder);
    }
}

