/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.system.dao.impl;

import com.baijia.component.permission.enums.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.wedo.common.enums.RoomStatus;
import com.baijia.wedo.dal.system.dao.RoomDetailDao;
import com.baijia.wedo.dal.system.po.RoomDetail;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class RoomDetailDaoImpl
extends JdbcTemplateDaoSupport<RoomDetail>
implements RoomDetailDao {
    @Override
    public boolean hasRoom(String name) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("name", (Serializable)((Object)name));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count != null && count > 0;
    }

    @Override
    public void removeRooms(List<Long> ids) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", ids);
        List list = this.queryList(builder);
        for (RoomDetail detail : list) {
            detail.setIsDel(DeleteStatus.DELETED.getValue());
            this.update(detail, new String[0]);
        }
    }

    @Override
    public List<RoomDetail> load(PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.setPage(pageDto);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<RoomDetail> queryRoomDetail(Long schoolId, Integer status, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (null != schoolId && 0L != schoolId) {
            builder.eq("schoolId", (Serializable)schoolId);
        }
        if (null != status && RoomStatus.contains((Integer)status)) {
            builder.eq("status", (Serializable)status);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public List<RoomDetail> getRoomsBySchoolId(long schoolId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("schoolId", (Serializable)Long.valueOf(schoolId));
        builder.eq("status", (Serializable)Integer.valueOf(RoomStatus.NORMAL.getStatus()));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public long getRoomsCountBySchoolId(long schoolId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("schoolId", (Serializable)Long.valueOf(schoolId));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Long count = (Long)this.queryForObject(builder, Long.class);
        return count == null ? 0L : count;
    }

    @Override
    public void forbidden(long id, int status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)Long.valueOf(id));
        builder.eq("isDel", (Serializable)DeleteStatus.NORMAL);
        RoomDetail detail = (RoomDetail)this.uniqueResult(builder);
        if (null != detail) {
            detail.setStatus(status);
            this.update(detail, new String[0]);
        }
    }

    @Override
    public List<RoomDetail> fuzzyQuery(String query, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            builder.like("name", (Serializable)((Object)query), MatchMode.ANYWHERE);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        builder.eq("isDel", (Serializable)DeleteStatus.NORMAL);
        return this.queryList(builder);
    }
}

