/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.system.dao.impl;

import com.baijia.component.permission.enums.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.wedo.dal.system.dao.BackLogDao;
import com.baijia.wedo.dal.system.po.BackLog;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BackLogDaoImpl
extends JdbcTemplateDaoSupport<BackLog>
implements BackLogDao {
    @Override
    public Map<Long, Long> getUserLogCount(Date startTime, Date endTime, Integer status, Collection<Long> userIds) {
        Preconditions.checkArgument((startTime != null || endTime != null ? 1 : 0) != 0, (Object)"startTime and endTime is null");
        Map params = Maps.newHashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select user_id as userId, count(id) as logCount from virgo.back_log where");
        if (startTime != null && endTime != null) {
            sql.append(" notice_time between :startTime and :endTime");
            params.put("startTime", startTime);
            params.put("endTime", endTime);
        } else if (startTime == null && endTime != null) {
            sql.append(" and noticeTime < :endTime");
            params.put("endTime", endTime);
        } else if (startTime != null && endTime == null) {
            sql.append(" and noticeTime > :startTime");
            params.put("startTime", startTime);
        }
        if (status != null) {
            sql.append(" and status = :status");
            params.put("status", status);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            sql.append(" and user_id in (:userIds )");
            params.put("userIds", userIds);
        }
        sql.append(" group by userId");
        Map userLogCountMap = (Map)this.getNamedJdbcTemplate().query(sql.toString(), params, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Long>>(){

            public Map<Long, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Long> map = new HashMap<Long, Long>();
                while (rs.next()) {
                    map.put(rs.getLong("userId"), rs.getLong("logCount"));
                }
                return map;
            }
        });
        return userLogCountMap;
    }

    @Override
    public List<BackLog> getNoticeBackLogList(Collection<Long> ids, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (CollectionUtils.isNotEmpty(ids)) {
            builder.in("id", ids);
        }
        builder.between("expireTime", (Comparable)startTime, (Comparable)endTime);
        builder.asc(new String[]{"status", "expireTime"});
        return this.queryList(builder);
    }

    @Override
    public List<BackLog> getNoticeBackLogByTarget(Integer type, long target) {
        StringBuffer sql = new StringBuffer("select bl.* from wedo.back_log bl, wedo.back_log_user_list bu where bl.id=bu.back_log_id and bu.user_id = :target");
        sql.append(" and bu.type = :type").append(" and bl.is_del=").append(DeleteStatus.NORMAL.getValue());
        sql.append(" order by expire_time asc");
        List result = Lists.newArrayList();
        Map params = Maps.newHashMap();
        params.put("target", target);
        params.put("type", type);
        result = this.getNamedJdbcTemplate().query(sql.toString(), params, (RowMapper)new RowMapper<BackLog>(){

            public BackLog mapRow(ResultSet rs, int rowNum) throws SQLException {
                BackLog backLog = new BackLog();
                backLog.setContent(rs.getString("content"));
                backLog.setCreateTime(rs.getTimestamp("create_time"));
                backLog.setCreatorId(rs.getLong("creator_id"));
                backLog.setCreatorName(rs.getString("creator_name"));
                backLog.setExpireTime(rs.getTimestamp("expire_time"));
                backLog.setId(rs.getLong("id"));
                backLog.setIsDel(rs.getInt("is_del"));
                backLog.setNoticeTime(rs.getTimestamp("notice_time"));
                backLog.setNoticeType(rs.getInt("notice_type"));
                backLog.setOrigin(rs.getInt("origin"));
                backLog.setPriorityType(rs.getInt("priority_type"));
                backLog.setStatus(rs.getInt("status"));
                backLog.setTitle(rs.getString("title"));
                backLog.setType(rs.getInt("type"));
                backLog.setUserId(rs.getLong("user_id"));
                return backLog;
            }
        });
        return result;
    }

    @Override
    public BackLog getRecentBackLog(int type, long targetId) {
        StringBuffer sql = new StringBuffer("select bl.* from wedo.back_log bl, wedo.back_log_user_list bu where bl.id=bu.back_log_id and bu.user_id = :target");
        sql.append(" and bu.type = :type").append(" and bl.expire_time>=:currTime").append(" and bl.is_del=").append(DeleteStatus.NORMAL.getValue());
        sql.append(" order by expire_time asc limit 1");
        Map params = Maps.newHashMap();
        params.put("target", targetId);
        params.put("type", type);
        params.put("currTime", new Date());
        List result = this.getNamedJdbcTemplate().query(sql.toString(), params, (RowMapper)new RowMapper<BackLog>(){

            public BackLog mapRow(ResultSet rs, int rowNum) throws SQLException {
                BackLog backLog = new BackLog();
                backLog.setContent(rs.getString("content"));
                backLog.setCreateTime(rs.getTimestamp("create_time"));
                backLog.setCreatorId(rs.getLong("creator_id"));
                backLog.setCreatorName(rs.getString("creator_name"));
                backLog.setExpireTime(rs.getTimestamp("expire_time"));
                backLog.setId(rs.getLong("id"));
                backLog.setIsDel(rs.getInt("is_del"));
                backLog.setNoticeTime(rs.getTimestamp("notice_time"));
                backLog.setNoticeType(rs.getInt("notice_type"));
                backLog.setOrigin(rs.getInt("origin"));
                backLog.setPriorityType(rs.getInt("priority_type"));
                backLog.setStatus(rs.getInt("status"));
                backLog.setTitle(rs.getString("title"));
                backLog.setType(rs.getInt("type"));
                backLog.setUserId(rs.getLong("user_id"));
                return backLog;
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            return (BackLog)result.get(0);
        }
        return null;
    }

    @Override
    public void transferBackLogToClue(long sourceClueId, long targetClueId) {
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.back_log_user_list set user_id=:targetClueId where user_id=:sourceClueId and type=:backLogType");
        Map params = Maps.newHashMap();
        params.put("targetClueId", targetClueId);
        params.put("sourceClueId", sourceClueId);
        params.put("backLogType", 1);
        this.getNamedJdbcTemplate().update(sql.toString(), params);
    }
}

