/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util.http;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.wedo.common.util.HttpClientUtils;
import com.baijia.wedo.common.util.PropertiesReader;
import com.baijia.wedo.common.util.encrypt.HMACUtils;
import com.baijia.wedo.common.util.sms.RestfulResult;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSXService {
    private static final Logger logger = LoggerFactory.getLogger(GSXService.class);
    private static final String CHAR_SET = "UTF-8";
    private static final String CONNECTOR = "-";
    private static final long EXPIRE_TIME = 300000L;
    public static volatile String authToken = null;
    public static volatile long loginTime = -1L;
    public static final String appId;
    public static final String appKey;
    public static final String url;

    public static <T> RestfulResult<T> doService(String controller, String action, SortedMap<String, String> params) {
        try {
            String token = GSXService.requestAuthToken();
            int timestamp = (int)(System.currentTimeMillis() / 1000L);
            params.put("app_id", appId);
            params.put("auth_token", token);
            params.put("timestamp", String.valueOf(timestamp));
            String response = GSXService.request(controller, action, params);
            logger.info("response:{}", (Object)response);
            if (StringUtils.isBlank((CharSequence)response)) {
                return null;
            }
            RestfulResult result = (RestfulResult)JacksonUtil.str2Obj((String)response, RestfulResult.class);
            return result;
        }
        catch (Exception e) {
            logger.warn("call webservice catch error:{}", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    private static String requestAuthToken() {
        if (loginTime - System.currentTimeMillis() < 300000L && authToken != null) {
            return authToken;
        }
        String controller = "auth";
        String action = "login";
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("app_id", appId);
        params.put("app_key", appKey);
        params.put("timestamp", String.valueOf(timestamp));
        String response = GSXService.request("auth", "login", params);
        logger.info("response:{}", (Object)response);
        if (StringUtils.isBlank((CharSequence)response)) {
            throw new IllegalStateException("request auth token is null, " + ((Object)params).toString());
        }
        try {
            Map json = (Map)JacksonUtil.str2Obj((String)response, Map.class);
            Number code = (Number)json.get("code");
            if (code.intValue() != 0) {
                throw new WebServiceException("auth failed - app_id:" + appId + ", app_key:" + appKey);
            }
            Map tokenMap = (Map)json.get("data");
            authToken = (String)tokenMap.get("auth_token");
            loginTime = System.currentTimeMillis();
            return authToken;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String request(String controller, String action, SortedMap<String, String> params) {
        String reqUrl = url + "/" + controller + "/" + action;
        StringBuilder signSb = new StringBuilder();
        signSb.append(RequestMethod.POST.getMethod()).append(CONNECTOR).append(controller).append(CONNECTOR).append(action);
        for (String key : params.keySet()) {
            String value = (String)params.get(key);
            signSb.append(CONNECTOR).append(value);
        }
        try {
            String sign = HMACUtils.encrypt(signSb.toString().getBytes(CHAR_SET), appKey.toString().getBytes(CHAR_SET));
            params.put("sign", sign);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        long t1 = System.currentTimeMillis();
        String response = HttpClientUtils.doPost(reqUrl, params);
        long t2 = System.currentTimeMillis();
        logger.info("request - url:{}, params:{}, time:{}", new Object[]{reqUrl, params, t2 - t1});
        return response;
    }

    static {
        Properties properties = PropertiesReader.getProperties("rest.properties");
        appId = properties.getProperty("webservice.app_id");
        appKey = properties.getProperty("webservice.app_key");
        url = properties.getProperty("webservice.url");
    }

    public static enum RequestMethod {
        GET("get"),
        POST("post");

        private String method;

        private RequestMethod(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

