/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util.http;

import java.util.Calendar;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieWrapper {
    private HttpServletRequest request;
    private HttpServletResponse response;

    public CookieWrapper(HttpServletRequest req, HttpServletResponse res) {
        this.request = req;
        this.response = res;
    }

    public String getCookieValue(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie cookie = null;
        for (int i = 0; i < cookies.length; ++i) {
            cookie = cookies[i];
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie cookie = null;
        for (int i = 0; i < cookies.length; ++i) {
            cookie = cookies[i];
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public void setCookie(String name, String value, String domain, int expire) {
        Cookie cookie = new Cookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath("/");
        if (expire >= 0) {
            cookie.setMaxAge(expire);
        }
        this.response.addCookie(cookie);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, String domain, Integer expire) {
        Cookie cookie = new Cookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath("/");
        if (expire != null && expire >= 0) {
            cookie.setMaxAge(expire.intValue());
        }
        response.addCookie(cookie);
    }

    public void clearCookie(String name, String domain) {
        this.setCookie(name, "", domain, 0);
    }

    public static void clearCookie(HttpServletResponse response, String name, String domain) {
        CookieWrapper.setCookie(response, name, "", domain, 0);
    }

    public void clearAllCookie() {
        Cookie[] cookies = this.request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            cookies[i].setValue(null);
        }
    }

    public void clearAllCookie(HttpServletRequest req, HttpServletResponse res) {
        Cookie[] cookies = req.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            cookies[i].setValue(null);
        }
    }

    public String getCookieDomain(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie cookie = null;
        for (int i = 0; i < cookies.length; ++i) {
            cookie = cookies[i];
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie.getDomain();
        }
        return null;
    }

    public static String getCookieDomain(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie cookie = null;
        for (int i = 0; i < cookies.length; ++i) {
            cookie = cookies[i];
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie.getDomain();
        }
        return null;
    }

    public Cookie getCookie(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie cookie = null;
        for (int i = 0; i < cookies.length; ++i) {
            cookie = cookies[i];
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie;
        }
        return null;
    }

    public static Cookie getCookie(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie cookie = null;
        for (int i = 0; i < cookies.length; ++i) {
            cookie = cookies[i];
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie;
        }
        return null;
    }

    public static boolean isCookieExpire(String strDate, int minutes) {
        Calendar c = Calendar.getInstance();
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(5, 7)) - 1;
        int day = Integer.parseInt(strDate.substring(8, 10));
        int hour = Integer.parseInt(strDate.substring(11, 13));
        int minute = Integer.parseInt(strDate.substring(14, 16));
        int second = Integer.parseInt(strDate.substring(17));
        c.set(year, month, day, hour, minute, second);
        c.add(12, minutes);
        return c.before(Calendar.getInstance());
    }
}

