/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util.encrypt;

import com.baijia.wedo.common.util.JacksonUtil;
import com.google.common.base.Splitter;
import com.google.common.io.BaseEncoding;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public class EncryptUtils {
    private static final Charset charset_cp437 = Charset.forName("cp437");
    private static final Charset charset_utf8 = Charset.forName("utf8");

    public static String base64Decode(String src, Charset cst) {
        if (StringUtils.isBlank((String)src)) {
            return "";
        }
        String deStr = src.replace('-', '+').replace('_', '/');
        return new String(BaseEncoding.base64().decode((CharSequence)deStr), cst);
    }

    public static String strDecode(String token) {
        String src = EncryptUtils.base64Decode(token, charset_cp437);
        char factor = src.charAt(0);
        int c = factor % 8;
        String entity = src.substring(1);
        List slice = Splitter.fixedLength((int)factor).splitToList((CharSequence)entity);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); ++i) {
            byte[] chars = ((String)slice.get(i)).getBytes(charset_cp437);
            for (int j = 0; j < chars.length; ++j) {
                byte ch = chars[j];
                int t = ch - c - i;
                if (t < 0) {
                    t += 256;
                }
                sb.append((char)t);
            }
        }
        return EncryptUtils.base64Decode(sb.toString(), charset_utf8);
    }

    public static String base64EncodeStrWithFactor(Object obj) {
        return EncryptUtils.base64EncodeStrWithFactor(JacksonUtil.obj2Str(obj));
    }

    public static String base64EncodeStrWithFactor(String data) {
        data = EncryptUtils.base64Encode(data, charset_utf8);
        Random random = new Random();
        int factor = random.nextInt((int)Math.min(255.0, Math.ceil(data.length() / 3))) + 1;
        int c = factor % 8;
        List slice = Splitter.fixedLength((int)factor).splitToList((CharSequence)data);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); ++i) {
            byte[] chars = ((String)slice.get(i)).getBytes(charset_cp437);
            for (int j = 0; j < chars.length; ++j) {
                byte ch = chars[j];
                byte t = (byte)(ch + c + i);
                sb.append(new String(new byte[]{t}, charset_cp437));
            }
        }
        String token = EncryptUtils.base64Encode(factor, sb.toString(), charset_cp437);
        return token;
    }

    public static String base64Encode(int factor, String src, Charset cst) {
        if (StringUtils.isBlank((String)src)) {
            return "";
        }
        src = (char)factor + src;
        String deStr = BaseEncoding.base64().encode(src.getBytes(cst));
        String result = deStr.replace('+', '-').replace('/', '_');
        while (result.endsWith("=")) {
            result = result.substring(0, result.length() - 1).toString();
        }
        return result;
    }

    public static String base64Encode(String src, Charset cst) {
        if (StringUtils.isBlank((String)src)) {
            return "";
        }
        String deStr = BaseEncoding.base64().encode(src.getBytes(cst));
        String result = deStr.replace('+', '-').replace('/', '_');
        while (result.endsWith("=")) {
            result = result.substring(0, result.length() - 1).toString();
        }
        return result;
    }

    public static String strEncode(String jsonParams) throws Exception {
        String str = JacksonUtil.obj2Str(jsonParams);
        return EncryptUtils.base64EncodeStrWithFactor(str);
    }

    public static void main(String[] args) {
        String hash = "An0kbGcmPj4xKHt6bHpaeHVvLEU8OC58f3VXczFKfoZ9fo8";
        System.out.println(EncryptUtils.strDecode(hash));
        String encode = "AyV-XyZtaGEnPz4yYil8em16Wnh1bmYsRDw3Zy57fnRWcWowSD-MMQ";
        System.out.println(EncryptUtils.base64Decode(encode, charset_cp437));
        System.out.println(EncryptUtils.strDecode("EGV5SnBaQ0k2T0RBc0ltNWhjWFZqUGpNbWxba211N1lteE1Da05FTDNlNFh7V287dV1WTDlQVnpsZVo8bGRae29NbnR5aFt8d2pV"));
    }
}

