/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util;

import com.alibaba.fastjson.JSONObject;
import com.baijia.wedo.common.util.JacksonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebCommonUtil {
    private static Logger logger = LoggerFactory.getLogger(WebCommonUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnMessage(HttpServletResponse response, String content) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        PrintWriter pWriter = null;
        try {
            pWriter = response.getWriter();
            pWriter.write(content);
        }
        catch (IOException e) {
            logger.error("returnMessage", (Throwable)e);
        }
        finally {
            if (pWriter != null) {
                pWriter.flush();
                pWriter.close();
            }
        }
    }

    public static void returnMessageForJSON(HttpServletResponse response, JSONObject data) {
        WebCommonUtil.returnMessage(response, data.toString());
    }

    public static void returnMessageForMapData(HttpServletResponse response, Map dataMap) {
        WebCommonUtil.returnMessage(response, JacksonUtil.obj2Str(dataMap));
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("x-requested-with");
        if (StringUtils.isEmpty((CharSequence)requestedWith)) {
            return false;
        }
        return StringUtils.isNotEmpty((CharSequence)requestedWith) && requestedWith.equals("XMLHttpRequest");
    }

    public static String getRemoteIp(HttpServletRequest request) {
        String remoteIp = request.getHeader("x-forwarded-for");
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("X-Real-IP");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("Proxy-Client-IP");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("WL-Proxy-Client-IP");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("HTTP_CLIENT_IP");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getRemoteAddr();
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getRemoteHost();
        }
        if (remoteIp != null && remoteIp.indexOf(",") != -1) {
            remoteIp = remoteIp.substring(remoteIp.lastIndexOf(",") + 1, remoteIp.length()).trim();
        }
        return remoteIp;
    }
}

