/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestContext {
    private static final String REQUEST = "httprequest";
    private static final String RESPONSE = "httpresponse";
    public static final String REQUEST_ID = "request-id";
    private static final InheritableThreadLocal<Map<String, Object>> threadLocal = new InheritableThreadLocal();

    public static void clean() {
        Map map = (Map)threadLocal.get();
        if (map != null) {
            map.clear();
        }
    }

    public static HttpServletRequest getOriginHttpRequest() {
        Map map = (Map)threadLocal.get();
        if (map != null) {
            return (HttpServletRequest)map.get(REQUEST);
        }
        return null;
    }

    public static HttpServletResponse getOriginHttpResponse() {
        Map map = (Map)threadLocal.get();
        if (map != null) {
            return (HttpServletResponse)map.get(RESPONSE);
        }
        return null;
    }

    private static void setOriginHttpRequest(HttpServletRequest request) {
        HashMap<String, HttpServletRequest> map = (HashMap<String, HttpServletRequest>)threadLocal.get();
        if (map == null) {
            map = new HashMap<String, HttpServletRequest>();
        }
        map.put(REQUEST, request);
        threadLocal.set(map);
    }

    private static void setOriginHttpResponse(HttpServletResponse response) {
        HashMap<String, HttpServletResponse> map = (HashMap<String, HttpServletResponse>)threadLocal.get();
        if (map == null) {
            map = new HashMap<String, HttpServletResponse>();
        }
        map.put(RESPONSE, response);
        threadLocal.set(map);
    }

    public static String getRequestId() {
        String requestId = RequestContext.getOriginHttpResponse() == null ? "" : RequestContext.getOriginHttpResponse().getHeader(REQUEST_ID);
        return requestId == null ? "" : requestId;
    }

    public static void init(HttpServletRequest request, HttpServletResponse response) {
        RequestContext.clean();
        RequestContext.setOriginHttpRequest(request);
        RequestContext.setOriginHttpResponse(response);
    }
}

