/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util;

import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.OneCourseTestRespDto;
import com.baijia.wedo.common.util.JacksonUtil;
import com.baijia.wedo.common.util.PropertiesReader;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneCourseUtils {
    private static final Logger log = LoggerFactory.getLogger(OneCourseUtils.class);
    private static String ONE_COURSE_KEY = "";
    private static String ONE_COURSE_SECRET = "";
    private static String ONE_COURSE_API = "";

    public static String getSignature(String data, String key) throws Exception {
        byte[] keyBytes = key.getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data.getBytes());
        return OneCourseUtils.byteToBase64String(rawHmac);
    }

    private static String byteToBase64String(byte[] ib) {
        return Base64.encodeBase64String((byte[])ib);
    }

    private static String getRFC1123Time(Date date) {
        SimpleDateFormat fm = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        fm.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fm.format(date);
    }

    public static OneCourseTestRespDto getTestResult(String param) {
        try {
            String key = ONE_COURSE_KEY;
            String secret = ONE_COURSE_SECRET;
            String date = OneCourseUtils.getRFC1123Time(new Date());
            String source = String.format("%s\n%s", date, param);
            String sign = OneCourseUtils.getSignature(source, secret);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(ONE_COURSE_API);
            httpPost.setHeader("Key", key);
            httpPost.setHeader("Date", date);
            httpPost.setHeader("Sign", sign);
            StringEntity entity = new StringEntity(param, Charset.forName("UTF-8"));
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("getTestResult.params:{}, result:{}", (Object)param, (Object)result);
            return OneCourseUtils.parseResult(result);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("getTestResult faled, params:{}, e:{}", (Object)param, (Object)e);
            return null;
        }
    }

    static OneCourseTestRespDto parseResult(String result) throws JsonParseException, JsonMappingException, IOException {
        if (StringUtils.isNotBlank((CharSequence)result)) {
            OneCourseTestRespDto ret = JacksonUtil.str2Obj(result, OneCourseTestRespDto.class);
            return ret;
        }
        return null;
    }

    public static void main(String[] args) {
        HashMap params = Maps.newHashMap();
        params.put("uId", "\u5f90\u9e7f\u9e23");
        params.put("pageIndex", "1");
        params.put("pageSize", "20");
        System.out.println(OneCourseUtils.getTestResult(JacksonUtil.obj2Str(params)));
    }

    static {
        Properties properties = PropertiesReader.getProperties("one_course.properties");
        if (properties != null) {
            ONE_COURSE_KEY = properties.getProperty("one_course_key");
            ONE_COURSE_SECRET = properties.getProperty("one_course_secret");
            ONE_COURSE_API = properties.getProperty("one_course_api");
        }
    }
}

