/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util;

import com.baijia.wedo.common.annotation.LoginNeedless;
import com.baijia.wedo.common.cache.CacheClient;
import com.baijia.wedo.common.constant.TianXiaoConstant;
import com.baijia.wedo.common.enums.PermissionCode;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.util.AES;
import com.baijia.wedo.common.util.http.CookieWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;

public class LoginUtil {
    private static final Logger log = LoggerFactory.getLogger(LoginUtil.class);
    private static final Logger logger = LoggerFactory.getLogger(LoginUtil.class);
    public static final ThreadLocal<BaseLoginUser> currentUser = new InheritableThreadLocal<BaseLoginUser>();

    public static String getCookieValue(HttpServletRequest req, HttpServletResponse res, String cookieName) {
        String value = CookieWrapper.getCookieValue(req, cookieName);
        return value;
    }

    public static void setCurrentUser(BaseLoginUser user) {
        currentUser.set(user);
    }

    public static BaseLoginUser getCurrentUser() {
        BaseLoginUser loginUser = currentUser.get();
        return loginUser;
    }

    public static boolean hasLoginNeedless(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class type = handlerMethod.getBeanType();
        LoginNeedless loginNeedless = type.getAnnotation(LoginNeedless.class);
        if (loginNeedless == null) {
            loginNeedless = type.getSuperclass().getAnnotation(LoginNeedless.class);
        }
        if (loginNeedless == null) {
            loginNeedless = (LoginNeedless)handlerMethod.getMethodAnnotation(LoginNeedless.class);
        }
        return loginNeedless != null;
    }

    public static void initCurrentUser(HttpServletRequest req, CacheClient loginCache) {
        Object user;
        String key = CookieWrapper.getCookieValue(req, "botai_front_ut");
        if (StringUtils.isNotBlank((CharSequence)key) && (user = loginCache.get(key)) != null) {
            if (user instanceof BaseLoginUser) {
                BaseLoginUser baseUser = (BaseLoginUser)user;
                LoginUtil.setCurrentUser(baseUser);
                loginCache.set(key, user, TianXiaoConstant.FRONT_SESSION_TIMEOUT);
            } else {
                logger.error("The user is not front system.");
            }
        }
    }

    public static void refreshUserCache(HttpServletRequest req, CacheClient defultCache, BaseLoginUser baseUser) {
        String key = req.getParameter("botai_front_ut");
        LoginUtil.setCurrentUser(baseUser);
        defultCache.set(key, baseUser, TianXiaoConstant.FRONT_SESSION_TIMEOUT);
    }

    public static void initCurrentApiUser(HttpServletRequest req, CacheClient loginCache) {
        Object user;
        String key = req.getParameter("botai_front_ut");
        if (StringUtils.isBlank((CharSequence)key)) {
            key = CookieWrapper.getCookieValue(req, "botai_front_ut");
        }
        if (StringUtils.isNotBlank((CharSequence)key) && (user = loginCache.get(key)) != null) {
            if (user instanceof BaseLoginUser) {
                BaseLoginUser baseUser = (BaseLoginUser)user;
                LoginUtil.setCurrentUser(baseUser);
                loginCache.set(key, user, TianXiaoConstant.FRONT_SESSION_TIMEOUT);
            } else {
                logger.error("The user is not front system.");
            }
        }
    }

    public static void removeCurrentApiUser(HttpServletRequest request, HttpServletResponse response, CacheClient loginCache, String domain) {
        String key = request.getParameter("botai_front_ut");
        if (StringUtils.isBlank((CharSequence)key)) {
            key = CookieWrapper.getCookieValue(request, "botai_front_ut");
        }
        if (StringUtils.isNotBlank((CharSequence)key)) {
            loginCache.delete(key);
            CookieWrapper.clearCookie(response, "botai_front_ut", domain);
        }
    }

    public static long timeout(BaseLoginUser autoLogin) {
        long timeout = TianXiaoConstant.FRONT_SESSION_TIMEOUT;
        return timeout;
    }

    public static int expire(BaseLoginUser autoLogin) {
        int expire = -1;
        return expire;
    }

    public static String getLoginTokenBaseKey(long userId) throws Exception {
        String key = AES.Encrypt(userId + "", "QAQWSXCDERFVBGTY");
        return key;
    }

    public static boolean hasPermission(PermissionCode permission) {
        BaseLoginUser loginUser = currentUser.get();
        return loginUser != null && CollectionUtils.isNotEmpty(loginUser.getPermissions()) && loginUser.getPermissions().contains(permission.getName());
    }
}

