/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util;

import com.baijia.wedo.common.util.RequestContext;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static Logger request = LoggerFactory.getLogger((String)"request");
    private static Logger info = LoggerFactory.getLogger((String)"info");
    private static Logger error = LoggerFactory.getLogger((String)"error");
    private static final String requestFormat = "%s %s %s %s %s %s";
    private static final String errorFormat = "%s %s";

    public static void request(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String message, long costTime) {
        request.info(String.format(requestFormat, RequestContext.getRequestId(), httpRequest.getRequestURI(), httpResponse.getStatus(), costTime, LogUtils.getParams(httpRequest), message));
    }

    private static String getParams(HttpServletRequest httpRequest) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration paramNames = httpRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramValue;
            String paramName = (String)paramNames.nextElement();
            String[] paramValues = httpRequest.getParameterValues(paramName);
            if (paramValues.length != 1 || (paramValue = paramValues[0]).length() == 0) continue;
            map.put(paramName, paramValue);
        }
        Set set = map.entrySet();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : set) {
            sb.append(entry.getKey() + "=" + entry.getValue() + "&");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void info(String message) {
        info.info(message);
    }

    public static void error(String message) {
        error.error(message);
    }

    public static void error(String message, Throwable e) {
        error.error(String.format(errorFormat, RequestContext.getRequestId(), message), e);
    }
}

