/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util;

import com.beust.jcommander.internal.Maps;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;

public class FileUtil {
    public static boolean mkdir(String f) throws Exception {
        File file = new File(f);
        file.mkdir();
        return true;
    }

    public static boolean delete(String f) throws Exception {
        File file = new File(f);
        file.delete();
        return true;
    }

    public static String read(String file) throws Exception {
        return FileUtil.read(file, System.getProperty("file.encoding"));
    }

    public static String read(InputStream in) throws Exception {
        return FileUtil.read(in, System.getProperty("file.encoding"));
    }

    public static String read(InputStream in, String encoding) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader(in, encoding));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String read(String file, String encoding) throws Exception {
        try (BufferedInputStream result = null;){
            int conlen;
            result = new BufferedInputStream(new FileInputStream(file));
            byte[] cont = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((conlen = result.read(cont)) >= 0) {
                baos.write(cont, 0, conlen);
            }
            if (encoding != null) {
                String string = new String(baos.toByteArray(), encoding);
                return string;
            }
            String string = new String(baos.toByteArray());
            return string;
        }
    }

    public static boolean write(String f, String s, boolean append) throws Exception {
        return FileUtil.write(f, s.getBytes(), append);
    }

    public static boolean write(String f, String s) throws Exception {
        return FileUtil.write(f, s.getBytes(), false);
    }

    public static boolean write(String f, byte[] b) throws Exception {
        return FileUtil.write(f, b, false);
    }

    public static boolean write(String f, byte[] b, boolean append) throws Exception {
        try (FileOutputStream fos = null;){
            File file = new File(FileUtil.getPath(f));
            if (!file.exists()) {
                file.mkdirs();
            }
            fos = new FileOutputStream(f, append);
            fos.write(b);
            boolean bl = true;
            return bl;
        }
    }

    public static Object readObject(String file) throws Exception {
        try (ObjectInputStream ois = null;){
            Object obj;
            ois = new ObjectInputStream(new FileInputStream(file));
            Object object = obj = ois.readObject();
            return object;
        }
    }

    public static boolean writeObject(String f, Object o) throws Exception {
        try (ObjectOutputStream oos = null;){
            File file = new File(FileUtil.getPath(f));
            if (!file.exists()) {
                file.mkdirs();
            }
            oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(o);
            boolean bl = true;
            return bl;
        }
    }

    public static boolean writeGZIPFile(String f, String s) throws Exception {
        return FileUtil.writeGZIPFile(f, s.getBytes());
    }

    public static boolean writeGZIPFile(String f, byte[] b) throws Exception {
        try (DeflaterOutputStream fos = null;){
            File file = new File(FileUtil.getPath(f));
            if (!file.exists()) {
                file.mkdirs();
            }
            fos = new GZIPOutputStream(new FileOutputStream(f));
            fos.write(b);
            boolean bl = true;
            return bl;
        }
    }

    public static String getExtension(String file) {
        String extName = "";
        int idx = file.lastIndexOf(".");
        if (idx > 0) {
            extName = new String(file.substring(idx + 1));
        }
        return extName.trim();
    }

    public static String getFormatedExtension(String file) {
        return FileUtil.getExtension(file).toLowerCase();
    }

    private static String getPath(String f) {
        return f.substring(0, f.lastIndexOf(File.separator));
    }

    public static byte[] readBytes(InputStream in) throws Exception {
        byte[] b = new byte[1024];
        try (ByteArrayOutputStream baos = null;){
            byte[] var6;
            int len1;
            baos = new ByteArrayOutputStream();
            while ((len1 = in.read(b)) > 0) {
                baos.write(b, 0, len1);
            }
            byte[] byArray = var6 = baos.toByteArray();
            return byArray;
        }
    }

    public static String getLowercaseExt(String file) {
        return FileUtil.getExt(file).toLowerCase();
    }

    public static String getExt(String file) {
        String ext = "";
        int idx = file.lastIndexOf(".");
        if (idx > 0) {
            ext = new String(file.substring(idx + 1)).trim();
        }
        return ext;
    }

    public static String getFilePath(String f) {
        String path = "";
        int idx = f.lastIndexOf(File.separator);
        if (idx > 0) {
            path = new String(f.substring(0, idx)).trim();
        }
        return path;
    }

    public static boolean exists(String f) {
        File file = new File(f);
        return file.exists();
    }

    public static void main(String[] args) throws Exception {
        Map sub;
        String file = "/Users/zhangbing/Desktop/xmind/look_new.txt";
        StringBuffer sb = new StringBuffer("");
        FileReader reader = new FileReader(file);
        BufferedReader br = new BufferedReader(reader);
        String str = null;
        Map minCache = Maps.newHashMap();
        while ((str = br.readLine()) != null) {
            String[] arr = str.split(",");
            String min = arr[0].substring(0, 2);
            if (arr[1].contains("-") || StringUtils.isEmpty((CharSequence)arr[1])) continue;
            Integer time = (int)(Double.parseDouble(arr[1]) * 1000.0);
            if (minCache.containsKey(min)) {
                sub = (Map)minCache.get(min);
                Integer old = (Integer)((Map)minCache.get(min)).get("time") + time;
                int count = (Integer)((Map)minCache.get(min)).get("count") + 1;
                sub.put("time", old);
                sub.put("count", count);
                minCache.put(min, sub);
                continue;
            }
            sub = Maps.newHashMap();
            sub.put("time", time);
            sub.put("count", 1);
            minCache.put(min, sub);
        }
        String f = "/Users/zhangbing/Desktop/xmind/houly_time.csv";
        for (String key : minCache.keySet()) {
            sub = (Map)minCache.get(key);
            int count = (Integer)sub.get("count");
            int t = (Integer)sub.get("time");
            String line = key + "," + t / count + "\n";
            FileUtil.write(f, line, true);
        }
        br.close();
        reader.close();
    }
}

