/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.util;

import com.baijia.wedo.common.annotation.EnumAnnotation;
import com.baijia.wedo.common.annotation.ReverseEnumAnnotation;
import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public interface EnumCommon {
    public int getCode();

    public String getMsg();

    public static <E extends Enum<?>> String getMsgByCode(Class<E> enumClass, int code) {
        try {
            for (EnumCommon enu : (EnumCommon[])enumClass.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                if (code != enu.getCode()) continue;
                return enu.getMsg();
            }
        }
        catch (Exception e) {
            throw new BusinessException(WedoErrorCode.PARAM_ERROR, "\u679a\u4e3e\u503c\u9519\u8bef");
        }
        return "";
    }

    public static <E extends Enum<?>> int getCodeByMsg(Class<E> enumClass, String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return 0;
        }
        try {
            for (EnumCommon enu : (EnumCommon[])enumClass.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                if (!msg.equals(enu.getMsg())) continue;
                return enu.getCode();
            }
        }
        catch (Exception e) {
            throw new BusinessException(WedoErrorCode.PARAM_ERROR, "\u679a\u4e3e\u8bf4\u660e\u9519\u8bef");
        }
        return 0;
    }

    public static <T> void fillEnumMsg(T t) {
        if (t == null) {
            return;
        }
        try {
            Class<?> superClass = t.getClass();
            HashMap<String, Field> map = new HashMap<String, Field>();
            do {
                Field[] fields;
                for (Field field : fields = superClass.getDeclaredFields()) {
                    map.put(field.getName(), field);
                }
            } while ((superClass = superClass.getSuperclass()) != null);
            for (Field field : map.values()) {
                EnumAnnotation anno = field.getAnnotation(EnumAnnotation.class);
                if (anno == null) continue;
                field.setAccessible(true);
                Object code = field.get(t);
                Field destField = (Field)map.get(anno.propName());
                if (destField == null) continue;
                String msg = EnumCommon.getMsgByCode(anno.enumClass(), (Integer)code);
                destField.setAccessible(true);
                destField.set(t, msg);
            }
        }
        catch (Exception e) {
            throw new BusinessException(CommonErrorCode.BUSINESS_ERROR, "\u679a\u4e3e\u503c\u8f6c\u6362\u5931\u8d25");
        }
    }

    public static <T> void fillEnumCode(T t) {
        if (t == null) {
            return;
        }
        try {
            Class<?> superClass = t.getClass();
            HashMap<String, Field> map = new HashMap<String, Field>();
            do {
                Field[] fields;
                for (Field field : fields = superClass.getDeclaredFields()) {
                    map.put(field.getName(), field);
                }
            } while ((superClass = superClass.getSuperclass()) != null);
            for (Field field : map.values()) {
                ReverseEnumAnnotation anno = field.getAnnotation(ReverseEnumAnnotation.class);
                if (anno == null) continue;
                field.setAccessible(true);
                Object msg = field.get(t);
                Field destField = (Field)map.get(anno.prop());
                if (destField == null) continue;
                Integer code = EnumCommon.getCodeByMsg(anno.enumClass(), (String)msg);
                destField.setAccessible(true);
                destField.set(t, code);
            }
        }
        catch (Exception e) {
            throw new BusinessException(CommonErrorCode.BUSINESS_ERROR, "\u679a\u4e3e\u503c\u8f6c\u6362\u5931\u8d25");
        }
    }
}

