/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.errorcode;

import com.baijia.wedo.common.errorcode.ErrorSide;
import com.baijia.wedo.common.errorcode.Platform;
import com.baijia.wedo.common.errorcode.Subsystem;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;

public enum CommonErrorCode implements UniverseErrorCode
{
    UNKNOW(ErrorSide.UNKNOW, Subsystem.UNKNOW, Platform.UNKNOW, 1, "\u672a\u77e5\u7c7b\u578b\u9519\u8bef"),
    PARAM_ERROR(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 400, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5"),
    REQUIRE_PARAM(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 401, "\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570"),
    SIGN_INVALIDATE(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 402, "\u53c2\u6570\u68c0\u9a8c\u4e0d\u901a\u8fc7"),
    INVALIDATE_CLIENTID(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 403, "clientId\u4e0d\u5408\u6cd5"),
    TOKEN_ERROR(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 408, "TOKEN\u4e0d\u5408\u6cd5"),
    NO_LOGIN(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 500, "\u7528\u6237\u672a\u767b\u5f55"),
    REQUEST_EXCEED(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 300, "\u8d85\u51fa\u8bf7\u6c42\u6b21\u6570\u9650\u5236"),
    NOT_FOUND(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 404, "\u6240\u8bf7\u6c42\u8d44\u6e90\u4e0d\u5b58\u5728"),
    IO_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 600, "\u540e\u53f0\u5904\u7406IO\u5f02\u5e38"),
    NOT_EXISTS_OR_DELETED(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 666, "\u8d44\u6e90\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"),
    PERMISSION_DENY(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 700, "\u65e0\u8bf7\u6c42\u8be5\u8d44\u6e90\u6743\u9650"),
    BUSINESS_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 800, "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38"),
    SYSTEM_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 9999, "\u7cfb\u7edf\u5904\u7406\u5f02\u5e38");

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private CommonErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    @Override
    public ErrorSide getErrorSide() {
        return this.errorSide;
    }

    @Override
    public Subsystem getSystem() {
        return this.subsystem;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public CommonErrorCode fromCode(int code) {
        for (CommonErrorCode errorCode : CommonErrorCode.values()) {
            if (errorCode.getSubsystemErrorCode() != code) continue;
            return errorCode;
        }
        return UNKNOW;
    }
}

