/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum YesOrNoType {
    YES(1, "\u662f"),
    NO(2, "\u5426"),
    OTHER(3, "\u5176\u4ed6");

    private static Map<Integer, YesOrNoType> cache;
    private int type;
    private String label;

    private YesOrNoType(int type, String label) {
        this.type = type;
        this.label = label;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static YesOrNoType get(int type) {
        return cache.get(type);
    }

    public static boolean contains(int type) {
        return cache.containsKey(type);
    }

    public static YesOrNoType getByType(Integer type) {
        return cache.get(type);
    }

    public static String getLableByType(Integer type) {
        YesOrNoType yesOrNoType = cache.get(type);
        return yesOrNoType == null ? null : yesOrNoType.getLabel();
    }

    public static YesOrNoType getByLable(String label) {
        for (YesOrNoType yesOrNoType : YesOrNoType.values()) {
            if (!yesOrNoType.getLabel().endsWith(label)) continue;
            return yesOrNoType;
        }
        return null;
    }

    static {
        cache = Maps.newHashMap();
        for (YesOrNoType yesOrNoType : YesOrNoType.values()) {
            cache.put(yesOrNoType.type, yesOrNoType);
        }
    }
}

