/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum UserStatus {
    NORMAL(0, "\u6b63\u5e38"),
    DELETED(1, "\u5220\u9664"),
    DISABLED(2, "\u7981\u7528");

    private int status;
    private String label;

    private UserStatus(int status, String label) {
        this.status = status;
        this.label = label;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static UserStatus fromStatus(int status) {
        for (UserStatus statusType : UserStatus.values()) {
            if (statusType.getStatus() != status) continue;
            return statusType;
        }
        return null;
    }

    public static Map<Integer, String> getLabelMap() {
        return Arrays.asList(UserStatus.values()).stream().collect(Collectors.toMap(UserStatus::getStatus, UserStatus::getLabel));
    }
}

