/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum StudyPhase {
    RED_APPLE(1, "\u7ea2\u82f9\u679c", "RA"),
    BLUE_APPLE(2, "\u9752\u82f9\u679c", "BA"),
    SMALL_APPLE(3, "\u5c0f\u82f9\u679c", "SA"),
    NONE_APPLE(4, "\u975e\u82f9\u679c", "NA");

    private int type;
    private String label;
    private String code;
    private static Map<Integer, StudyPhase> cache;

    private StudyPhase(int type, String label, String code) {
        this.type = type;
        this.label = label;
        this.code = code;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static boolean contains(int type) {
        return cache.containsKey(type);
    }

    public static StudyPhase get(int type) {
        return cache.get(type);
    }

    public static String getLable(int type) {
        StudyPhase studyPhase = cache.get(type);
        return studyPhase == null ? null : studyPhase.getLabel();
    }

    public static StudyPhase getByLable(String label) {
        for (StudyPhase studyPhase : StudyPhase.values()) {
            if (!studyPhase.getLabel().endsWith(label)) continue;
            return studyPhase;
        }
        return null;
    }

    static {
        cache = Maps.newHashMap();
        for (StudyPhase studyPhase : StudyPhase.values()) {
            cache.put(studyPhase.getType(), studyPhase);
        }
    }
}

