/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum ShowInfoType {
    CLUE(0, "\u7ebf\u7d22"),
    STUDENT(1, "\u5b66\u5458");

    private int code;
    private String msg;
    private static Map<Integer, ShowInfoType> cache;

    private ShowInfoType(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public static ShowInfoType get(int code) {
        return cache.get(code);
    }

    public static boolean contains(int code) {
        return cache.containsKey(code);
    }

    public static ShowInfoType getByCode(Integer code) {
        return cache.get(code);
    }

    static {
        cache = Maps.newHashMap();
        for (ShowInfoType infoType : ShowInfoType.values()) {
            cache.put(infoType.code, infoType);
        }
    }
}

