/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum RoleType {
    SYSTEM(1, "system", "\u8d85\u7ea7\u7ba1\u7406\u5458"),
    MARKET(2, "market", "\u5e02\u573a"),
    TMK(3, "tmk", "TMK"),
    ADVISER(4, "adviser", "\u8bfe\u7a0b\u987e\u95ee"),
    ASSISTANT(5, "assistant", "\u52a9\u6559"),
    MASTER(6, "master", "\u6821\u957f"),
    SENATE(7, "senate", "\u6559\u52a1"),
    TEACHER(8, "teacher", "\u8001\u5e08"),
    FINANCE(9, "finance", "\u8d22\u52a1"),
    OTHER(10, "other", "\u5176\u5b83");

    private static Map<Integer, RoleType> cache;
    private int type;
    private String name;
    private String label;

    private RoleType(int type, String name, String label) {
        this.type = type;
        this.name = name;
        this.label = label;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static RoleType get(int type) {
        return cache.get(type);
    }

    public static boolean contains(int type) {
        return cache.containsKey(type);
    }

    public static RoleType getByType(Integer type) {
        return cache.get(type);
    }

    static {
        cache = Maps.newHashMap();
        for (RoleType roleType : RoleType.values()) {
            cache.put(roleType.type, roleType);
        }
    }
}

