/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum RelationType {
    STUDENT(1, "\u5b66\u5458"),
    FATHER(2, "\u7236\u4eb2"),
    MOTHER(3, "\u6bcd\u4eb2"),
    OTHER(4, "\u5176\u4ed6");

    private static Map<Integer, RelationType> cache;
    private int type;
    private String label;

    private RelationType(int type, String label) {
        this.type = type;
        this.label = label;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static RelationType get(int type) {
        return cache.get(type);
    }

    public static boolean contains(int type) {
        return cache.containsKey(type);
    }

    public static RelationType getByType(Integer type) {
        return cache.get(type);
    }

    public static String getLableByType(Integer type) {
        RelationType relationType = cache.get(type);
        return relationType == null ? null : relationType.getLabel();
    }

    public static RelationType getByLable(String label) {
        for (RelationType relationType : RelationType.values()) {
            if (!relationType.getLabel().endsWith(label)) continue;
            return relationType;
        }
        return null;
    }

    static {
        cache = Maps.newHashMap();
        for (RelationType relationType : RelationType.values()) {
            cache.put(relationType.type, relationType);
        }
    }
}

