/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum OceanClueType {
    CLAIM(1, "\u53ef\u9886\u53d6"),
    ALLOCATING(2, "\u53ef\u5206\u914d"),
    SELF(3, "\u81ea\u5df1");

    private static Map<Integer, OceanClueType> cache;
    private int type;
    private String label;

    private OceanClueType(int type, String label) {
        this.type = type;
        this.label = label;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static OceanClueType get(int type) {
        return cache.get(type);
    }

    public static boolean contains(int type) {
        return cache.containsKey(type);
    }

    public static OceanClueType getByType(Integer type) {
        return cache.get(type);
    }

    static {
        cache = Maps.newHashMap();
        for (OceanClueType oceanClueType : OceanClueType.values()) {
            cache.put(oceanClueType.type, oceanClueType);
        }
    }
}

