/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum GenderType {
    MALE(1, "\u7537"),
    FEMALE(2, "\u5973"),
    OTHER(3, "\u5176\u4ed6");

    private static Map<Integer, GenderType> cache;
    private int type;
    private String label;

    private GenderType(int type, String label) {
        this.type = type;
        this.label = label;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static GenderType get(int type) {
        return cache.get(type);
    }

    public static boolean contains(int type) {
        return cache.containsKey(type);
    }

    public static GenderType getByType(Integer type) {
        return cache.get(type);
    }

    public static String getLableByType(Integer type) {
        GenderType genderType = cache.get(type);
        return genderType == null ? null : genderType.getLabel();
    }

    public static GenderType getByLable(String label) {
        for (GenderType genderType : GenderType.values()) {
            if (!genderType.getLabel().endsWith(label)) continue;
            return genderType;
        }
        return null;
    }

    static {
        cache = Maps.newHashMap();
        for (GenderType genderType : GenderType.values()) {
            cache.put(genderType.type, genderType);
        }
    }
}

