/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum ConsultStatus {
    NO_FOLLOW(1, "\u672a\u8ddf\u8fdb"),
    FAILED_CONTACT(2, "\u672a\u8054\u7cfb\u4e0a"),
    FOLLOWED(3, "\u5df2\u8054\u7cfb"),
    SET_APPT(4, "\u9884\u7ea6\u6765\u8bbf"),
    VISITED(5, "\u5df2\u5230\u8bbf"),
    SECOND_SHOW(6, "\u5df2\u591a\u6b21\u5230\u8bbf");

    private int type;
    private String label;
    private static Map<Integer, ConsultStatus> cache;

    private ConsultStatus(int type, String label) {
        this.type = type;
        this.label = label;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static ConsultStatus get(int type) {
        if (cache.containsKey(type)) {
            return cache.get(type);
        }
        return null;
    }

    public static boolean contains(int type) {
        return cache.containsKey(type);
    }

    public static String getLableByType(Integer type) {
        ConsultStatus consultStatus = cache.get(type);
        return consultStatus == null ? null : consultStatus.getLabel();
    }

    public static ConsultStatus getByLable(String label) {
        for (ConsultStatus consultStatus : ConsultStatus.values()) {
            if (!consultStatus.getLabel().endsWith(label)) continue;
            return consultStatus;
        }
        return null;
    }

    static {
        cache = Maps.newHashMap();
        for (ConsultStatus consultStatus : ConsultStatus.values()) {
            cache.put(consultStatus.getType(), consultStatus);
        }
    }
}

