/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum ClueType {
    PRIVATE(0, "\u79c1\u6d77"),
    OCEAN(1, "\u516c\u6d77"),
    INVALID(2, "\u65e0\u6548");

    private static Map<Integer, ClueType> cache;
    private int type;
    private String label;

    private ClueType(int type, String label) {
        this.type = type;
        this.label = label;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static ClueType get(int type) {
        return cache.get(type);
    }

    public static boolean contains(int type) {
        return cache.containsKey(type);
    }

    public static ClueType getByType(Integer type) {
        return cache.get(type);
    }

    static {
        cache = Maps.newHashMap();
        for (ClueType validType : ClueType.values()) {
            cache.put(validType.type, validType);
        }
    }
}

