/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum ChannelType {
    ZDDX(1, "\u4e3b\u52a8\u5230\u6821"),
    XYTJ(2, "\u5b66\u5458\u63a8\u8350"),
    JZTJ(3, "\u5bb6\u957f\u63a8\u8350"),
    PYTJ(4, "\u670b\u53cb\u63a8\u8350"),
    RYTG(5, "\u4eba\u5458\u63a8\u5e7f"),
    GGXC(6, "\u5e7f\u544a\u5ba3\u4f20"),
    QDTJ(7, "\u6e20\u9053\u63a8\u8350"),
    WXLX(8, "\u7f51\u4e0a\u8054\u7cfb"),
    HDSL(8, "\u6d3b\u52a8\u6c99\u9f99"),
    XXGY(9, "\u5b66\u6821\u5de5\u827a"),
    JGTS(10, "\u673a\u6784\u63a8\u9001");

    private static Map<Integer, ChannelType> cache;
    private int type;
    private String label;

    private ChannelType(int type, String label) {
        this.type = type;
        this.label = label;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static ChannelType get(int type) {
        return cache.get(type);
    }

    public static boolean contains(int type) {
        return cache.containsKey(type);
    }

    public static ChannelType getByType(Integer type) {
        return cache.get(type);
    }

    public static String getLabelByType(Integer type) {
        ChannelType channelType = cache.get(type);
        return channelType == null ? null : channelType.getLabel();
    }

    public static ChannelType getByLable(String label) {
        for (ChannelType channelType : ChannelType.values()) {
            if (!channelType.getLabel().endsWith(label)) continue;
            return channelType;
        }
        return null;
    }

    static {
        cache = Maps.newHashMap();
        for (ChannelType channelType : ChannelType.values()) {
            cache.put(channelType.type, channelType);
        }
    }
}

