/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum CallState {
    WAIT(-2, "\u5f85\u63a5\u901a"),
    CALLED(-1, "\u5df2\u56de\u8c03"),
    FAILED(0, "\u547c\u53eb\u5931\u8d25"),
    SUCC(1, "\u547c\u53eb\u6210\u529f"),
    COMPLETED(2, "\u547c\u53eb\u5b8c\u6210");

    private int state;
    private String label;
    private static Map<Integer, CallState> cache;

    private CallState(int state, String label) {
        this.state = state;
        this.label = label;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static CallState get(int state) {
        return cache.get(state);
    }

    public static boolean contains(int state) {
        return cache.containsKey(state);
    }

    static {
        cache = Maps.newHashMap();
        for (CallState callState : CallState.values()) {
            cache.put(callState.state, callState);
        }
    }
}

