/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.common.cache.redis.service.impl;

import com.baijia.wedo.common.cache.CacheClient;
import com.baijia.wedo.common.util.PropertiesReader;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service(value="defaultCache")
public class RedisClientImpl
implements CacheClient {
    @Resource(name="redisTemplate")
    private RedisTemplate<String, Object> businessRedisTemplate;

    public RedisTemplate<String, Object> getBusinessRedisTemplate() {
        return this.businessRedisTemplate;
    }

    public void setBusinessRedisTemplate(RedisTemplate<String, Object> businessRedisTemplate) {
        this.businessRedisTemplate = businessRedisTemplate;
    }

    public void set(String key, Object value, long timeout, TimeUnit unit) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        ValueOperations valueops = this.businessRedisTemplate.opsForValue();
        valueops.set((Object)this.genRedisKeyPrefix(key), value, timeout, unit);
    }

    @Override
    public Object get(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        ValueOperations valueops = this.businessRedisTemplate.opsForValue();
        Object value = valueops.get((Object)this.genRedisKeyPrefix(key));
        return value;
    }

    @Override
    public void delete(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.businessRedisTemplate.delete((Object)this.genRedisKeyPrefix(key));
    }

    @Override
    public Boolean exists(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return this.businessRedisTemplate.hasKey((Object)this.genRedisKeyPrefix(key));
    }

    @Override
    public boolean setIfAbsent(String key, Object value, long timeout) {
        ValueOperations valueops = this.businessRedisTemplate.opsForValue();
        boolean result = valueops.setIfAbsent((Object)(key = this.genRedisKeyPrefix(key)), value);
        if (result) {
            this.set(key, value, timeout, TimeUnit.SECONDS);
        }
        return result;
    }

    @Override
    public void set(String key, Object value, long timeout) {
        ValueOperations valueops = this.businessRedisTemplate.opsForValue();
        valueops.set((Object)this.genRedisKeyPrefix(key), value, timeout, TimeUnit.SECONDS);
    }

    @Override
    public void set(String key, Object value) {
        ValueOperations valueops = this.businessRedisTemplate.opsForValue();
        valueops.set((Object)this.genRedisKeyPrefix(key), value);
    }

    @Override
    public Long incr(final String key, Long offset) {
        final RedisSerializer serializer = this.businessRedisTemplate.getStringSerializer();
        long val = (Long)this.businessRedisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] keyArr = serializer.serialize((Object)RedisClientImpl.this.genRedisKeyPrefix(key));
                Long value = connection.incr(keyArr);
                return Long.parseLong(((Object)value).toString());
            }
        });
        return val;
    }

    @Override
    public Integer getAndSet(final String key, final int val) {
        final RedisSerializer serializer = this.businessRedisTemplate.getStringSerializer();
        this.businessRedisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] keyArr = serializer.serialize((Object)RedisClientImpl.this.genRedisKeyPrefix(key));
                byte[] valArr = serializer.serialize((Object)(val + ""));
                byte[] retVal = connection.getSet(keyArr, valArr);
                String str = (String)serializer.deserialize(retVal);
                return str;
            }
        });
        return 1;
    }

    @Override
    public void evict(String key) {
        this.businessRedisTemplate.delete((Object)this.genRedisKeyPrefix(key));
    }

    String genRedisKeyPrefix(String dataKey) {
        String prefixKey = PropertiesReader.getValue("redis", "redis.key.prefix");
        return prefixKey + dataKey;
    }
}

