/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.util.distributedlock.spring;

import com.baijia.util.distributedlock.exception.NotSupportRedisInstanceException;
import com.baijia.util.distributedlock.lock.RedisLock;
import com.baijia.util.distributedlock.lock.RedisLockFactory;
import com.baijia.util.distributedlock.spring.RedisLockService;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import redis.clients.util.Pool;

public class RedisLockServiceImpl
implements RedisLockService {
    private static final RedisLockFactory lockFactory = RedisLockFactory.getInstance();
    private Pool pool;
    private RedisTemplate redisTemplate;

    public RedisLockServiceImpl(Pool pool) {
        Preconditions.checkNotNull((Object)pool, (Object)"Redis connection pool can not be null! You must config JedisPool or ShardedJedisPool in spring framework!");
        this.pool = pool;
    }

    public RedisLockServiceImpl(RedisTemplate redisTemplate) {
        Preconditions.checkNotNull((Object)redisTemplate, (Object)"RedisTemplate connection pool can not be null! You must config RedisTemplate in spring framework!");
        this.redisTemplate = redisTemplate;
    }

    public boolean getLock(String lockKey, int expireSec, int tryTimes, long wait, TimeUnit unit) {
        RedisLock redisLock = this.getRedisLock(lockKey);
        return redisLock.getLock(expireSec, tryTimes, wait, unit);
    }

    public boolean releaseLock(String lockKey) {
        RedisLock redisLock = this.getRedisLock(lockKey);
        return redisLock.releaseLock();
    }

    private RedisLock getRedisLock(String lockKey) {
        RedisLock redisLock = null;
        if (this.pool != null) {
            redisLock = lockFactory.getRedisLock(this.pool, lockKey);
        } else if (this.redisTemplate != null) {
            redisLock = lockFactory.getRedisLock(this.redisTemplate, lockKey);
        }
        if (redisLock == null) {
            throw new NotSupportRedisInstanceException();
        }
        return redisLock;
    }
}

