/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.util.distributedlock.lock;

import com.baijia.util.distributedlock.lock.RedisLockAdapter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.SerializationException;

public class RedisTemplateRedisLock
extends RedisLockAdapter {
    private static final Logger logger = LoggerFactory.getLogger(RedisTemplateRedisLock.class);
    private RedisTemplate redisTemplate;
    private RedisConnection connection;
    private byte[] binaryKey;

    protected RedisTemplateRedisLock(RedisTemplate redisTemplate, String key) {
        this.redisTemplate = redisTemplate;
        this.binaryKey = redisTemplate.getKeySerializer().serialize((Object)key);
        this.connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)redisTemplate.getConnectionFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLock(int expireSec, int tryTimes, long wait, TimeUnit unit) {
        this.checkParam(expireSec, tryTimes, wait, unit);
        try {
            boolean bl = this.getLock(this.connection, expireSec, tryTimes, wait, unit);
            return bl;
        }
        catch (SerializationException e) {
            logger.error("serialize key error!");
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)this.connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
        return false;
    }

    private boolean retry(RedisConnection connection, int expireSec, int tryTimes, long wait, TimeUnit unit) {
        if (tryTimes > 0) {
            --tryTimes;
            try {
                Thread.sleep(TimeUnit.MILLISECONDS.equals((Object)unit) ? wait : unit.toMillis(wait));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.getLock(connection, expireSec, tryTimes, wait, unit);
        }
        return false;
    }

    private boolean getLock(RedisConnection connection, int expireSec, int tryTimes, long wait, TimeUnit unit) {
        connection.multi();
        connection.incr(this.binaryKey);
        connection.expire(this.binaryKey, (long)expireSec);
        if ((Long)connection.exec().get(0) != 1L) {
            return this.retry(connection, expireSec, tryTimes, wait, unit);
        }
        return true;
    }

    public boolean releaseLock() {
        RedisConnection connection = null;
        try {
            connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
            boolean bl = connection.del((byte[][])new byte[][]{this.binaryKey}) == 1L;
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }
}

