/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.util.distributedlock.lock;

import com.baijia.util.distributedlock.lock.RedisLockAdapter;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.Transaction;
import redis.clients.util.Pool;

public class JedisRedisLock
extends RedisLockAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JedisRedisLock.class);
    private Pool pool;
    private String key;

    protected JedisRedisLock(Pool pool, String key) {
        this.pool = pool;
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLock(int expireSec, int tryTimes, long wait, TimeUnit unit) {
        this.checkParam(expireSec, tryTimes, wait, unit);
        Object transaction = null;
        JedisCommands jedisCommands = this.getInstance(this.pool);
        try {
            Jedis jedis = null;
            if (jedisCommands instanceof ShardedJedis) {
                jedis = (Jedis)((ShardedJedis)jedisCommands).getShard(this.key);
            } else if (jedisCommands instanceof Jedis) {
                jedis = (Jedis)jedisCommands;
            }
            boolean bl = this.getLock(jedis, expireSec, tryTimes, wait, unit);
            return bl;
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.discard();
            }
            logger.error("get lock error!");
        }
        finally {
            this.close(jedisCommands);
        }
        return false;
    }

    private boolean getLock(Jedis jedis, int expireSec, int tryTimes, long wait, TimeUnit unit) {
        Transaction transaction = jedis.multi();
        transaction.incr(this.key);
        transaction.expire(this.key, expireSec);
        if ((Long)transaction.exec().get(0) != 1L) {
            return this.retry(jedis, expireSec, tryTimes, wait, unit);
        }
        return true;
    }

    private boolean retry(Jedis jedis, int expireSec, int tryTimes, long wait, TimeUnit unit) {
        if (tryTimes > 0) {
            --tryTimes;
            try {
                Thread.sleep(TimeUnit.MILLISECONDS.equals((Object)unit) ? wait : unit.toMillis(wait));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.getLock(jedis, expireSec, tryTimes, wait, unit);
        }
        return false;
    }

    public boolean releaseLock() {
        JedisCommands jedisCommands = this.getInstance(this.pool);
        try {
            boolean bl = jedisCommands.del(this.key) == 1L;
            return bl;
        }
        finally {
            this.close(jedisCommands);
        }
    }

    private JedisCommands getInstance(Pool pool) {
        JedisCommands jedisCommands = (JedisCommands)pool.getResource();
        return jedisCommands;
    }

    private void close(Object instance) {
        try {
            ((Closeable)instance).close();
        }
        catch (IOException e) {
            logger.error("close instance error!");
        }
    }
}

