/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umeng.search.api.constant;

import com.baijia.umeng.search.api.constant.UmengCourse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmengSearchResponse
implements Serializable {
    private int code;
    private String msg;
    private Object data;
    public static final int CODE_SUCCESS = 0;
    public static final String MSG_SUCCESS = "success";
    public static final int CODE_PARAM_ERROR = -1;
    public static final String MSG_PARAM_ERROR = "param error";
    public static final int CODE_BIZ_ERROR = -2;
    public static final String MSG_BIZ_ERROR = "biz error";
    public static final int CODE_SYS_ERROR = -3;
    public static final String MSG_SYS_ERROR = "sys error";
    public static final int CODE_CUSTOM_ERROR = -4;
    public static final String MSG_CUSTOM_ERROR = "custom error";
    private static final Map<Integer, String> CODE_2_MSG = new HashMap<Integer, String>();

    public UmengSearchResponse() {
    }

    public UmengSearchResponse(int code, String msg, Object data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static UmengSearchResponse createResponse(int code) {
        UmengSearchResponse response = new UmengSearchResponse();
        response.setCode(code);
        response.setMsg(CODE_2_MSG.get(code));
        response.setData(null);
        return response;
    }

    public static UmengSearchResponse createResponse(int code, String msg) {
        UmengSearchResponse response = new UmengSearchResponse();
        response.setCode(code);
        response.setMsg(msg);
        response.setData(null);
        return response;
    }

    public static UmengSearchResponse createResponse(int code, String msg, Object data) {
        UmengSearchResponse response = new UmengSearchResponse();
        response.setCode(code);
        response.setMsg(msg);
        response.setData(data);
        return response;
    }

    public static UmengSearchResponseBuilder builder() {
        return new UmengSearchResponseBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public Object getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UmengSearchResponse)) {
            return false;
        }
        UmengSearchResponse other = (UmengSearchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UmengSearchResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "UmengSearchResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    static {
        CODE_2_MSG.put(0, MSG_SUCCESS);
        CODE_2_MSG.put(-1, MSG_PARAM_ERROR);
        CODE_2_MSG.put(-2, MSG_BIZ_ERROR);
        CODE_2_MSG.put(-3, MSG_SYS_ERROR);
        CODE_2_MSG.put(-4, MSG_CUSTOM_ERROR);
    }

    public static class UmengSearchResponseBuilder {
        private int code;
        private String msg;
        private Object data;

        UmengSearchResponseBuilder() {
        }

        public UmengSearchResponseBuilder code(int code) {
            this.code = code;
            return this;
        }

        public UmengSearchResponseBuilder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public UmengSearchResponseBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public UmengSearchResponse build() {
            return new UmengSearchResponse(this.code, this.msg, this.data);
        }

        public String toString() {
            return "UmengSearchResponse.UmengSearchResponseBuilder(code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ")";
        }
    }

    public static class UmengCourseSearchResult
    implements Serializable {
        private int count;
        private List<UmengCourse> courses;

        public UmengCourseSearchResult() {
        }

        public UmengCourseSearchResult(int count, List<UmengCourse> courses) {
            this.count = count;
            this.courses = courses;
        }

        public static UmengCourseSearchResultBuilder builder() {
            return new UmengCourseSearchResultBuilder();
        }

        public int getCount() {
            return this.count;
        }

        public List<UmengCourse> getCourses() {
            return this.courses;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setCourses(List<UmengCourse> courses) {
            this.courses = courses;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UmengCourseSearchResult)) {
                return false;
            }
            UmengCourseSearchResult other = (UmengCourseSearchResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            List<UmengCourse> this$courses = this.getCourses();
            List<UmengCourse> other$courses = other.getCourses();
            return !(this$courses == null ? other$courses != null : !((Object)this$courses).equals(other$courses));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UmengCourseSearchResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            List<UmengCourse> $courses = this.getCourses();
            result = result * 59 + ($courses == null ? 43 : ((Object)$courses).hashCode());
            return result;
        }

        public String toString() {
            return "UmengSearchResponse.UmengCourseSearchResult(count=" + this.getCount() + ", courses=" + this.getCourses() + ")";
        }

        public static class UmengCourseSearchResultBuilder {
            private int count;
            private List<UmengCourse> courses;

            UmengCourseSearchResultBuilder() {
            }

            public UmengCourseSearchResultBuilder count(int count) {
                this.count = count;
                return this;
            }

            public UmengCourseSearchResultBuilder courses(List<UmengCourse> courses) {
                this.courses = courses;
                return this;
            }

            public UmengCourseSearchResult build() {
                return new UmengCourseSearchResult(this.count, this.courses);
            }

            public String toString() {
                return "UmengSearchResponse.UmengCourseSearchResult.UmengCourseSearchResultBuilder(count=" + this.count + ", courses=" + this.courses + ")";
            }
        }
    }
}

