/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umzgh.util.tool;

import com.baijia.umzgh.util.tool.RobotCenterProperties;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;

public class RedisClient {
    private final Logger LOG = Logger.getLogger(RedisClient.class);
    private static final Charset UTF8 = Charset.forName("utf8");
    private static Object lock = new Object();
    private static final String PRE_LOCKKEY = "groupidGapSenderTaskMapLOCK";
    String passwd = "";
    private static RedisClient instance;
    private JedisPool jedisPool;
    private Jedis jedis;
    private int db;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisClient getInstance() {
        if (instance != null) return instance;
        Class<RedisClient> clazz = RedisClient.class;
        synchronized (RedisClient.class) {
            instance = new RedisClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private RedisClient() {
        JedisPool jedisPool;
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(Integer.parseInt(RobotCenterProperties.getProperty("maxIdle")));
        config.setMaxWaitMillis(60000L);
        this.jedisPool = jedisPool = new JedisPool((GenericObjectPoolConfig)config, RobotCenterProperties.getProperty("redis_host"), Integer.parseInt(RobotCenterProperties.getProperty("redis_port")), 100000);
        this.db = Integer.parseInt(RobotCenterProperties.getProperty("redis_db"));
        this.passwd = RobotCenterProperties.getProperty("redis_passwd");
        this.LOG.info((Object)String.format("host=%s , port=%s", RobotCenterProperties.getProperty("redis_host"), RobotCenterProperties.getProperty("redis_port")));
    }

    private RedisClient(int db_num, String host, Integer port, String passwd) {
        JedisPool jedisPool;
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(Integer.parseInt(RobotCenterProperties.getProperty("jedisMaxIdle")));
        config.setMaxWaitMillis(60000L);
        this.jedisPool = jedisPool = new JedisPool((GenericObjectPoolConfig)config, host, port.intValue());
        this.db = db_num;
        this.passwd = passwd;
        this.LOG.info((Object)String.format("host=%s , port=%s", host, port));
    }

    private RedisClient(String host, int port, int db) {
        this.jedis = new Jedis(host, port);
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getValue(String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            byte[] byArray = jedis.get(key.getBytes(UTF8));
            return byArray;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getValueList2(List<String> keyList) {
        if (keyList == null || keyList.isEmpty()) {
            return null;
        }
        List bytesListResult = null;
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            int keyListSize = keyList.size();
            byte[][] paramArray = new byte[keyListSize][];
            for (int i = 0; i < keyListSize; ++i) {
                paramArray[i] = keyList.get(i).getBytes(UTF8);
            }
            bytesListResult = jedis.mget((byte[][])paramArray);
            if (bytesListResult == null || bytesListResult.size() != keyListSize) {
                throw new IllegalStateException("\u8fd4\u56de\u5217\u8868\u5927\u5c0f\u4e0d\u7b49\u4e8e\u8bf7\u6c42\u5217\u8868\u5927\u5c0f!");
            }
            ArrayList<String> stringResultList = new ArrayList<String>(keyListSize);
            for (int i = 0; i < keyListSize; ++i) {
                byte[] bytes = (byte[])bytesListResult.get(i);
                if (bytes == null) {
                    stringResultList.add(null);
                    continue;
                }
                stringResultList.add(new String(bytes));
            }
            ArrayList<String> arrayList = stringResultList;
            return arrayList;
        }
        catch (IllegalStateException e) {
            this.LOG.error((Object)String.format("[RedisClient] [getValueList] [fetch data from redis error! bytesListResult size:{}]", bytesListResult == null ? 0 : bytesListResult.size()));
            List<String> list = null;
            return list;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    public List<String> getValueList(List<String> keyList) throws Exception {
        if (keyList == null || keyList.isEmpty()) {
            return null;
        }
        ArrayList<String> result = null;
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Pipeline pl = jedis.pipelined();
            ArrayList<Response> responses = new ArrayList<Response>(keyList.size());
            for (String key : keyList) {
                this.LOG.debug((Object)String.format("[RedisClient] [getValueList] [request key:{}]", key));
                Response resp = pl.get(key.getBytes(UTF8));
                responses.add(resp);
            }
            pl.syncAndReturnAll();
            result = new ArrayList<String>(keyList.size());
            for (Response resp : responses) {
                byte[] bytes = null;
                String str = null;
                bytes = (byte[])resp.get();
                this.LOG.debug((Object)String.format("[RedisClient] [getValueList] [bytes size:{}]", bytes == null ? 0 : bytes.length));
                if (bytes != null) {
                    str = new String(bytes);
                }
                result.add(str);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)String.format("[RedisClient] [getValueList] [fetch data from redis error!]", e));
            throw e;
        }
        finally {
            this.closeJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String key, byte[] value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.set(key.getBytes(UTF8), value);
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exist(String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Boolean bl = null;
            return bl;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hexist(String map, String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Boolean bl = jedis.hexists(map, key);
            return bl;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Boolean bl = null;
            return bl;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapInc(String name, String key, int incValue) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.hincrBy(name, key, (long)incValue);
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMap(String map, String key, String value) {
        this.LOG.debug((Object)("[setMap] map: " + map));
        this.LOG.debug((Object)("[setMap] key: " + key));
        this.LOG.debug((Object)("[setMap] value: " + value));
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.hset(map, key, value);
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            this.LOG.warn((Object)e.getMessage());
            int n = -1;
            return n;
        }
        finally {
            this.closeJedis(jedis);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delMapKey(String map, String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.hdel(map, new String[]{key});
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            this.LOG.warn((Object)e.getMessage());
            int n = -1;
            return n;
        }
        finally {
            this.closeJedis(jedis);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delMapKeys(String map, String[] keys) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.hdel(map, keys);
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            this.LOG.warn((Object)e.getMessage());
            int n = -1;
            return n;
        }
        finally {
            this.closeJedis(jedis);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMap(String key, Map<String, String> value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.hmset(key, value);
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeMapValue(String name, String key, String value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Object object = lock;
            synchronized (object) {
                if (jedis.hexists(name, key).booleanValue()) {
                    jedis.hset(name, key, value);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getMapIter(String name) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Iterator<String> iterator = jedis.hkeys(name).iterator();
            return iterator;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Iterator<String> iterator = null;
            return iterator;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMulKeys(String name, String ... keys) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            List list = jedis.hmget(name, keys);
            return list;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            List<String> list = null;
            return list;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMapValue(String name, String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            String string = jedis.hget(name, key);
            return string;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hGetAll(String name) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Map map = jedis.hgetAll(name);
            return map;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Map<String, String> map = null;
            return map;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmMapValue(String name, String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Object object = lock;
            synchronized (object) {
                if (jedis.hexists(name, key).booleanValue()) {
                    jedis.hdel(name, new String[]{key});
                }
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(String name) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.del(name);
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getListValue(String name, int slot) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            String string = (String)jedis.lrange(name, (long)slot, (long)(slot + 1)).get(0);
            return string;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListValue(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.lpush(key, new String[]{value});
        }
        catch (Exception exception) {
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeListValue(String key, long slot, String value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.lset(key, slot, value);
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMapKeyList(String name) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Set set = jedis.hkeys(name);
            return set;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Set<String> set = null;
            return set;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeyList(String name) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Set set = jedis.keys(name);
            return set;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Set<String> set = null;
            return set;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getZsetValue(String name, String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            double d = jedis.zscore(name, key);
            return d;
        }
        catch (Exception e) {
            double d = 0.0;
            return d;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringValue(String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    private void closeJedis(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueEx(String redisKey, byte[] bytes, int sessionValidDuration) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.setex(redisKey.getBytes(), sessionValidDuration, bytes);
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setnx(String redisKey, String value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            long l = jedis.setnx(redisKey, value);
            return l;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            long l = -1L;
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    public long pttl(String redisKey) {
        return 100L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> vals(String map) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            List list = jedis.hvals(map);
            return list;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            List<String> list = null;
            return list;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMapValues(String map, String[] keys) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            List list = jedis.hmget(map, keys);
            return list;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            List<String> list = null;
            return list;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Long l = jedis.lpush(key, new String[]{value});
            return l;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Long l = null;
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lpop(String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            String string = jedis.lpop(key);
            return string;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpush(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Long l = jedis.rpush(key, new String[]{value});
            return l;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Long l = null;
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rpop(String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            String string = jedis.rpop(key);
            return string;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hincr(String mapKey, String key, long value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Long l = jedis.hincrBy(mapKey, key, value);
            return l;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Long l = null;
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sadd(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Long l = jedis.sadd(key, new String[]{value});
            return l;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Long l = null;
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            Set set = jedis.smembers(key);
            return set;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            Set<String> set = null;
            return set;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean glock(String key, int expire, String identity, int interval, int timeout) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            String lockKey = PRE_LOCKKEY + key;
            long start = System.currentTimeMillis();
            while (true) {
                jedis.watch(new String[]{lockKey});
                if (jedis.exists(lockKey).booleanValue()) {
                    jedis.unwatch();
                } else {
                    Transaction trans = jedis.multi();
                    trans.setex(lockKey, expire, identity);
                    List response = trans.exec();
                    if (response != null && response.get(0).equals("OK")) {
                        this.LOG.info((Object)("\u83b7\u5f97\u4e86 key: " + key));
                        boolean bl = true;
                        return bl;
                    }
                }
                if (timeout != 0 && System.currentTimeMillis() - start > (long)timeout) {
                    this.LOG.info((Object)"\u83b7\u5f97key\u8d85\u65f6\u4e86");
                    boolean bl = false;
                    return bl;
                }
                Thread.sleep(interval);
                continue;
                break;
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rlock(String key, String identity) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            String lockKey = PRE_LOCKKEY + key;
            String lockValue = jedis.get(lockKey);
            if (lockValue != null && lockValue.equals(identity)) {
                Transaction trans = jedis.multi();
                this.LOG.info((Object)("del key :" + key));
                trans.del(lockKey);
                List response = trans.exec();
                if (response.get(0).equals("OK")) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    public static void main(String[] args) {
        Long count = RedisClient.getInstance().lpush("haha", "s");
        String value = RedisClient.getInstance().lpop("haha");
        System.out.println("count: " + count);
        System.out.println("value: " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(String key, int expireTimeSeconds) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.auth(this.passwd);
            jedis.select(this.db);
            jedis.expire(key, expireTimeSeconds);
        }
        catch (Exception e) {
            this.LOG.error((Object)"RedisClient: ", (Throwable)e);
            return;
        }
        finally {
            this.closeJedis(jedis);
        }
    }
}

