/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umzgh.util.tool;

import com.baijia.umzgh.util.exception.BusinessException;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrcodeService {
    private static final Logger log = LoggerFactory.getLogger(QrcodeService.class);
    private static final int SHARED_QRCODE_SIZE = 300;
    private static final int GSX_LOGO_SIZE = 90;
    private static final String GSX_LOGO_PATH = "../../webapp/WEB-INF/classes/gsx_log.jpg";
    private static final String UM_LOGO_PATH = "../../webapp/WEB-INF/classes/um_log.png";
    private static final Object True = null;

    public static BufferedImage encode(String text, int width, int height) throws WriterException {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                image.setRGB(i, j, bitMatrix.get(i, j) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static Result decode(BufferedImage image) {
        BufferedImageLuminanceSource bils = new BufferedImageLuminanceSource(image);
        HybridBinarizer hb = new HybridBinarizer((LuminanceSource)bils);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)hb);
        QRCodeReader reader = new QRCodeReader();
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.TRY_HARDER, True);
        Result result = null;
        try {
            result = reader.decode(binaryBitmap, hints);
        }
        catch (ChecksumException | FormatException | NotFoundException e) {
            return null;
        }
        return result;
    }

    public static void getQrcodeWithLogo(String text, OutputStream stream) throws IOException, WriterException {
        String format = "JPG";
        BufferedImage qrcodeImage = QrcodeService.encode(text, 300, 300);
        File file = new File(GSX_LOGO_PATH);
        if (!file.exists()) {
            log.info("gsx logo image doesn't exist, path : ../../webapp/WEB-INF/classes/gsx_log.jpg");
            throw new BusinessException("\u751f\u6210\u5206\u4eab\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8005\u8054\u7cfb\u5ba2\u670d\u3002");
        }
        BufferedImage gsxLogoImage = ImageIO.read(file);
        int width = gsxLogoImage.getWidth(null);
        int height = gsxLogoImage.getHeight(null);
        if (width > 90) {
            width = 90;
        }
        if (height > 90) {
            height = 90;
        }
        Image scaledImage = gsxLogoImage.getScaledInstance(width, height, 4);
        BufferedImage tag = new BufferedImage(width, height, 2);
        Graphics g = tag.getGraphics();
        g.drawImage(scaledImage, 0, 0, null);
        g.dispose();
        int posX = (300 - width) / 2;
        int posY = (300 - height) / 2;
        QrcodeService.mergeImage(qrcodeImage, tag, posX, posY);
        ImageIO.write((RenderedImage)qrcodeImage, format, stream);
    }

    public static BufferedImage encodeWithLogo(String text, int width, int height, int mixLogoWidth, int mixLogoHeight) throws WriterException, IOException {
        BufferedImage image = QrcodeService.encode(text, width, height);
        File file = new File(UM_LOGO_PATH);
        if (!file.exists()) {
            log.info("gsx logo image doesn't exist, path : ../../webapp/WEB-INF/classes/gsx_log.jpg");
            throw new BusinessException("\u751f\u6210\u5206\u4eab\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8005\u8054\u7cfb\u5ba2\u670d\u3002");
        }
        BufferedImage gsxLogoImage = ImageIO.read(file);
        int originWidth = gsxLogoImage.getWidth(null);
        int originHeight = gsxLogoImage.getHeight(null);
        if (originWidth > mixLogoWidth) {
            originWidth = mixLogoWidth;
        }
        if (originHeight > mixLogoHeight) {
            originHeight = mixLogoHeight;
        }
        Image scaledImage = gsxLogoImage.getScaledInstance(originWidth, originHeight, 4);
        BufferedImage tag = new BufferedImage(originWidth, originHeight, 2);
        Graphics g = tag.getGraphics();
        g.drawImage(scaledImage, 0, 0, null);
        g.dispose();
        int posX = (width - originWidth) / 2;
        int posY = (height - originHeight) / 2;
        QrcodeService.mergeImage(image, tag, posX, posY);
        return image;
    }

    public static void mergeImage(BufferedImage backgroundImage, BufferedImage frontImage, int posX, int posY) throws IOException {
        log.info("posX : " + posX + ", posY : " + posY);
        Graphics2D graph = backgroundImage.createGraphics();
        graph.drawImage(frontImage, posX, posY, frontImage.getWidth(), frontImage.getHeight(), null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(posX, posY, frontImage.getWidth(), frontImage.getWidth(), 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    public static BufferedImage drawTranslucentStringPic(int width, int height, Integer fontHeight, Map mapString, String path) {
        try {
            File file;
            BufferedImage buffImg = new BufferedImage(width, height, 1);
            Graphics2D gd = buffImg.createGraphics();
            buffImg = gd.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            gd = buffImg.createGraphics();
            gd.setFont(new Font("Dialog", 0, fontHeight));
            gd.setColor(Color.white);
            gd.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (mapString.containsKey("mobile")) {
                gd.drawString((String)mapString.get("mobile"), 84, fontHeight + 47);
            }
            if (mapString.containsKey("wechat")) {
                gd.drawString((String)mapString.get("wechat"), 84, fontHeight * 2 + 94 - 25);
            }
            if (mapString.containsKey("qq")) {
                gd.drawString((String)mapString.get("qq"), 84, fontHeight * 3 + 94 - 2);
            }
            gd.dispose();
            File contactfile = new File(path + "contact.png");
            if (!contactfile.exists()) {
                log.info("contact image doesn't exist, path : " + path + "contact.png");
                throw new BusinessException("\u751f\u6210\u5206\u4eab\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8005\u8054\u7cfb\u5ba2\u670d\u3002");
            }
            BufferedImage contactImage = ImageIO.read(contactfile);
            QrcodeService.mergeImageV3(buffImg, contactImage, 0, 0);
            String mobile = (String)mapString.get("mobile");
            String wechat = (String)mapString.get("wechat");
            String qq = (String)mapString.get("qq");
            if (!StringUtils.isEmpty((CharSequence)mobile)) {
                file = new File(path + "mobile.png");
                if (!file.exists()) {
                    log.info("recruited image doesn't exist, path : " + path + "mobile.png");
                    throw new BusinessException("\u751f\u6210\u5206\u4eab\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8005\u8054\u7cfb\u5ba2\u670d\u3002");
                }
                BufferedImage mobileImage = ImageIO.read(file);
                QrcodeService.mergeImageV3(buffImg, mobileImage, 0, 0);
            }
            if (!StringUtils.isEmpty((CharSequence)wechat)) {
                file = new File(path + "wechat.png");
                if (!file.exists()) {
                    log.info("recruited image doesn't exist, path : " + path + "wechat.png");
                    throw new BusinessException("\u751f\u6210\u5206\u4eab\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8005\u8054\u7cfb\u5ba2\u670d\u3002");
                }
                BufferedImage wechatImage = ImageIO.read(file);
                QrcodeService.mergeImageV3(buffImg, wechatImage, 0, 0);
            }
            if (!StringUtils.isEmpty((CharSequence)qq)) {
                file = new File(path + "qq.png");
                if (!file.exists()) {
                    log.info("recruited image doesn't exist, path : " + path + "qq.png");
                    throw new BusinessException("\u751f\u6210\u5206\u4eab\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8005\u8054\u7cfb\u5ba2\u670d\u3002");
                }
                BufferedImage qqImage = ImageIO.read(file);
                QrcodeService.mergeImageV3(buffImg, qqImage, 0, 0);
            }
            return buffImg;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void mergeImageV3(BufferedImage backgroundImage, BufferedImage frontImage, int posX, int posY) throws IOException {
        log.error("mergeImageV3 posX : " + posX + ", posY : " + posY);
        Graphics2D graph = backgroundImage.createGraphics();
        graph.drawImage(frontImage, posX, posY, frontImage.getWidth(), frontImage.getHeight(), null);
        graph.dispose();
    }

    public static void mergeImage2(BufferedImage backgroundImage, BufferedImage frontImage, int posX, int posY, BufferedImage frontImage2, int pos2X, int pos2Y, BufferedImage frontImage3, int pos3X, int pos3Y) throws IOException {
        log.error("mergeImageV3 posX : " + posX + ", posY : " + posY);
        Graphics2D graph = backgroundImage.createGraphics();
        if (frontImage != null) {
            graph.drawImage(frontImage, posX, posY, frontImage.getWidth(), frontImage.getHeight(), null);
        }
        if (frontImage2 != null) {
            graph.drawImage(frontImage2, pos2X, pos2Y, frontImage2.getWidth(), frontImage2.getHeight(), null);
        }
        if (frontImage3 != null) {
            graph.drawImage(frontImage3, pos3X, pos3Y, frontImage3.getWidth(), frontImage3.getHeight(), null);
        }
        graph.dispose();
    }

    public static void mergeImageV2(BufferedImage backgroundImage, BufferedImage frontImage, int posX, int posY) throws IOException {
        log.info("posX : " + posX + ", posY : " + posY);
        Graphics2D graph = backgroundImage.createGraphics();
        graph.drawImage(frontImage, posX, posY, frontImage.getWidth(), frontImage.getHeight(), null);
        graph.dispose();
    }
}

