/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umzgh.util.tool;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PanamaHttpClient {
    private static final Logger log = LoggerFactory.getLogger(PanamaHttpClient.class);
    private static final String HTTP_CONTENT_TYPE_JSON = "application/json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jsonPost(String path, String json, String encoding, String clientIp) {
        if (path == null || json == null || encoding == null) {
            log.warn("[BanamaHttpClient] [jsonPost] {} [input invalid]", (Object)"[PARAM_ERROR]");
            return null;
        }
        CloseableHttpClient httpClient = null;
        try {
            CloseableHttpResponse httpResponse;
            httpClient = HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build();
            HttpPost method = new HttpPost(path);
            method.setConfig(requestConfig);
            StringEntity entity = new StringEntity(json, encoding);
            entity.setContentEncoding(encoding);
            entity.setContentType(HTTP_CONTENT_TYPE_JSON);
            method.setEntity((HttpEntity)entity);
            if (!StringUtils.isBlank((CharSequence)clientIp)) {
                method.addHeader("X-Forwarded-For", clientIp);
            }
            if ((httpResponse = httpClient.execute((HttpUriRequest)method)) == null || httpResponse.getStatusLine() == null) {
                log.error("[BanamaHttpClient] [jsonPost] {} [httpResponse is invalid]", (Object)"[SYS_ERROR]");
                String string = null;
                return string;
            }
            if (200 != httpResponse.getStatusLine().getStatusCode()) {
                log.error("[BanamaHttpClient] [jsonPost] {} [httpStatus != 200]", (Object)"[SYS_ERROR]");
                log.error("[BanamaHttpClient] [jsonPost] [response status:" + httpResponse.getStatusLine().getStatusCode() + "]");
                String string = null;
                return string;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                log.error("[BanamaHttpClient] [jsonPost] {} [httpEntity is null]", (Object)"[SYS_ERROR]");
                String string = null;
                return string;
            }
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            log.error("[BanamaHttpClient] [jsonPost] [SYS_ERROR]", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                    httpClient = null;
                }
                catch (Exception e) {
                    log.error("[BanamaHttpClient] [jsonPost] {} [free resource failed]", (Object)"[SYS_ERROR]");
                }
            }
        }
    }

    public static URLConnection doGet(String url, String charset) throws IOException {
        URL realUrl = new URL(url);
        URLConnection connection = realUrl.openConnection();
        connection.setRequestProperty("accept", "*/*");
        connection.setRequestProperty("connection", "Keep-Alive");
        connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        connection.connect();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String path, String encoding) {
        if (path == null || encoding == null) {
            log.warn("[BanamaHttpClient] [get] {} [input invalid]", (Object)"[PARAM_ERROR]");
            return null;
        }
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpGet method = new HttpGet(path);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method);
            if (httpResponse == null || httpResponse.getStatusLine() == null) {
                log.error("[BanamaHttpClient] [get] {} [httpResponse is invalid]", (Object)"[SYS_ERROR]");
                String string = null;
                return string;
            }
            if (200 != httpResponse.getStatusLine().getStatusCode()) {
                log.error("[BanamaHttpClient] [get] {} [httpStatus != 200]", (Object)"[SYS_ERROR]");
                log.error("[BanamaHttpClient] [get] [response status:" + httpResponse.getStatusLine().getStatusCode() + "]");
                String string = null;
                return string;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                log.error("[BanamaHttpClient] [get] {} [httpEntity is null]", (Object)"[SYS_ERROR]");
                String string = null;
                return string;
            }
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)encoding);
            return string;
        }
        catch (Exception e) {
            log.error("[BanamaHttpClient] [get] [SYS_ERROR]", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                    httpClient = null;
                }
                catch (Exception e) {
                    log.error("[BanamaHttpClient] [get] {} [free resource failed]", (Object)"[SYS_ERROR]");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Cookie> getImage(String path, String encoding, OutputStream outputStream) {
        if (path == null || encoding == null) {
            log.warn("[BanamaHttpClient] [get] {} [input invalid]", (Object)"[PARAM_ERROR]");
            return null;
        }
        CloseableHttpClient httpClient = null;
        HttpClientContext httpContext = null;
        try {
            httpClient = HttpClients.createDefault();
            httpContext = HttpClientContext.create();
            HttpGet method = new HttpGet(path);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method, (HttpContext)httpContext);
            if (httpResponse == null || httpResponse.getStatusLine() == null) {
                log.error("[BanamaHttpClient] [get] {} [httpResponse is invalid]", (Object)"[SYS_ERROR]");
                List<Cookie> list = null;
                return list;
            }
            if (200 != httpResponse.getStatusLine().getStatusCode()) {
                log.error("[BanamaHttpClient] [get] {} [httpStatus != 200]", (Object)"[SYS_ERROR]");
                log.error("[BanamaHttpClient] [get] [response status:" + httpResponse.getStatusLine().getStatusCode() + "]");
                List<Cookie> list = null;
                return list;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                log.error("[BanamaHttpClient] [get] {} [httpEntity is null]", (Object)"[SYS_ERROR]");
                List<Cookie> e = null;
                return e;
            }
            httpEntity.writeTo(outputStream);
            CookieStore cookieStore = httpContext.getCookieStore();
            List cookies = cookieStore.getCookies();
            log.info("get verify image cookies:" + cookies.toString());
            List list = cookies;
            return list;
        }
        catch (Exception e) {
            log.error("[BanamaHttpClient] [get] [SYS_ERROR]", (Throwable)e);
            List<Cookie> list = null;
            return list;
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                    httpClient = null;
                }
                catch (Exception e) {
                    log.error("[BanamaHttpClient] [get] {} [free resource failed]", (Object)"[SYS_ERROR]");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String path, List<NameValuePair> params, String encoding) {
        if (path == null || params == null || encoding == null) {
            log.warn("[BanamaHttpClient] [post] {} [input invalid]", (Object)"[PARAM_ERROR]");
            return null;
        }
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build();
            HttpPost method = new HttpPost(path);
            method.setConfig(requestConfig);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
            method.setEntity((HttpEntity)entity);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method);
            if (httpResponse == null || httpResponse.getStatusLine() == null) {
                log.error("[BanamaHttpClient] [post] {} [httpResponse is invalid]", (Object)"[SYS_ERROR]");
                String string = null;
                return string;
            }
            if (200 != httpResponse.getStatusLine().getStatusCode()) {
                log.error("[BanamaHttpClient] [post] {} [httpStatus != 200]", (Object)"[SYS_ERROR]");
                log.error("[BanamaHttpClient] [post] [response status:" + httpResponse.getStatusLine().getStatusCode() + "]");
                String string = null;
                return string;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                log.error("[BanamaHttpClient] [post] {} [httpEntity is null]", (Object)"[SYS_ERROR]");
                String string = null;
                return string;
            }
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            log.error("[BanamaHttpClient] [post] [SYS_ERROR]", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                    httpClient = null;
                }
                catch (Exception e) {
                    log.error("[BanamaHttpClient] [post] {} [free resource failed]", (Object)"[SYS_ERROR]");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postWithCookie(String path, List<NameValuePair> params, String encoding, List<javax.servlet.http.Cookie> cookieList) {
        if (path == null || params == null || encoding == null) {
            log.warn("[BanamaHttpClient] [post] {} [input invalid]", (Object)"[PARAM_ERROR]");
            return null;
        }
        CloseableHttpClient httpClient = null;
        try {
            String string;
            javax.servlet.http.Cookie servletCookie2;
            HttpPost method = new HttpPost(path);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
            method.setEntity((HttpEntity)entity);
            BasicCookieStore cookieStore = new BasicCookieStore();
            if (!CollectionUtils.isEmpty(cookieList)) {
                for (javax.servlet.http.Cookie servletCookie2 : cookieList) {
                    String name = servletCookie2.getName();
                    String value = servletCookie2.getValue();
                    BasicClientCookie cookie = new BasicClientCookie(name, value);
                    cookie.setDomain(".genshuixue.com");
                    cookie.setPath("/");
                    cookie.setComment(servletCookie2.getComment());
                    cookie.setSecure(servletCookie2.getSecure());
                    cookie.setVersion(servletCookie2.getVersion());
                    if (servletCookie2.getMaxAge() > 0) {
                        Calendar now = Calendar.getInstance();
                        now.add(13, servletCookie2.getMaxAge());
                        cookie.setExpiryDate(now.getTime());
                    }
                    cookieStore.addCookie((Cookie)cookie);
                }
            }
            httpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();
            log.info("validate verify image cookie store : " + cookieStore.toString() + ".");
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method);
            if (httpResponse == null || httpResponse.getStatusLine() == null) {
                log.error("[BanamaHttpClient] [post] {} [httpResponse is invalid]", (Object)"[SYS_ERROR]");
                servletCookie2 = null;
                return servletCookie2;
            }
            if (200 != httpResponse.getStatusLine().getStatusCode()) {
                log.error("[BanamaHttpClient] [post] {} [httpStatus != 200]", (Object)"[SYS_ERROR]");
                log.error("[BanamaHttpClient] [post] [response status:" + httpResponse.getStatusLine().getStatusCode() + "]");
                servletCookie2 = null;
                return servletCookie2;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                log.error("[BanamaHttpClient] [post] {} [httpEntity is null]", (Object)"[SYS_ERROR]");
                string = null;
                return string;
            }
            string = EntityUtils.toString((HttpEntity)httpEntity);
            return string;
        }
        catch (Exception e) {
            log.error("[BanamaHttpClient] [post] [SYS_ERROR]", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                    httpClient = null;
                }
                catch (Exception e) {
                    log.error("[BanamaHttpClient] [post] {} [free resource failed]", (Object)"[SYS_ERROR]");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postWhithHeadersAndParams(String path, Map<String, String> headers, Map<String, String> params, String encoding) {
        if (path == null || encoding == null) {
            log.warn("[BanamaHttpClient] [post] {} [input invalid]", (Object)"[PARAM_ERROR]");
            return null;
        }
        CloseableHttpClient httpClient = null;
        try {
            CloseableHttpResponse httpResponse;
            Set<Map.Entry<String, String>> entrySet;
            httpClient = HttpClients.createDefault();
            HttpPost method = new HttpPost(path);
            if (headers != null && headers.size() > 0) {
                Set<Map.Entry<String, String>> entrySet2 = headers.entrySet();
                for (Map.Entry<String, String> string : entrySet2) {
                    method.addHeader(string.getKey(), string.getValue());
                }
            }
            if (params != null && params.size() > 0) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                entrySet = params.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                    paramList.add(nameValuePair);
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(paramList, encoding);
                method.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if ((httpResponse = httpClient.execute((HttpUriRequest)method)) == null || httpResponse.getStatusLine() == null) {
                log.error("[PanamaHttpClient] [post] {} [httpResponse is invalid]", (Object)"[SYS_ERROR]");
                entrySet = null;
                return entrySet;
            }
            if (200 != httpResponse.getStatusLine().getStatusCode()) {
                log.error("[PanamaHttpClient] [post] {} [httpStatus != 200]", (Object)"[SYS_ERROR]");
                log.error("[BanamaHttpClient] [post] [response status:" + httpResponse.getStatusLine().getStatusCode() + "]");
                entrySet = null;
                return entrySet;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                log.error("[BanamaHttpClient] [post] {} [httpEntity is null]", (Object)"[SYS_ERROR]");
                String string = null;
                return string;
            }
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            log.error("[BanamaHttpClient] [post] [SYS_ERROR]", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                    httpClient = null;
                }
                catch (Exception e) {
                    log.error("[BanamaHttpClient] [post] {} [free resource failed]", (Object)"[SYS_ERROR]");
                }
            }
        }
    }

    public static void main(String[] args) {
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx7e035cd134c80a8e&redirect_uri=http%3A%2F%2Fqun.umeng100.com%2Fgongzhonghao%2Fauthorization%2Finvite.wechat%3FredirectUrl%3Dhttp%253A%252F%252Fmp.weixin.qq.com%252Fs%253F__biz%253DMzA4NDk3Njk1NQ%253D%253D%2526mid%253D502780516%2526idx%253D1%2526sn%253D1f29a850dfa7cece43d730c88162bde5%2526chksm%253D07dd863030aa0f265e397f3e3fc7f88b9ef0727e929e56e3847a90110852f9a091753476d508%2523rd%2526sourceappid%253Dwxeda2214e61139c19%2526openid%253DoOwPht4F4QS9QnKXwgIh0-dIyPGg%2526taskid%253D47&response_type=code&scope=snsapi_userinfo&state=STATE&component_appid=wx874b9f4e4f91691c#wechat_redirect";
    }
}

