/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umzgh.util.tool;

import com.baijia.commons.lang.utils.http.HttpClientUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpsUtil.class);

    public static String postFile(String url, String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        String result = null;
        try {
            URL url1 = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)url1.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(30000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Cache-Control", "no-cache");
            String boundary = "-----------------------------" + System.currentTimeMillis();
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            StringBuilder sb = new StringBuilder();
            sb.append("--");
            sb.append(boundary);
            sb.append("\r\n");
            sb.append("Content-Disposition:form-data;name=\"media\";filename=\"" + file.getName() + "\";filelength=\"" + file.length() + "\"\r\n");
            String contentType = new MimetypesFileTypeMap().getContentType(file);
            sb.append("Content-Type:" + contentType + "\r\n\r\n");
            byte[] head = sb.toString().getBytes("utf-8");
            System.out.println(sb.toString());
            OutputStream out = conn.getOutputStream();
            out.write(head);
            byte[] data = new byte[1024];
            int len = 0;
            FileInputStream input = new FileInputStream(file);
            while ((len = input.read(data)) > -1) {
                out.write(data, 0, len);
            }
            input.close();
            out.write("\r\n\r\n".getBytes());
            out.write(("\r\n\r\n--" + boundary + "--\r\n").getBytes());
            out.flush();
            out.close();
            InputStream resp = conn.getInputStream();
            StringBuffer sb2 = new StringBuffer();
            while ((len = resp.read(data)) > -1) {
                sb2.append(new String(data, 0, len, "utf-8"));
            }
            resp.close();
            result = sb2.toString();
            System.out.println(result);
        }
        catch (ClientProtocolException e) {
            log.error("postFile\uff0c\u4e0d\u652f\u6301http\u534f\u8bae", (Throwable)e);
        }
        catch (IOException e) {
            log.error("postFile\u6570\u636e\u4f20\u8f93\u5931\u8d25", (Throwable)e);
        }
        log.info("url: {}, filePath: {}, result={}", new Object[]{url, filePath, result});
        return result;
    }

    public static void readAndSaveImage(String urlStr, String dstStr) throws Exception {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(1000);
        InputStream inStream = conn.getInputStream();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        File imageFile = new File(dstStr);
        FileOutputStream fileOutputStream = new FileOutputStream(imageFile);
        fileOutputStream.write(outStream.toByteArray());
        fileOutputStream.close();
    }

    public static String uploadImgToGsx(String tempFilePath, String filename) {
        String gsxUploadServerUrl = "http://test.storage.genshuixue.com/webupload.php";
        File tempFile = new File(tempFilePath);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", "1");
        HashMap<String, File> filesParam = new HashMap<String, File>();
        filesParam.put(filename, tempFile);
        try {
            String gsxUploadResponse = HttpClientUtils.doPost((String)gsxUploadServerUrl, params, filesParam);
            System.out.println(gsxUploadResponse);
        }
        catch (Exception ex) {
            log.error("exception: ", (Throwable)ex);
        }
        return null;
    }

    public static void uploadImgToWechat(String tempFilePath) {
        String url = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=NpQPu4xpfkt3n8VH6HTTJ2-8mGELaAhvi5FG7l-ZzJyY5qm4xANBzs0ntk5EFQeqC457Y9SKecq8dwSR9OuuisxM0tNcuSwVA7pIvT2wJr0du5s11jbdaYgaUfclagLWEWAdAKDRJN&type=image";
        String result = HttpsUtil.postFile(url, tempFilePath);
        System.out.println(result);
    }

    public static void main(String[] args) {
        String filepath = "/Users/bjhl/Pictures/25352950_lz4o3euc.jpeg";
        String filename = "25352950_lz4o3euc.jpeg";
        HttpsUtil.uploadImgToWechat("/Users/bjhl/Pictures/22.jpeg");
    }
}

