/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umzgh.util.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.umzgh.util.exception.InvalidAppidException;
import com.baijia.umzgh.util.tool.ControllerUtil;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPost(String url, String json) throws InvalidAppidException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(url);
        log.info("httppost:" + httppost);
        log.info("json:" + json);
        httppost.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        try {
            StringEntity s = new StringEntity(new String(json.getBytes("UTF-8"), "ISO8859_1").replace("\\u003c", "<").replace("\\u003e", ">").replace("\\u003d", "=").replace("\\u0026", "&"));
            s.setContentEncoding("UTF-8");
            httppost.setEntity((HttpEntity)s);
            httppost.addHeader("Content-Type", "application/json;charset=UTF-8");
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity entity = response.getEntity();
                log.info("response entity:" + entity.getContent());
                int size = (int)entity.getContentLength();
                InputStream is = entity.getContent();
                byte[] reqBodyBytes = ControllerUtil.readBytes(is, size);
                is.close();
                String body = new String(reqBodyBytes);
                System.out.println("response content:" + body);
                if (body.contains("40001")) {
                    throw new InvalidAppidException(body);
                }
            }
        }
        catch (ClientProtocolException clientProtocolException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPostWithoutException(String url, String json) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(url);
        httppost.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        try {
            StringEntity s = new StringEntity(new String(json.getBytes("UTF-8"), "ISO8859_1"));
            s.setContentEncoding("UTF-8");
            httppost.setEntity((HttpEntity)s);
            httppost.addHeader("Content-Type", "application/json;charset=UTF-8");
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            log.info("response Content:" + response);
        }
        catch (ClientProtocolException clientProtocolException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params) {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (!sb.toString().equals("")) {
                    sb.append("&");
                }
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
            String urlNameString = url;
            if (sb.length() > 0) {
                if (urlNameString.indexOf(63) == -1) {
                    urlNameString = url + "?";
                }
                urlNameString = urlNameString + sb.toString();
            }
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            Map<String, List<String>> map = connection.getHeaderFields();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            log.error("doGet,", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public static void readMean() {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=2ODVMjgH2n0XHb27Lyobj262-jtuFeOChlELchp0CfZJFKFnQzo787hXPSpEWlhzrY9K2WY9PAWG6hqegdCUCgJC4lGs2DZ0H6fyCxgcBBcCdPY0RRnW1Yj-uVvP1nJ4OVScAEARYV";
        JSONObject json = JSONObject.parseObject((String)HttpClientUtils.doGet((String)url, null));
        if (json.containsKey((Object)"menu")) {
            JSONArray buttonArray = json.getJSONObject("menu").getJSONArray("button");
            for (Object js : buttonArray.toArray()) {
                JSONObject buttonJson = JSONObject.parseObject((String)new Gson().toJson(js));
                for (String key : buttonJson.keySet()) {
                    System.out.println(key);
                }
            }
        }
    }

    public static Map<String, String> getUrlParams(String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            url = URLDecoder.decode(url, "utf-8");
            System.out.println(url);
            String[] arrSplit = url.split("[?]").length > 1 ? url.split("[?]")[1].split("&") : url.split("&");
            if (arrSplit.length > 0) {
                for (String strParam : arrSplit) {
                    String[] pas = strParam.split("=");
                    if (pas.length != 2) continue;
                    params.put(pas[0], pas[1]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return params;
    }

    public static void main(String[] args) {
        String url = "http%3A%2F%2Ftest-m.genshuixue.com%2Forg_class_course%2Fdetail%2F6251548004%26response_type%3Dcode%26scope%3Dsnsapi_base%26state%3DSTATE%26component_appid%3Dwxdaf8b66a815b2897%23wechat_redirect%26openid%3Dssssssss";
        url = "http%3A%2F%2Ftest-m.genshuixue.com%2Forg_class_course%2Fdetail%2F6251548004%3Fresponse_type%3Dcode%26scope%3Dsnsapi_base%26state%3DSTATE%26component_appid%3Dwxdaf8b66a815b2897%23wechat_redirect%26openid%3Dssssssss";
        Map<String, String> params = HttpClientUtil.getUrlParams(url);
        System.out.println("test");
        System.out.println("result:" + new Gson().toJson(params));
        String test = "\\u003cimg src\\u003d\"http://mmbiz.qpic.cn/mmbiz_jpg/3vk9FpgnfhN0MYZek0BeAn7QKVpUTrPpFvrrQ9O547rroRHFd2OicbM77UGvIdXvx2GBZA6xU4o506lqibU9RUibw/0?wx_fmt\\u003djpeg\" width\\u003d\"520\" height\\u003d\"278\"\\u003e";
        String content = test.replace("\\u003c", "<").replace("\\u003d", "=").replace("\\u003e", ">");
        System.out.println(content);
        String rawContent = "[{\"contentType\":1,\"content\":\"xxxxxxx\",\"isStop\":0,\"mediaId\":\"\",\"categoryId\":0}]";
        JSONArray jsonArray = JSONObject.parseArray((String)rawContent);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            System.out.println(jsonObject.getString("content"));
            System.out.println(jsonObject.getInteger("contentType"));
        }
    }
}

