/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umzgh.util.tool;

import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.detector.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorProxy {
    private static final Logger log = LoggerFactory.getLogger(DetectorProxy.class);
    private final BitMatrix image;

    public DetectorProxy(BitMatrix image) {
        this.image = image;
    }

    public float calculateModuleSize(ResultPoint topLeft, ResultPoint topRight, ResultPoint bottomLeft) {
        return (this.calculateModuleSizeOneWay(topLeft, topRight) + this.calculateModuleSizeOneWay(topLeft, bottomLeft)) / 2.0f;
    }

    private float calculateModuleSizeOneWay(ResultPoint pattern, ResultPoint otherPattern) {
        float moduleSizeEst1 = this.sizeOfBlackWhiteBlackRunBothWays((int)pattern.getX(), (int)pattern.getY(), (int)otherPattern.getX(), (int)otherPattern.getY());
        float moduleSizeEst2 = this.sizeOfBlackWhiteBlackRunBothWays((int)otherPattern.getX(), (int)otherPattern.getY(), (int)pattern.getX(), (int)pattern.getY());
        if (Float.isNaN(moduleSizeEst1)) {
            return moduleSizeEst2 / 7.0f;
        }
        if (Float.isNaN(moduleSizeEst2)) {
            return moduleSizeEst1 / 7.0f;
        }
        return (moduleSizeEst1 + moduleSizeEst2) / 14.0f;
    }

    private float sizeOfBlackWhiteBlackRunBothWays(int fromX, int fromY, int toX, int toY) {
        float result = this.sizeOfBlackWhiteBlackRun(fromX, fromY, toX, toY);
        float scale = 1.0f;
        int otherToX = fromX - (toX - fromX);
        if (otherToX < 0) {
            scale = (float)fromX / (float)(fromX - otherToX);
            otherToX = 0;
        } else if (otherToX >= this.image.getWidth()) {
            scale = (float)(this.image.getWidth() - 1 - fromX) / (float)(otherToX - fromX);
            otherToX = this.image.getWidth() - 1;
        }
        int otherToY = (int)((float)fromY - (float)(toY - fromY) * scale);
        scale = 1.0f;
        if (otherToY < 0) {
            scale = (float)fromY / (float)(fromY - otherToY);
            otherToY = 0;
        } else if (otherToY >= this.image.getHeight()) {
            scale = (float)(this.image.getHeight() - 1 - fromY) / (float)(otherToY - fromY);
            otherToY = this.image.getHeight() - 1;
        }
        otherToX = (int)((float)fromX + (float)(otherToX - fromX) * scale);
        return (result += this.sizeOfBlackWhiteBlackRun(fromX, fromY, otherToX, otherToY)) - 1.0f;
    }

    private float sizeOfBlackWhiteBlackRun(int fromX, int fromY, int toX, int toY) {
        boolean steep;
        boolean bl = steep = Math.abs(toY - fromY) > Math.abs(toX - fromX);
        if (steep) {
            int temp = fromX;
            fromX = fromY;
            fromY = temp;
            temp = toX;
            toX = toY;
            toY = temp;
        }
        int dx = Math.abs(toX - fromX);
        int dy = Math.abs(toY - fromY);
        int error = -dx / 2;
        int xstep = fromX < toX ? 1 : -1;
        int ystep = fromY < toY ? 1 : -1;
        int state = 0;
        int xLimit = toX + xstep;
        int y = fromY;
        for (int x = fromX; x != xLimit; x += xstep) {
            int realY;
            int realX;
            if (state == 1 == this.image.get(realX = steep ? y : x, realY = steep ? x : y)) {
                if (state == 2) {
                    return MathUtils.distance((int)x, (int)y, (int)fromX, (int)fromY);
                }
                ++state;
            }
            if ((error += dy) <= 0) continue;
            if (y == toY) break;
            y += ystep;
            error -= dx;
        }
        if (state == 2) {
            return MathUtils.distance((int)(toX + xstep), (int)toY, (int)fromX, (int)fromY);
        }
        return Float.NaN;
    }
}

