/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umzgh.util.response;

import com.baijia.support.web.dto.PageDto;
import com.baijia.umzgh.util.response.ResCode;
import com.baijia.umzgh.util.response.SenderTask;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;

public class Response
implements Serializable {
    int code;
    String msg;
    Object data;
    int type;
    ArrayList<SenderTask> taskList;
    PageDto pageDto;
    Integer totalCount;

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public ArrayList<SenderTask> getTaskList() {
        return this.taskList;
    }

    public void setTaskList(ArrayList<SenderTask> taskList) {
        this.taskList = taskList;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    private Response(int code, String msg, Object data, PageDto pageDto, ArrayList<SenderTask> taskList) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.pageDto = pageDto;
    }

    private Response(int code, String msg, Object data, Integer totalCount) {
        this.code = code;
        this.msg = msg;
        this.totalCount = totalCount;
        this.data = data;
    }

    private Response(int code, String msg, Object data, int type, ArrayList<SenderTask> taskList) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.type = type;
    }

    private Response(int code, String msg, Object data, ArrayList<SenderTask> taskList) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.taskList = taskList;
    }

    public static String getResponseJson(int code, String msg, Object data) {
        return Response.getResponseJson(code, msg, data, new ArrayList<SenderTask>());
    }

    public static String getSysErrorResponseJson() {
        return Response.getResponseJson(ResCode.SYS_ERROR, "\u7cfb\u7edf\u5f02\u5e38", null);
    }

    public static String getResponseJson(int code, String msg, Object data, int type) {
        Response res = new Response(code, msg, data, type, new ArrayList<SenderTask>());
        Gson gson = new Gson();
        return gson.toJson((Object)res);
    }

    public static String getResponseJson(int code, String msg, Object data, ArrayList<SenderTask> taskList) {
        Response res = new Response(code, msg, data, taskList);
        Gson gson = new Gson();
        return gson.toJson((Object)res);
    }

    public static Response buildErrorResponse(int code, String msg, Object data) {
        Response response = new Response(code, msg, data, null, null);
        return response;
    }

    public static Response buildSysErrorResponse() {
        Response response = new Response(ResCode.SYS_ERROR, "\u7cfb\u7edf\u5f02\u5e38", null, null, null);
        return response;
    }

    public static Response buildErrorResponse(int code, String msg, Object data, Integer totalCount) {
        Response response = new Response(code, msg, data, totalCount);
        return response;
    }

    public static Response buildSuccessResponse(int code, String msg, Object data, PageDto pageDto) {
        Response response = new Response(code, msg, data, pageDto, null);
        return response;
    }

    public static Response buildSuccessResponse(int code, String msg, Object data, Integer totalCount, PageDto pageDto) {
        Response response = new Response(code, msg, data, totalCount);
        return response;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        Response res = new Response(100, "abc", list, new ArrayList<SenderTask>());
        Gson gson = new Gson();
        System.out.print(gson.toJson((Object)res));
    }
}

